/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorBlockTimeStatisticContentProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorCallDetails;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorStatisticController;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.MonitorCallStackToolTipCreater;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.Section;

public class MonitorClassBlockedStatistics
extends LabelProvider
implements ITableLabelProvider,
SelectionListener {
    private static final int MONSTAT_BLOCKTIME_COL_CALLER_NUM = 0;
    private static final int MONSTAT_BLOCKTIME_COL_CALLER_DEFW = 250;
    private static final int MONSTAT_BLOCKTIME_COL_TOTAL_TIME_NUM = 1;
    private static final int MONSTAT_BLOCKTIME_COL_TOTAL_TIME_DEFW = 100;
    private static final int MONSTAT_BLOCKTIME_COL_COUNT_NUM = 2;
    private static final int MONSTAT_BLOCKTIME_COL_COUNT_DEFW = 100;
    private static final int MONSTAT_BLOCKTIME_COL_STAT_NUM = 3;
    private static final int MONSTAT_BLOCKTIME_COL_STAT_DEFW = 200;
    private static final int MONSTAT_BLOCKTIME_COL_OBJECT_NUM_NUM = 4;
    private static final int MONSTAT_BLOCKTIME_COL_OBJECT_NUM_DEFW = 100;
    private static final int MONSTAT_BLOCKTIME_COL_THREAD_NUM_NUM = 5;
    private static final int MONSTAT_BLOCKTIME_COL_THREAD_NUM_DEFW = 100;
    private static final int MONSTAT_BLOCKTIME_COL_NUM = 6;
    protected Composite _viewContainer;
    protected ViewForm _dataPane;
    protected StructuredViewer _viewer;
    protected Layout _layout = null;
    protected HyadesFormToolkit _toolkit;
    MonitorStatisticController monViewCtrl;
    MonitorBlockedStatisticsSorter _sorter;

    public MonitorClassBlockedStatistics(Section section, MonitorStatisticController monViewCtrl) {
        this.monViewCtrl = monViewCtrl;
        this._toolkit = new HyadesFormToolkit(section.getDisplay());
        this._dataPane = this._toolkit.createViewForm((Composite)section);
        this._viewContainer = this._dataPane;
        Control table = this.createTableViewer(this._dataPane);
        this._dataPane.setContent(table);
    }

    public Layout getLayout() {
        if (this._layout == null) {
            this._layout = new ColumnLayout();
            ((ColumnLayout)this._layout).maxNumColumns = 100;
        }
        return this._layout;
    }

    private Control createTableViewer(ViewForm parent) {
        Tree tree = this._toolkit.createTree((Composite)parent, 8454146);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setLayout(this.getLayout());
        tree.setLayoutData((Object)new GridData(1808));
        tree.addSelectionListener((SelectionListener)this);
        MonitorCallStackToolTipCreater.createStackTraceToolTip(tree);
        this._viewer = new TreeViewer(tree);
        this._viewer.setContentProvider(this.getContentProvider());
        this._viewer.setLabelProvider(this.getTableLabelProvider());
        this._sorter = new MonitorBlockedStatisticsSorter();
        this._viewer.setSorter((ViewerSorter)this._sorter);
        this.createColumns(tree);
        this._sorter.changeColumnSelection(0);
        this.monViewCtrl.setBlockTimeViewer(this._viewer);
        return this._viewer.getControl();
    }

    private void createColumns(Tree tree) {
        int[] colWidth = new int[6];
        String[] colTitle = new String[6];
        TreeColumn[] columns = new TreeColumn[6];
        colTitle[0] = UIMessages._MONITOR_CALLER;
        colWidth[0] = 250;
        colTitle[1] = UIMessages._TOTAL_BLOCKED_TIME;
        colWidth[1] = 100;
        colTitle[2] = UIMessages._BLOCKED_COUNT;
        colWidth[2] = 100;
        colTitle[3] = UIMessages._MAX_AVG_MIN_TIME;
        colWidth[3] = 200;
        colTitle[4] = UIMessages._OBJECT_NUMBER;
        colWidth[4] = 100;
        colTitle[5] = UIMessages._THREAD_NUMBER;
        colWidth[5] = 100;
        int i = 0;
        while (i < 6) {
            columns[i] = new TreeColumn(tree, 278528);
            columns[i].setResizable(true);
            columns[i].setText(colTitle[i]);
            columns[i].setWidth(colWidth[i]);
            columns[i].addSelectionListener(this.getColumnSelectionListener(i));
            ++i;
        }
        this._sorter.setColumns(columns);
    }

    SelectionListener getColumnSelectionListener(final int columnIndex) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MonitorClassBlockedStatistics.this._sorter.changeColumnSelection(columnIndex);
                MonitorClassBlockedStatistics.this._viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private IBaseLabelProvider getTableLabelProvider() {
        return this;
    }

    private IContentProvider getContentProvider() {
        return new MonitorBlockTimeStatisticContentProvider();
    }

    public Composite getViewContainer() {
        return this._viewContainer;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof MonitorCallDetails)) {
            return null;
        }
        MonitorCallDetails monCallDetails = (MonitorCallDetails)element;
        switch (columnIndex) {
            case 0: {
                return monCallDetails.getCallTitle();
            }
            case 1: {
                return Utils.formatTime(monCallDetails.getBlockedTime());
            }
            case 2: {
                return new Integer(monCallDetails.getBlockedCount()).toString();
            }
            case 3: {
                return String.valueOf(Utils.formatTime(monCallDetails.getMaxBlockedTime())) + " / " + Utils.formatTime(monCallDetails.getAvgBlockedTime()) + " / " + Utils.formatTime(monCallDetails.getMinBlockedTime());
            }
            case 4: {
                return new Integer(monCallDetails.getBlockedObjectsCount()).toString();
            }
            case 5: {
                return new Integer(monCallDetails.getBlockedThreadsCount()).toString();
            }
        }
        return null;
    }

    class MonitorBlockedStatisticsSorter
    extends ViewerSorter {
        private int sortedIdx = -1;
        private boolean ascOrder = true;

        MonitorBlockedStatisticsSorter() {
        }

        void changeColumnSelection(int idx) {
            if (3 == idx) {
                return;
            }
            this.ascOrder = this.sortedIdx == idx ? !this.ascOrder : true;
            this.sortedIdx = idx;
        }

        void setColumns(TreeColumn[] columns) {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(e1 instanceof MonitorCallDetails) || !(e2 instanceof MonitorCallDetails)) {
                return 0;
            }
            MonitorCallDetails cd1 = (MonitorCallDetails)e1;
            MonitorCallDetails cd2 = (MonitorCallDetails)e2;
            int result = 0;
            switch (this.sortedIdx) {
                case 0: {
                    result = cd1.getCallTitle().compareTo(cd2.getCallTitle());
                    break;
                }
                case 1: {
                    result = new Double(cd1.getBlockedTime()).compareTo(new Double(cd2.getBlockedTime()));
                    break;
                }
                case 2: {
                    result = cd1.getBlockedCount() - cd2.getBlockedCount();
                    break;
                }
                case 4: {
                    result = cd1.getBlockedObjectsCount() - cd2.getBlockedObjectsCount();
                    break;
                }
                case 5: {
                    result = cd1.getBlockedThreadsCount() - cd2.getBlockedThreadsCount();
                    break;
                }
            }
            return this.ascOrder ? result : -result;
        }

        public boolean isSorterProperty(Object element, String property) {
            return true;
        }
    }
}

