/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.HashMap;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorCallDetails;

public class MonitorClassDetails {
    protected HashMap _monWaitCallSites = new HashMap();
    protected HashMap _monBlockCallSites = new HashMap();
    protected TRCClass _monClass;
    protected double _blockTime;
    protected int _blockCount;
    protected double _waitTime;
    protected int _waitCount;

    MonitorClassDetails(TRCClass monClass) {
        this._monClass = monClass;
    }

    public int getWaitingCount() {
        return this._waitCount;
    }

    public int getBlockedCount() {
        return this._blockCount;
    }

    public TRCClass getClassObj() {
        return this._monClass;
    }

    public double getBlockedTime() {
        return this._blockTime;
    }

    public double getWaitingTime() {
        return this._waitTime;
    }

    public void updateMonitorsData(TRCThreadEvent event, double timeSpan) {
        if (event instanceof TRCThreadWaitingForObjectEvent) {
            ++this._waitCount;
            this._waitTime += timeSpan;
            MonitorCallDetails callSite = new MonitorCallDetails(event);
            if (!this._monWaitCallSites.containsKey(callSite)) {
                this._monWaitCallSites.put(callSite, callSite);
            } else {
                callSite = (MonitorCallDetails)this._monWaitCallSites.get(callSite);
            }
            callSite.updateCallData(event, timeSpan);
        } else if (event instanceof TRCThreadWaitingForLockEvent) {
            ++this._blockCount;
            this._blockTime += timeSpan;
            MonitorCallDetails callSite = new MonitorCallDetails(event);
            if (!this._monBlockCallSites.containsKey(callSite)) {
                this._monBlockCallSites.put(callSite, callSite);
            } else {
                callSite = (MonitorCallDetails)this._monBlockCallSites.get(callSite);
            }
            callSite.updateCallData(event, timeSpan);
        }
    }

    public Object[] getWaitCalls() {
        return this._monWaitCallSites.values().toArray();
    }

    public Object[] getBlockCalls() {
        return this._monBlockCallSites.values().toArray();
    }
}

