/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorClassDetails;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorClassesStatisticContentProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorStatisticController;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.Section;

public class MonitorClassStatistics
extends LabelProvider
implements ITableLabelProvider,
SelectionListener {
    private static final int MONSTAT_CLASSES_COL_CLASS_NAME_NUM = 0;
    private static final int MONSTAT_CLASSES_COL_CLASS_NAME_DEFW = 260;
    private static final int MONSTAT_CLASSES_COL_BLOCKED_COUNT_NUM = 1;
    private static final int MONSTAT_CLASSES_COL_BLOCKED_COUNT_DEFW = 100;
    private static final int MONSTAT_CLASSES_COL_BLOCKED_TIME_NUM = 2;
    private static final int MONSTAT_CLASSES_COL_BLOCKED_TIME_DEFW = 100;
    private static final int MONSTAT_CLASSES_COL_WAITED_COUNT_NUM = 3;
    private static final int MONSTAT_CLASSES_COL_WAITING_COUNT_DEFW = 100;
    private static final int MONSTAT_CLASSES_COL_WAITED_TIME_NUM = 4;
    private static final int MONSTAT_CLASSES_COL_WAITING_TIME_DEFW = 100;
    private static final int MONSTAT_CLASSES_COL_NUM = 5;
    protected Composite _viewContainer;
    protected ViewForm _dataPane;
    protected StructuredViewer _viewer;
    protected Layout _layout = null;
    protected HyadesFormToolkit _toolkit;
    protected ClassStatisticsSorter _sorter;
    MonitorStatisticController monViewCtrl;

    public MonitorClassStatistics(Section section, MonitorStatisticController monViewCtrl) {
        this.monViewCtrl = monViewCtrl;
        this._toolkit = new HyadesFormToolkit(section.getDisplay());
        this._dataPane = this._toolkit.createViewForm((Composite)section);
        this._viewContainer = this._dataPane;
        Control table = this.createTableViewer(this._dataPane);
        this._dataPane.setContent(table);
    }

    public Layout getLayout() {
        if (this._layout == null) {
            this._layout = new ColumnLayout();
            ((ColumnLayout)this._layout).maxNumColumns = 100;
        }
        return this._layout;
    }

    private Control createTableViewer(ViewForm parent) {
        Tree tree = this._toolkit.createTree((Composite)parent, 0x810000);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setLayout(this.getLayout());
        tree.setLayoutData((Object)new GridData(1808));
        tree.addSelectionListener((SelectionListener)this);
        this._viewer = new TreeViewer(tree);
        this._viewer.setContentProvider(this.getContentProvider());
        this._viewer.setLabelProvider(this.getTableLabelProvider());
        this._sorter = new ClassStatisticsSorter();
        this._viewer.setSorter((ViewerSorter)this._sorter);
        this.createColumns(tree);
        this._sorter.changeColumnSelection(0);
        this.monViewCtrl.setClassesTimeViewer(this._viewer);
        return this._viewer.getControl();
    }

    private void createColumns(Tree tree) {
        int[] colWidth = new int[5];
        String[] colTitle = new String[5];
        TreeColumn[] columns = new TreeColumn[5];
        colTitle[0] = UIMessages._THREAD_CLASS_NAME;
        colWidth[0] = 260;
        colTitle[1] = UIMessages._BLOCKED_COUNT;
        colWidth[1] = 100;
        colTitle[2] = UIMessages._THREAD_BLOCKED_TIME;
        colWidth[2] = 100;
        colTitle[3] = UIMessages._WAITING_CONUT;
        colWidth[3] = 100;
        colTitle[4] = UIMessages._THREAD_WAITING_TIME;
        colWidth[4] = 100;
        int i = 0;
        while (i < 5) {
            columns[i] = new TreeColumn(tree, 278528);
            columns[i].setResizable(true);
            columns[i].setText(colTitle[i]);
            columns[i].setWidth(colWidth[i]);
            columns[i].addSelectionListener(this.getColumnSelectionListener(i));
            ++i;
        }
        this._sorter.setColumns(columns);
    }

    SelectionListener getColumnSelectionListener(final int columnIndex) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MonitorClassStatistics.this._sorter.changeColumnSelection(columnIndex);
                MonitorClassStatistics.this._viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private IBaseLabelProvider getTableLabelProvider() {
        return this;
    }

    private IContentProvider getContentProvider() {
        return new MonitorClassesStatisticContentProvider();
    }

    public Composite getViewContainer() {
        return this._viewContainer;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (!(e.widget instanceof Tree)) {
            return;
        }
        Tree tree = (Tree)e.widget;
        TreeItem[] selectedItems = tree.getSelection();
        MonitorClassDetails[] classes = new MonitorClassDetails[selectedItems.length];
        int i = 0;
        while (i < selectedItems.length) {
            classes[i] = (MonitorClassDetails)selectedItems[i].getData();
            ++i;
        }
        this.monViewCtrl.setSelectedClass(classes[0]);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof MonitorClassDetails)) {
            return null;
        }
        MonitorClassDetails monClassDetails = (MonitorClassDetails)element;
        switch (columnIndex) {
            case 0: {
                return monClassDetails.getClassObj().getName();
            }
            case 1: {
                return new Integer(monClassDetails.getBlockedCount()).toString();
            }
            case 2: {
                return Utils.formatTime(monClassDetails.getBlockedTime());
            }
            case 3: {
                return new Integer(monClassDetails.getWaitingCount()).toString();
            }
            case 4: {
                return Utils.formatTime(monClassDetails.getWaitingTime());
            }
        }
        return null;
    }

    class ClassStatisticsSorter
    extends ViewerSorter {
        private int sortedIdx = -1;
        private boolean ascOrder = true;

        ClassStatisticsSorter() {
        }

        void changeColumnSelection(int idx) {
            this.ascOrder = this.sortedIdx == idx ? !this.ascOrder : true;
            this.sortedIdx = idx;
        }

        void setColumns(TreeColumn[] columns) {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(e1 instanceof MonitorClassDetails) || !(e2 instanceof MonitorClassDetails)) {
                return 0;
            }
            MonitorClassDetails cd1 = (MonitorClassDetails)e1;
            MonitorClassDetails cd2 = (MonitorClassDetails)e2;
            int result = 0;
            switch (this.sortedIdx) {
                case 0: {
                    result = cd1.getClassObj().getName().compareTo(cd2.getClassObj().getName());
                    break;
                }
                case 1: {
                    result = cd1.getBlockedCount() - cd2.getBlockedCount();
                    break;
                }
                case 2: {
                    result = new Double(cd1.getBlockedTime()).compareTo(new Double(cd2.getBlockedTime()));
                    break;
                }
                case 3: {
                    result = cd1.getWaitingCount() - cd2.getWaitingCount();
                    break;
                }
                case 4: {
                    result = new Double(cd1.getWaitingTime()).compareTo(new Double(cd2.getWaitingTime()));
                    break;
                }
            }
            return this.ascOrder ? result : -result;
        }

        public boolean isSorterProperty(Object element, String property) {
            return true;
        }
    }
}

