/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForLockEvent;
import org.eclipse.hyades.models.trace.TRCThreadWaitingForObjectEvent;
import org.eclipse.hyades.trace.ui.internal.util.PerftraceUtil;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorClassDetails;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorThreadDetails;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.ui.forms.widgets.Form;

public class MonitorStatisticController {
    private EObject modelRoot;
    StructuredViewer _threadsViewer;
    StructuredViewer _classesViewer;
    StructuredViewer _blockTimeViewer;
    StructuredViewer _waitTimeViewer;
    Form _classNameLable;
    HashMap _threads = new HashMap();

    public void setMOFObject(EObject object) {
        this.modelRoot = object;
        this.initialize();
    }

    public void setThreadsViewer(StructuredViewer _viewer) {
        this._threadsViewer = _viewer;
    }

    public void setClassesTimeViewer(StructuredViewer _viewer) {
        this._classesViewer = _viewer;
    }

    public void setClassLabel(Form _form) {
        this._classNameLable = _form;
    }

    public void setBlockTimeViewer(StructuredViewer _viewer) {
        this._blockTimeViewer = _viewer;
    }

    public void setWaitTimeViewer(StructuredViewer _viewer) {
        this._waitTimeViewer = _viewer;
    }

    public void update() {
        this._threadsViewer.setInput((Object)this._threads.values().toArray());
    }

    public void setSelectedThreads(MonitorThreadDetails[] threads) {
        this._classNameLable.setText(UIMessages._MONITOR_CLASS_NAME);
        this._classesViewer.setInput((Object)this.getMonitorClasses(threads));
        this._blockTimeViewer.setInput(null);
        this._waitTimeViewer.setInput(null);
    }

    private Object[] getMonitorClasses(MonitorThreadDetails[] threads) {
        return this.mergeClassDetails(threads);
    }

    private Object[] mergeClassDetails(MonitorThreadDetails[] threads) {
        if (threads.length == 1) {
            return threads[0].getClassMap().values().toArray();
        }
        HashMap<TRCClass, MonitorClassDetails> classMap = new HashMap<TRCClass, MonitorClassDetails>();
        int t = 0;
        while (t < threads.length) {
            TRCThread thread = threads[t].getThread();
            EList events = thread.getThreadEvents();
            int count = events.size();
            if (count > 0) {
                TRCThreadEvent event = (TRCThreadEvent)events.get(0);
                int i = 1;
                while (i < count) {
                    TRCThreadEvent next = (TRCThreadEvent)events.get(i);
                    double timeSpan = Math.max(next.getTime() - event.getTime(), 0.0);
                    TRCObject monObject = null;
                    MonitorClassDetails classDetails = null;
                    if (event instanceof TRCThreadWaitingForObjectEvent) {
                        monObject = ((TRCThreadWaitingForObjectEvent)event).getObjectWaitingFor();
                    } else if (event instanceof TRCThreadWaitingForLockEvent) {
                        monObject = ((TRCThreadWaitingForLockEvent)event).getLockedObject();
                    }
                    if (monObject != null) {
                        TRCClass monObjClass = PerftraceUtil.getClass((TRCObject)monObject);
                        if (!classMap.containsKey(monObjClass)) {
                            classDetails = new MonitorClassDetails(monObjClass);
                            classMap.put(monObjClass, classDetails);
                        } else {
                            classDetails = (MonitorClassDetails)classMap.get(monObjClass);
                        }
                    }
                    if (classDetails != null) {
                        classDetails.updateMonitorsData(event, timeSpan);
                    }
                    event = next;
                    ++i;
                }
            }
            ++t;
        }
        return classMap.values().toArray();
    }

    public void setSelectedClass(Object classDesc) {
        this._classNameLable.setText(String.valueOf(UIMessages._MONITOR_CLASS_NAME) + " " + ((MonitorClassDetails)classDesc).getClassObj().getName());
        this._blockTimeViewer.setInput((Object)this.getBlockObjects(classDesc));
        this._waitTimeViewer.setInput((Object)this.getWaitObjects(classDesc));
    }

    private Object[] getWaitObjects(Object classDesc) {
        if (classDesc instanceof MonitorClassDetails) {
            return ((MonitorClassDetails)classDesc).getWaitCalls();
        }
        return null;
    }

    private Object[] getBlockObjects(Object classDesc) {
        if (classDesc instanceof MonitorClassDetails) {
            return ((MonitorClassDetails)classDesc).getBlockCalls();
        }
        return null;
    }

    private void initialize() {
        Object[] allThreads = PerftraceUtil.getAllThreads((EObject)this.modelRoot, (boolean)false);
        int i = 0;
        while (i < allThreads.length) {
            this._threads.put(allThreads[i], new MonitorThreadDetails((TRCThread)allThreads[i]));
            ++i;
        }
    }
}

