/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.ui.util.HyadesFormToolkit;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorStatisticController;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorThreadDetails;
import org.eclipse.tptp.trace.jvmti.internal.client.views.MonitorThreadStatisticContentProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.Section;

public class MonitorThreadStatistics
extends LabelProvider
implements ITableLabelProvider,
SelectionListener {
    private static final int MONSTAT_THREADS_COL_THREAD_ID_NUM = 0;
    private static final int MONSTAT_THREADS_COL_THREAD_ID_DEFW = 60;
    private static final int MONSTAT_THREADS_COL_THREAD_NAME_NUM = 1;
    private static final int MONSTAT_THREADS_COL_THREAD_NAME_DEFW = 200;
    private static final int MONSTAT_THREADS_COL_BLOCKED_COUNT_NUM = 2;
    private static final int MONSTAT_THREADS_COL_BLOCKED_COUNT_DEFW = 100;
    private static final int MONSTAT_THREADS_COL_BLOCKED_TIME_NUM = 3;
    private static final int MONSTAT_THREADS_COL_BLOCKED_TIME_DEFW = 100;
    private static final int MONSTAT_THREADS_COL_WAITING_COUNT_NUM = 4;
    private static final int MONSTAT_THREADS_COL_WAITING_COUNT_DEFW = 100;
    private static final int MONSTAT_THREADS_COL_WAITING_TIME_NUM = 5;
    private static final int MONSTAT_THREADS_COL_WAITING_TIME_DEFW = 100;
    private static final int MONSTAT_THREADS_COL_NUM = 6;
    protected Composite _viewContainer;
    protected ViewForm _dataPane;
    protected StructuredViewer _viewer;
    protected ThreadStatisticsSorter _sorter;
    protected Layout _layout = null;
    protected HyadesFormToolkit _toolkit;
    MonitorStatisticController monViewCtrl;

    public MonitorThreadStatistics(Section section, MonitorStatisticController monViewCtrl) {
        this.monViewCtrl = monViewCtrl;
        this._toolkit = new HyadesFormToolkit(section.getDisplay());
        this._dataPane = this._toolkit.createViewForm((Composite)section);
        this._viewContainer = this._dataPane;
        Control table = this.createTableViewer(this._dataPane);
        this._dataPane.setContent(table);
    }

    public Layout getLayout() {
        if (this._layout == null) {
            this._layout = new ColumnLayout();
            ((ColumnLayout)this._layout).maxNumColumns = 100;
        }
        return this._layout;
    }

    private Control createTableViewer(ViewForm parent) {
        Tree tree = this._toolkit.createTree((Composite)parent, 8454146);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        tree.setLayout(this.getLayout());
        tree.setLayoutData((Object)new GridData(1808));
        tree.addSelectionListener((SelectionListener)this);
        this._viewer = new TreeViewer(tree);
        this._viewer.setContentProvider(this.getContentProvider());
        this._viewer.setLabelProvider(this.getTableLabelProvider());
        this._sorter = new ThreadStatisticsSorter();
        this._viewer.setSorter((ViewerSorter)this._sorter);
        this.createColumns(tree);
        this._sorter.changeColumnSelection(0);
        this.monViewCtrl.setThreadsViewer(this._viewer);
        return this._viewer.getControl();
    }

    private void createColumns(Tree tree) {
        int[] colWidth = new int[6];
        String[] colTitle = new String[6];
        TreeColumn[] columns = new TreeColumn[6];
        colTitle[0] = UIMessages._THREAD_ID_TITLE;
        colWidth[0] = 60;
        colTitle[1] = UIMessages._THREAD_NAME_TITLE;
        colWidth[1] = 200;
        colTitle[2] = UIMessages._BLOCKED_COUNT;
        colWidth[2] = 100;
        colTitle[3] = UIMessages._THREAD_BLOCKED_TIME;
        colWidth[3] = 100;
        colTitle[4] = UIMessages._WAITING_CONUT;
        colWidth[4] = 100;
        colTitle[5] = UIMessages._THREAD_WAITING_TIME;
        colWidth[5] = 100;
        int i = 0;
        while (i < 6) {
            columns[i] = new TreeColumn(tree, 278528);
            columns[i].setResizable(true);
            columns[i].setText(colTitle[i]);
            columns[i].setWidth(colWidth[i]);
            columns[i].addSelectionListener(this.getColumnSelectionListener(i));
            ++i;
        }
        this._sorter.setColumns(columns);
    }

    SelectionListener getColumnSelectionListener(final int columnIndex) {
        return new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MonitorThreadStatistics.this._sorter.changeColumnSelection(columnIndex);
                MonitorThreadStatistics.this._viewer.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
    }

    private IBaseLabelProvider getTableLabelProvider() {
        return this;
    }

    private IContentProvider getContentProvider() {
        return new MonitorThreadStatisticContentProvider();
    }

    public Composite getViewContainer() {
        return this._viewContainer;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (!(e.widget instanceof Tree)) {
            return;
        }
        Tree tree = (Tree)e.widget;
        TreeItem[] selectedItems = tree.getSelection();
        MonitorThreadDetails[] threads = new MonitorThreadDetails[selectedItems.length];
        int i = 0;
        while (i < selectedItems.length) {
            threads[i] = (MonitorThreadDetails)selectedItems[i].getData();
            ++i;
        }
        this.monViewCtrl.setSelectedThreads(threads);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof MonitorThreadDetails)) {
            return null;
        }
        MonitorThreadDetails threadDetails = (MonitorThreadDetails)element;
        switch (columnIndex) {
            case 0: {
                return new Integer(threadDetails.getThread().getId()).toString();
            }
            case 1: {
                return threadDetails.getThread().getName();
            }
            case 2: {
                return new Integer(threadDetails.getBlockedCount()).toString();
            }
            case 3: {
                return Utils.formatTime(threadDetails.getBlockTime()).toString();
            }
            case 4: {
                return new Integer(threadDetails.getWaitCount()).toString();
            }
            case 5: {
                return Utils.formatTime(threadDetails.getWaitingTime()).toString();
            }
        }
        return null;
    }

    class ThreadStatisticsSorter
    extends ViewerSorter {
        private int sortedIdx = -1;
        private boolean ascOrder = true;

        ThreadStatisticsSorter() {
        }

        void changeColumnSelection(int idx) {
            this.ascOrder = this.sortedIdx == idx ? !this.ascOrder : true;
            this.sortedIdx = idx;
        }

        void setColumns(TreeColumn[] columns) {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (!(e1 instanceof MonitorThreadDetails) || !(e2 instanceof MonitorThreadDetails)) {
                return 0;
            }
            MonitorThreadDetails td1 = (MonitorThreadDetails)e1;
            MonitorThreadDetails td2 = (MonitorThreadDetails)e2;
            int result = 0;
            switch (this.sortedIdx) {
                case 0: {
                    result = td1.getThread().getId() - td2.getThread().getId();
                    break;
                }
                case 1: {
                    result = td1.getThread().getName().compareTo(td2.getThread().getName());
                    break;
                }
                case 2: {
                    result = td1.getBlockedCount() - td2.getBlockedCount();
                    break;
                }
                case 3: {
                    result = new Double(td1.getBlockTime()).compareTo(new Double(td2.getBlockTime()));
                    break;
                }
                case 4: {
                    result = td1.getWaitCount() - td2.getWaitCount();
                    break;
                }
                case 5: {
                    result = new Double(td1.getWaitingTime()).compareTo(new Double(td2.getWaitingTime()));
                    break;
                }
            }
            return this.ascOrder ? result : -result;
        }

        public boolean isSorterProperty(Object element, String property) {
            return true;
        }
    }
}

