/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.actions.internal.OpenTraceViewAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class OpenTraceViewActionBase
extends OpenTraceViewAction {
    public OpenTraceViewActionBase() {
        super("");
    }

    public OpenTraceViewActionBase(String label) {
        super(label);
    }

    public OpenTraceViewActionBase(String label, ImageDescriptor image) {
        super(label, image);
    }

    boolean acceptAgentName(String name) {
        return name.equals("org.eclipse.tptp.jvmti");
    }

    boolean canDisplayObject(EObject mofObject, boolean showError) {
        boolean ret = true;
        IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (mofObject == null) {
            if (showError) {
                String msg = UIMessages.EMPTY_PROFILE_SELECTION;
                Status err = new Status(2, "org.eclipse.core.resources", msg);
                ErrorDialog.openError((Shell)window.getShell(), (String)msg, (String)"", (IStatus)err);
            }
            ret = false;
        } else {
            String name = Utils.getAgentName(mofObject);
            ret = this.acceptAgentName(name);
            if (!ret && showError) {
                String msg = UIMessages.DATA_NOT_SUPPORTED;
                String title = UIMessages.TRC_MSGT;
                String msgMain = UIMessages.ER_MSG;
                Status err = new Status(2, "org.eclipse.core.resources", msg);
                ErrorDialog.openError((Shell)window.getShell(), (String)title, (String)msgMain, (IStatus)err);
            }
        }
        return ret;
    }

    public abstract String getErrorMsg();

    void openView(boolean showError) {
        IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        EObject mofObject = this.getMofObject();
        if (!this.canDisplayObject(mofObject, showError)) {
            return;
        }
        try {
            IWorkbenchPage persp = UIPlugin.getActivePage();
            EObject objectToView = this.getObjectToView(mofObject);
            IViewPart view = persp.showView(this.getViewID());
            if (view != null && view instanceof TraceViewer) {
                ((TraceViewer)view).addViewPage(objectToView, true);
            }
        }
        catch (Exception e) {
            if (showError) {
                String msg = this.getErrorMsg();
                Status err = new Status(2, "org.eclipse.core.resources", 566, e.toString(), null);
                ErrorDialog.openError((Shell)window.getShell(), (String)msg, (String)"", (IStatus)err);
            }
            e.printStackTrace();
        }
    }

    public void run() {
        this.openView(true);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        EObject mofObject = this.getMofObject();
        action.setEnabled(this.canDisplayObject(mofObject, false));
    }

    public EObject getObjectToView(EObject selObject) {
        return TraceViewer.getObjectToView_((EObject)selObject);
    }
}

