/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.hyades.trace.views.util.internal.ColumnData;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;

public class StatisticViewColumnInfo {
    private boolean _isSortColumn = false;
    private boolean _isDeltaColumn = false;
    private ColumnData _columnData;

    public ColumnData getColumnData() {
        return this._columnData;
    }

    public boolean isSortColumn() {
        return this._isSortColumn;
    }

    public boolean isDeltaColumn() {
        return this._isDeltaColumn;
    }

    public void setSortColumn(boolean flag) {
        this._isSortColumn = flag;
    }

    public void setDeltaColumn(boolean flag) {
        this._isDeltaColumn = flag;
    }

    public static StatisticViewColumnInfo getStatisticTableColumnInfo(TreeColumn col) {
        if (col.getData() != null && col.getData() instanceof StatisticViewColumnInfo) {
            return (StatisticViewColumnInfo)col.getData();
        }
        return null;
    }

    private StatisticViewColumnInfo(BaseStatisticView statisticView, ColumnData data) {
        TreeColumn treeColumn = new TreeColumn(statisticView.getTree(), 0x40000 | data.getAlignment());
        treeColumn.setData((Object)this);
        this.initializeTreeColumn(statisticView, treeColumn, data, true);
    }

    public StatisticViewColumnInfo(BaseStatisticView statisticView, ColumnData data, boolean deltaColumnsEnabled) {
        TreeColumn treeColumn = new TreeColumn(statisticView.getTree(), 0x40000 | data.getAlignment());
        treeColumn.setData((Object)this);
        this.initializeTreeColumn(statisticView, treeColumn, data, false);
        if (deltaColumnsEnabled && data.supportsDelta()) {
            new StatisticViewColumnInfo(statisticView, data);
        }
    }

    private void initializeTreeColumn(BaseStatisticView statisticView, TreeColumn treeColumn, ColumnData data, boolean isDeltaColumn) {
        this._columnData = data;
        this._isDeltaColumn = isDeltaColumn;
        treeColumn.setResizable(data.isResizable());
        if (isDeltaColumn) {
            treeColumn.setText(String.valueOf(UIMessages._Delta) + " : " + data.name());
        } else {
            treeColumn.setText(data.name());
        }
        treeColumn.setWidth(data.width());
        treeColumn.addSelectionListener((SelectionListener)statisticView);
    }
}

