/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.views.actions.internal.ContextSelectionMenuListener;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.tptp.trace.jvmti.internal.client.views.BaseProfilerView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ICallStackProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.views.OpenCallStackViewAction;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadAnalysisPage;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadStatesView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadStatisticView;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ThreadAnalysisViewer
extends TraceViewer
implements ICallStackProvider {
    public static final String VIEW_ID = "org.eclipse.tptp.trace.jvmti.internal.client.views.ThreadAnalysisViewer";
    public static final String RUNTIME_ID = "RUNTIME_ID";
    protected Action _selectNextEvent;
    protected Action _selectPrevEvent;
    protected Action _selectNextThread;
    protected Action _selectPrevThread;
    protected Action _groupThreads;
    protected Action _filterThreads;
    protected Action drawThreadInteraction;
    protected Action _resetTimescale;
    protected Action _chooseColumns;
    protected Action _sortByColumn;
    protected Action _openCallStackView;
    protected Action showLegend;
    protected Action _zoomIn;
    protected Action _zoomOut;
    protected ContextSelectionMenuListener _contextSelectionMenuListener;
    protected int _viewTab = -1;

    public TraceViewerPage createPage(EObject mofObject) {
        return new ThreadAnalysisPage(mofObject, this);
    }

    public String getViewTitle() {
        return UIMessages.THREAD_ANALYSIS_TITLE;
    }

    public String getDefaultPageMessage() {
        return UIMessages.NO_THREAD_STATS;
    }

    public void setFocus() {
        if (this.getCurrentPage() != null) {
            this.getCurrentPage().setFocus();
        }
    }

    public void updateButtons() {
        this.refillActions();
    }

    public Object[] getViewerControls() {
        BaseProfilerView view = this.getCurrentView();
        if (view instanceof ThreadStatisticView) {
            return new Object[]{((ThreadStatisticView)view).getTree()};
        }
        return null;
    }

    public EObject getObjectToView(EObject selObject) {
        return ThreadAnalysisViewer.getObjectToView_((EObject)selObject);
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        super.makeActions();
        this.initializedMenu(true);
        this.createActions();
        this.refillActions();
    }

    public void refillActions() {
        if (this.getViewTab() == this._viewTab) {
            return;
        }
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        bars.updateActionBars();
        this._viewTab = this.getViewTab();
    }

    private void fillLocalPullDown(IMenuManager menu) {
        boolean stats;
        menu.removeAll();
        int viewTab = this.getViewTab();
        boolean bl = stats = viewTab == 0;
        if (stats) {
            menu.add((IAction)this._chooseColumns);
            menu.add((IAction)this._sortByColumn);
        }
    }

    private void fillLocalToolBar(IToolBarManager toolbar) {
        boolean states;
        toolbar.removeAll();
        int viewTab = this.getViewTab();
        boolean stats = viewTab == 0;
        boolean bl = states = viewTab == 2;
        if (states) {
            toolbar.add((IAction)this.showLegend);
            toolbar.add((IAction)this._openCallStackView);
            toolbar.add((IAction)this._resetTimescale);
            toolbar.add((IAction)this._zoomIn);
            toolbar.add((IAction)this._zoomOut);
            toolbar.add((IAction)this._selectPrevEvent);
            toolbar.add((IAction)this._selectNextEvent);
            toolbar.add((IAction)this._selectPrevThread);
            toolbar.add((IAction)this._selectNextThread);
            toolbar.add((IAction)this._groupThreads);
            toolbar.add((IAction)this._filterThreads);
            toolbar.add((IAction)this.drawThreadInteraction);
        } else if (stats) {
            toolbar.add((IAction)this._openCallStackView);
            toolbar.add((IAction)this._printColumns);
        }
    }

    private void createActions() {
        if (this._chooseColumns != null) {
            return;
        }
        String strChooseColumns = UIMessages._ChooseColumns;
        this._chooseColumns = new Action(strChooseColumns){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatisticView) {
                    ((ThreadStatisticView)view).getChooseColumnsAction().run();
                }
            }
        };
        this._chooseColumns.setText(strChooseColumns);
        TracePluginImages.setImageDescriptors((IAction)this._chooseColumns, (String)"lcl16", (String)"choosecolumn_co.gif");
        this._chooseColumns.setDescription(strChooseColumns);
        this._chooseColumns.setToolTipText(strChooseColumns);
        String strSortByColumn = UIMessages._SortByColumn;
        this._sortByColumn = new Action(strSortByColumn){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatisticView) {
                    ((ThreadStatisticView)view).getSortByColumnAction().run();
                }
            }
        };
        this._sortByColumn.setText(strSortByColumn);
        TracePluginImages.setImageDescriptors((IAction)this._sortByColumn, (String)"lcl16", (String)"alphab_sort_co.gif");
        this._sortByColumn.setDescription(strSortByColumn);
        this._sortByColumn.setToolTipText(strSortByColumn);
        this._openCallStackView = new OpenCallStackViewAction();
        this._resetTimescale = new Action(){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).resetStartFinishTime();
                }
            }
        };
        this._resetTimescale.setText(UIMessages._RESET_TIMESCALE);
        this._resetTimescale.setToolTipText(UIMessages._RESET_TIMESCALE_TTIP);
        this._resetTimescale.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.hyades.trace.views", (String)"icons/full/ctool16/home_nav.gif"));
        this._zoomIn = new Action(){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).zoomIn();
                }
            }
        };
        this._zoomIn.setText(UIMessages._ZOOM_IN);
        this._zoomIn.setToolTipText(UIMessages._ZOOM_IN_TTIP);
        this._zoomIn.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.hyades.trace.views", (String)"icons/full/clcl16/zoomin_nav.gif"));
        this._zoomOut = new Action(){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).zoomOut();
                }
            }
        };
        this._zoomOut.setText(UIMessages._ZOOM_OUT);
        this._zoomOut.setToolTipText(UIMessages._ZOOM_OUT_TTIP);
        this._zoomOut.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.hyades.trace.views", (String)"icons/full/clcl16/zoomout_nav.gif"));
        this._selectNextEvent = new Action(){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).selectNextEvent();
                }
            }
        };
        this._selectNextEvent.setText(UIMessages._NEXT_EVENT);
        this._selectNextEvent.setToolTipText(UIMessages._NEXT_EVENT_TTIP);
        this._selectNextEvent.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tptp.trace.jvmti.client", (String)"icons/full/obj16/next_event.gif"));
        this._selectPrevEvent = new Action(){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).selectPrevEvent();
                }
            }
        };
        this._selectPrevEvent.setText(UIMessages._PREV_EVENT);
        this._selectPrevEvent.setToolTipText(UIMessages._PREV_EVENT_TTIP);
        this._selectPrevEvent.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tptp.trace.jvmti.client", (String)"icons/full/obj16/prev_event.gif"));
        this._selectNextThread = new Action(){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).selectNextThread();
                }
            }
        };
        this._selectNextThread.setText(UIMessages._NEXT_THREAD);
        this._selectNextThread.setToolTipText(UIMessages._NEXT_THREAD_TTIP);
        this._selectNextThread.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tptp.trace.jvmti.client", (String)"icons/full/obj16/next_thread.gif"));
        this._selectPrevThread = new Action(){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).selectPrevThread();
                }
            }
        };
        this._selectPrevThread.setText(UIMessages._PREV_THREAD);
        this._selectPrevThread.setToolTipText(UIMessages._PREV_THREAD_TTIP);
        this._selectPrevThread.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tptp.trace.jvmti.client", (String)"icons/full/obj16/prev_thread.gif"));
        this._groupThreads = new Action("", 2){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).groupThreads(this.isChecked());
                }
            }
        };
        this._groupThreads.setChecked(true);
        this._groupThreads.setText(UIMessages._GROUP_THREADS);
        this._groupThreads.setToolTipText(UIMessages._GROUP_THREADS_TTIP);
        this._groupThreads.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tptp.trace.jvmti.client", (String)"icons/full/etool16/group_threads.gif"));
        this._groupThreads.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tptp.trace.jvmti.client", (String)"icons/full/dtool16/group_threads.gif"));
        this._filterThreads = new Action(){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).filterThreads();
                }
            }
        };
        this._filterThreads.setText(UIMessages._FILTER_THREADS);
        this._filterThreads.setToolTipText(UIMessages._FILTER_THREADS_TTIP);
        this._filterThreads.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tptp.trace.jvmti.client", (String)"icons/full/obj16/filter_threads.gif"));
        this.drawThreadInteraction = new Action(UIMessages._DRAW_THREAD_INTERACTION, 4){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).toggleThreadsInteractionDrawing();
                }
            }
        };
        this.drawThreadInteraction.setToolTipText(UIMessages._DRAW_THREAD_INTERACTION);
        this.drawThreadInteraction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tptp.trace.jvmti.client", (String)"icons/full/obj16/draw_interaction.gif"));
        this.drawThreadInteraction.setMenuCreator(new IMenuCreator(){

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                Menu menu = new Menu(parent);
                BaseProfilerView v = ThreadAnalysisViewer.this.getCurrentView();
                ThreadStatesView tsv = v != null && v instanceof ThreadStatesView ? (ThreadStatesView)v : null;
                final MenuItem mjoin = new MenuItem(menu, 32);
                mjoin.setText(UIMessages._JOIN_TERMINATE);
                if (tsv != null) {
                    mjoin.setSelection(tsv.getThreadJoinDrawing());
                }
                mjoin.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                        if (view instanceof ThreadStatesView) {
                            ((ThreadStatesView)view).setThreadJoinDrawing(mjoin.getSelection());
                        }
                    }
                });
                final MenuItem mwait = new MenuItem(menu, 32);
                mwait.setText(UIMessages._WAIT_NOTIFY);
                if (tsv != null) {
                    mwait.setSelection(tsv.getThreadWaitDrawing());
                }
                mwait.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                        if (view instanceof ThreadStatesView) {
                            ((ThreadStatesView)view).setThreadWaitDrawing(mwait.getSelection());
                        }
                    }
                });
                final MenuItem mrel = new MenuItem(menu, 32);
                mrel.setText(UIMessages._RELEASE_ACQUIRE);
                if (tsv != null) {
                    mrel.setSelection(tsv.getThreadReleaseDrawing());
                }
                mrel.addSelectionListener(new SelectionListener(){

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                        if (view instanceof ThreadStatesView) {
                            ((ThreadStatesView)view).setThreadReleaseDrawing(mrel.getSelection());
                        }
                    }
                });
                return menu;
            }

            public Menu getMenu(Menu parent) {
                return null;
            }
        });
        this.showLegend = new Action(){

            public void run() {
                BaseProfilerView view = ThreadAnalysisViewer.this.getCurrentView();
                if (view instanceof ThreadStatesView) {
                    ((ThreadStatesView)view).showLegend();
                }
            }
        };
        this.showLegend.setText(UIMessages._LEGEND);
        this.showLegend.setToolTipText(UIMessages._LEGEND_HINT);
    }

    public Object getCallStack() {
        BaseProfilerView view = this.getCurrentView();
        return view != null ? view.getSelection() : null;
    }

    public BaseProfilerView getCurrentView() {
        if (!(this.getCurrentPage() instanceof ThreadAnalysisPage)) {
            return null;
        }
        ThreadAnalysisPage page = (ThreadAnalysisPage)this.getCurrentPage();
        return page.getCurrentView();
    }

    public int getViewTab() {
        if (!(this.getCurrentPage() instanceof ThreadAnalysisPage)) {
            return -1;
        }
        ThreadAnalysisPage page = (ThreadAnalysisPage)this.getCurrentPage();
        return page.getViewTab();
    }

    public void showPage(IPage page) {
        super.showPage(page);
        this.updateButtons();
    }

    public String getViewID() {
        return VIEW_ID;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento == null) {
            return;
        }
        final String rid = memento.getString(RUNTIME_ID);
        if (rid == null) {
            return;
        }
        this.loadingTrace();
        site.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                PDProjectExplorer.getFromActivePerspective();
                TRCAgentProxy obj = PDContentProvider.getAgent((String)rid);
                if (obj != null) {
                    ThreadAnalysisViewer.this.addViewPage((EObject)obj, true);
                } else {
                    ThreadAnalysisViewer.this.loadingTraceDone();
                }
            }
        });
    }

    public void saveState(IMemento memento) {
        String rid = null;
        if (this._mofObject != null && this._mofObject instanceof TRCAgentProxy) {
            rid = ((TRCAgentProxy)this._mofObject).getRuntimeId();
        }
        if (rid != null) {
            memento.putString(RUNTIME_ID, rid);
            super.saveState(memento);
        }
    }
}

