/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.trace.TRCThread;
import org.eclipse.hyades.models.trace.TRCThreadEvent;
import org.eclipse.hyades.models.trace.impl.TRCThreadDeadAndNotifyJoinedEventImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadExecEventImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadHandoffLockEventImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadInterruptThreadEventImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadNotifyAllEventImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadNotifyEventImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadRunningEventImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadStartThreadEventImpl;
import org.eclipse.hyades.models.trace.impl.TRCThreadWaitTimeoutExceedEventImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.GroupItem;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.ITimeDataProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Item;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.ItemData;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.PlainSelection;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.ThreadItem;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TraceColorScheme;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TraceCtrl;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class ThreadStatesCtrl
extends TraceCtrl
implements FocusListener,
KeyListener,
MouseMoveListener,
MouseListener,
MouseWheelListener,
ControlListener,
SelectionListener,
MouseTrackListener,
TraverseListener {
    public static final boolean DEFAULT_DRAW_THREAD_JOIN = true;
    public static final boolean DEFAULT_DRAW_THREAD_WAIT = true;
    public static final boolean DEFAULT_DRAW_THREAD_RELEASE = true;
    private final double zoomCoeff = 1.5;
    private ITimeDataProvider _timeProvider;
    private boolean _isInFocus = false;
    private boolean _isDragCursor3 = false;
    private boolean _mouseHover = false;
    private int _topItem = 0;
    private int _itemHeight = 18;
    private int _dragState = 0;
    private int _hitIdx = 0;
    private int _dragX0 = 0;
    private int _dragX = 0;
    private int _idealNameWidth = 0;
    private double _timeStep = 0.01;
    private double _time0bak;
    private double _time1bak;
    private ItemData _data = new ItemData();
    private List _selectionListeners;
    private Rectangle _rect0 = new Rectangle(0, 0, 0, 0);
    private Rectangle _rect1 = new Rectangle(0, 0, 0, 0);
    private Cursor _dragCursor3;
    private boolean drawThreadsInteraction = false;
    private boolean drawThreadJoins = true;
    private boolean drawThreadWaits = true;
    private boolean drawThreadReleases = true;

    public ThreadStatesCtrl(Composite parent, TraceColorScheme colors) {
        super(parent, colors, 537133824);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.addMouseWheelListener(this);
        this.addTraverseListener(this);
        this.addKeyListener(this);
        this.addControlListener(this);
        this.getVerticalBar().addSelectionListener((SelectionListener)this);
        this.getHorizontalBar().addSelectionListener((SelectionListener)this);
        this._dragCursor3 = new Cursor((Device)parent.getDisplay(), 9);
    }

    public void dispose() {
        super.dispose();
        this._dragCursor3.dispose();
    }

    public void setTimeProvider(ITimeDataProvider timeProvider) {
        this._timeProvider = timeProvider;
        this.adjustScrolls();
        this.redraw();
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this._selectionListeners == null) {
            this._selectionListeners = new ArrayList();
        }
        this._selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this._selectionListeners != null) {
            this._selectionListeners.remove(listener);
        }
    }

    public void fireSelectionChanged() {
        if (this._selectionListeners != null) {
            for (SelectionListener listener : this._selectionListeners) {
                listener.widgetSelected(null);
            }
        }
    }

    public void fireDefaultSelection() {
        if (this._selectionListeners != null) {
            for (SelectionListener listener : this._selectionListeners) {
                listener.widgetDefaultSelected(null);
            }
        }
    }

    public Object[] getThreads() {
        return this._data.getThreads();
    }

    public boolean[] getThreadFilter() {
        return this._data.getThreadFilter();
    }

    public void refreshData() {
        this._data.refreshData();
        this.adjustScrolls();
        this.redraw();
    }

    public void refreshData(Object[] threads) {
        this._data.refreshData(threads);
        this.adjustScrolls();
        this.redraw();
    }

    public void adjustScrolls() {
        if (this._timeProvider == null) {
            this.getVerticalBar().setValues(0, 1, 1, 1, 1, 1);
            this.getHorizontalBar().setValues(0, 1, 1, 1, 1, 1);
            return;
        }
        int page = this.countPerPage();
        if (this._topItem + page > this._data._items.length) {
            this._topItem = this._data._items.length - page;
        }
        if (this._topItem < 0) {
            this._topItem = 0;
        }
        this.getVerticalBar().setValues(this._topItem, 0, this._data._items.length, page, 1, page);
        double time0 = this._timeProvider.getTime0();
        double time1 = this._timeProvider.getTime1();
        double timeMin = this._timeProvider.getMinTime();
        double timeMax = this._timeProvider.getMaxTime();
        int timePage = (int)((time1 - time0) / this._timeStep);
        int timePos = (int)(time0 / this._timeStep);
        this.getHorizontalBar().setValues(timePos, (int)(timeMin / this._timeStep), (int)(timeMax / this._timeStep), timePage, 1, timePage);
    }

    boolean ensureVisibleItem(int idx, boolean redraw) {
        boolean changed = false;
        if (idx < 0) {
            idx = 0;
            while (idx < this._data._items.length) {
                if (((Item)this._data._items[idx])._selected) break;
                ++idx;
            }
        }
        if (idx >= this._data._items.length) {
            return changed;
        }
        if (idx < this._topItem) {
            this._topItem = idx;
            this.getVerticalBar().setSelection(this._topItem);
            if (redraw) {
                this.redraw();
            }
            changed = true;
        } else {
            int page = this.countPerPage();
            if (idx >= this._topItem + page) {
                this._topItem = idx - page + 1;
                this.getVerticalBar().setSelection(this._topItem);
                if (redraw) {
                    this.redraw();
                }
                changed = true;
            }
        }
        return changed;
    }

    public ISelection getSelection() {
        PlainSelection sel = new PlainSelection();
        TRCThread thread = this.getSelectedThread();
        if (thread != null && this._timeProvider != null) {
            double selectedTime = this._timeProvider.getSelectedTime();
            TRCThreadEvent event = Utils.findEvent(thread, selectedTime, 0);
            if (event != null) {
                sel.add(event);
            } else {
                sel.add(thread);
            }
        }
        return sel;
    }

    public void selectThread(int n) {
        if (n != 1 && n != -1) {
            return;
        }
        boolean changed = false;
        int lastSelection = -1;
        int i = 0;
        while (i < this._data._items.length) {
            Item item = (Item)this._data._items[i];
            if (item._selected) {
                lastSelection = i;
                if (1 == n && i < this._data._items.length - 1) {
                    item._selected = false;
                    if (item._hasChildren) {
                        this._data.expandItem(i, true);
                    }
                    item = (Item)this._data._items[i + 1];
                    if (item._hasChildren) {
                        this._data.expandItem(i + 1, true);
                        item = (Item)this._data._items[i + 2];
                    }
                    item._selected = true;
                    changed = true;
                    break;
                }
                if (-1 != n || i <= 0) break;
                Item prevItem = (Item)this._data._items[--i];
                if (prevItem._hasChildren) {
                    if (prevItem._expanded && i > 0) {
                        prevItem = (Item)this._data._items[--i];
                    }
                    if (prevItem._expanded) break;
                    int added = this._data.expandItem(i, true);
                    prevItem = (Item)this._data._items[i + added];
                    item._selected = false;
                    prevItem._selected = true;
                    changed = true;
                    break;
                }
                item._selected = false;
                prevItem._selected = true;
                changed = true;
                break;
            }
            ++i;
        }
        if (lastSelection < 0 && this._data._items.length > 0) {
            Item item = (Item)this._data._items[0];
            if (item._hasChildren) {
                this._data.expandItem(0, true);
                item = (Item)this._data._items[1];
                item._selected = true;
                changed = true;
            } else {
                item._selected = true;
                changed = true;
            }
        }
        if (changed) {
            this.ensureVisibleItem(-1, false);
            this.redraw();
            this.fireSelectionChanged();
        }
    }

    public void selectEvent(int n) {
        if (this._timeProvider == null) {
            return;
        }
        TRCThread thread = this.getSelectedThread();
        if (thread == this._timeProvider) {
            return;
        }
        double selectedTime = this._timeProvider.getSelectedTime();
        double endTime = this._timeProvider.getEndTime();
        TRCThreadEvent nextEvent = -1 == n && selectedTime >= endTime ? Utils.findEvent(thread, selectedTime, 0) : Utils.findEvent(thread, selectedTime, n);
        if (nextEvent == null && -1 == n) {
            nextEvent = Utils.getFirstEvent(thread);
        }
        if (nextEvent != null) {
            this._timeProvider.setSelectedTime(nextEvent.getTime(), true);
            this.fireSelectionChanged();
        } else if (1 == n) {
            this._timeProvider.setSelectedTime(endTime, true);
            this.fireSelectionChanged();
        }
    }

    public void selectNextEvent() {
        this.selectEvent(1);
    }

    public void selectPrevEvent() {
        this.selectEvent(-1);
    }

    public void selectNextThread() {
        this.selectThread(1);
    }

    public void selectPrevThread() {
        this.selectThread(-1);
    }

    public void zoomIn() {
        double _time0 = this._timeProvider.getTime0();
        double _time1 = this._timeProvider.getTime1();
        double _range = _time1 - _time0;
        double selTime = this._timeProvider.getSelectedTime();
        if (selTime <= _time0 || selTime >= _time1) {
            selTime = (_time0 + _time1) / 2.0;
        }
        double time0 = selTime - (selTime - _time0) / 1.5;
        double time1 = selTime + (_time1 - selTime) / 1.5;
        double inaccuracy = this._timeProvider.getMaxTime() - this._timeProvider.getMinTime() - (time1 - time0);
        if (inaccuracy > 0.0 && inaccuracy < 0.3) {
            this._timeProvider.setStartFinishTime(this._timeProvider.getMinTime(), this._timeProvider.getMaxTime());
            return;
        }
        double m = this._timeProvider.getMinTimeInterval();
        if (time1 - time0 < m) {
            time0 = selTime - (selTime - _time0) * m / _range;
            time1 = time0 + m;
        }
        this._timeProvider.setStartFinishTime(time0, time1);
    }

    public void zoomOut() {
        double _time0 = this._timeProvider.getTime0();
        double _time1 = this._timeProvider.getTime1();
        double selTime = this._timeProvider.getSelectedTime();
        if (selTime <= _time0 || selTime >= _time1) {
            selTime = (_time0 + _time1) / 2.0;
        }
        double time0 = selTime - (selTime - _time0) * 1.5;
        double time1 = selTime + (_time1 - selTime) * 1.5;
        double inaccuracy = this._timeProvider.getMaxTime() - this._timeProvider.getMinTime() - (time1 - time0);
        if (inaccuracy > 0.0 && inaccuracy < 0.3) {
            this._timeProvider.setStartFinishTime(this._timeProvider.getMinTime(), this._timeProvider.getMaxTime());
            return;
        }
        this._timeProvider.setStartFinishTime(time0, time1);
    }

    public void groupThreads(boolean on) {
        this._data.groupThreads(on);
        this.adjustScrolls();
        this.redraw();
    }

    public void toggleThreadsInteractionDrawing() {
        this.drawThreadsInteraction = !this.drawThreadsInteraction;
        this.redraw();
    }

    public void setThreadJoinDrawing(boolean on) {
        this.drawThreadJoins = on;
        this.drawThreadsInteraction = true;
        this.redraw();
    }

    public void setThreadWaitDrawing(boolean on) {
        this.drawThreadWaits = on;
        this.drawThreadsInteraction = true;
        this.redraw();
    }

    public void setThreadReleaseDrawing(boolean on) {
        this.drawThreadReleases = on;
        this.drawThreadsInteraction = true;
        this.redraw();
    }

    public boolean getThreadsInteractionDrawing() {
        return this.drawThreadsInteraction;
    }

    public boolean getThreadJoinDrawing() {
        return this.drawThreadJoins;
    }

    public boolean getThreadWaitDrawing() {
        return this.drawThreadWaits;
    }

    public boolean getThreadReleaseDrawing() {
        return this.drawThreadReleases;
    }

    public TRCThread getSelectedThread() {
        TRCThread thread = null;
        int idx = this.getSelectedIndex();
        if (idx >= 0 && this._data._items[idx] instanceof ThreadItem) {
            thread = ((ThreadItem)this._data._items[idx])._thread;
        }
        return thread;
    }

    public int getSelectedIndex() {
        int idx = -1;
        int i = 0;
        while (i < this._data._items.length) {
            Item item = (Item)this._data._items[i];
            if (item._selected) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    boolean toggle(int idx) {
        boolean toggled = false;
        if (idx >= 0 && idx < this._data._items.length) {
            Item item = (Item)this._data._items[idx];
            if (item._hasChildren) {
                item._expanded = !item._expanded;
                this._data.updateItems();
                this.adjustScrolls();
                this.redraw();
                toggled = true;
            }
        }
        return toggled;
    }

    int hitTest(int x, int y) {
        if (x < 0 || y < 0) {
            return -1;
        }
        int hit = -1;
        int idx = y / this._itemHeight;
        if ((idx += this._topItem) < this._data._items.length) {
            hit = idx;
        }
        return hit;
    }

    int hitSplitTest(int x, int y) {
        if (x < 0 || y < 0 || this._timeProvider == null) {
            return -1;
        }
        int w = 4;
        int hit = -1;
        int nameWidth = this._timeProvider.getNameSpace();
        if (x > nameWidth - w && x < nameWidth + w) {
            hit = 1;
        }
        return hit;
    }

    public Item getItem(Point pt) {
        int idx = this.hitTest(pt.x, pt.y);
        return idx >= 0 ? (Item)this._data._items[idx] : null;
    }

    double hitTimeTest(int x, int y) {
        if (this._timeProvider == null) {
            return -1.0;
        }
        double hitTime = -1.0;
        Point size = this.getCtrlSize();
        double time0 = this._timeProvider.getTime0();
        double time1 = this._timeProvider.getTime1();
        int nameWidth = this._timeProvider.getNameSpace();
        if ((x -= nameWidth) >= 0 && size.x >= nameWidth) {
            hitTime = time0 + (time1 - time0) * (double)x / (double)(size.x - nameWidth);
        }
        return hitTime;
    }

    void selectItem(int idx, boolean addSelection) {
        boolean changed;
        if (addSelection) {
            if (idx >= 0 && idx < this._data._items.length) {
                Item item = (Item)this._data._items[idx];
                item._selected = true;
            }
        } else {
            int i = 0;
            while (i < this._data._items.length) {
                Item item = (Item)this._data._items[i];
                item._selected = i == idx;
                ++i;
            }
        }
        if (!(changed = this.ensureVisibleItem(idx, true))) {
            this.redraw();
        }
    }

    public int countPerPage() {
        int height = this.getCtrlSize().y;
        int count = 0;
        if (height > 0) {
            count = height / this._itemHeight;
        }
        return count;
    }

    public int getTopIndex() {
        int idx = -1;
        if (this._data._items.length > 0) {
            idx = 0;
        }
        return idx;
    }

    public int getBottomIndex() {
        int idx = this._data._items.length - 1;
        return idx;
    }

    Point getCtrlSize() {
        Point size = this.getSize();
        size.x -= this.getVerticalBar().getSize().x;
        size.y -= this.getHorizontalBar().getSize().y;
        return size;
    }

    void getNameRect(Rectangle rect, Rectangle bound, int idx, int nameWidth) {
        rect.x = bound.x;
        rect.y = bound.y + (idx -= this._topItem) * this._itemHeight;
        rect.width = nameWidth;
        rect.height = this._itemHeight;
    }

    void getStatesRect(Rectangle rect, Rectangle bound, int idx, int nameWidth) {
        rect.x = bound.x + nameWidth;
        rect.y = bound.y + (idx -= this._topItem) * this._itemHeight;
        rect.width = bound.width - rect.x;
        rect.height = this._itemHeight;
    }

    private int getThreadNumber(int tid) {
        int num = -1;
        Object[] items = this._data._items;
        int i = this._topItem;
        while (i < items.length) {
            TRCThread thread;
            Item item = (Item)items[i];
            if (item instanceof ThreadItem && (thread = ((ThreadItem)item)._thread) != null && thread.getId() == tid) {
                num = i;
                break;
            }
            ++i;
        }
        return num;
    }

    private void drawArrow(GC gc, int x0, int y0, int x1, int y1, Color c) {
        gc.setForeground(c);
        gc.drawLine(x0, y0, x1, y1);
        if (y1 > y0) {
            gc.drawLine(x1 - 3, y1 - 3, x1, y1);
            gc.drawLine(x1 + 3, y1 - 3, x1, y1);
        } else {
            gc.drawLine(x1 - 3, y1 + 3, x1, y1);
            gc.drawLine(x1 + 3, y1 + 3, x1, y1);
        }
    }

    private void drawThreadThreadEvent(Rectangle bound, TRCThreadEvent e, TRCThread thread, int nItem, int color, GC gc) {
        int x1;
        double time1;
        if (thread == null) {
            return;
        }
        int tid = thread.getId();
        if (tid < 0 || this.getThreadNumber(tid) == -1) {
            return;
        }
        int nameWidth = this._timeProvider.getNameSpace();
        double time0 = this._timeProvider.getTime0();
        if (time0 == (time1 = this._timeProvider.getTime1())) {
            return;
        }
        int xr = bound.x + nameWidth;
        double K = (double)(bound.width - xr) / (time1 - time0);
        int x0 = xr + (int)((e.getTime() - time0) * K);
        if (x0 < xr) {
            x0 = xr;
        }
        if ((x1 = xr + (int)((thread.getStartTime() - time0) * K)) < xr) {
            return;
        }
        int y0 = bound.y + (nItem - this._topItem) * this._itemHeight + 3 + (this._itemHeight - 6) / 2;
        int y1 = bound.y + (this.getThreadNumber(tid) - this._topItem) * this._itemHeight + 3 + (this._itemHeight - 6) / 2;
        this.drawArrow(gc, x0, y0, x1, y1, this._colors.getColor(color));
    }

    private void drawThreadEvent(Rectangle bound, TRCThreadEvent e, int nItem, int color, GC gc) {
        double time1;
        int nameWidth = this._timeProvider.getNameSpace();
        double time0 = this._timeProvider.getTime0();
        if (time0 == (time1 = this._timeProvider.getTime1())) {
            return;
        }
        int xr = bound.x + nameWidth;
        double K = (double)(bound.width - xr) / (time1 - time0);
        int x0 = xr + (int)((e.getTime() - time0) * K);
        if (x0 < xr) {
            return;
        }
        int y0 = bound.y + (nItem - this._topItem) * this._itemHeight + 3;
        gc.setBackground(this._colors.getColor(color));
        int[] c = new int[]{x0 - 3, y0 - 3, x0, y0, x0 + 3, y0 - 3};
        gc.fillPolygon(c);
    }

    private void drawExecEvent(Rectangle bound, TRCThreadExecEventImpl e, int nitem, int color, GC gc) {
        double time1;
        EList runnings = e.getRunningEvents();
        if (runnings == null) {
            return;
        }
        int nameWidth = this._timeProvider.getNameSpace();
        double time0 = this._timeProvider.getTime0();
        if (time0 == (time1 = this._timeProvider.getTime1())) {
            return;
        }
        int xr = bound.x + nameWidth;
        double K = (double)(bound.width - xr) / (time1 - time0);
        int x0 = xr + (int)((e.getTime() - time0) * K);
        if (x0 < xr) {
            x0 = xr;
        }
        for (TRCThreadRunningEventImpl re : runnings) {
            int x1;
            int tid;
            TRCThread reThread = re.getThread();
            if (reThread == null || (tid = reThread.getId()) < 0 || this.getThreadNumber(tid) == -1 || (x1 = xr + (int)((re.getTime() - time0) * K)) < xr) continue;
            int y0 = bound.y + (nitem - this._topItem) * this._itemHeight + 3 + (this._itemHeight - 6) / 2;
            int y1 = bound.y + (this.getThreadNumber(tid) - this._topItem) * this._itemHeight + 3 + (this._itemHeight - 6) / 2;
            this.drawArrow(gc, x0, y0, x1, y1, this._colors.getColor(color));
        }
    }

    private void drawThreadInteractions(Rectangle bound, GC gc) {
        double time1;
        int nameWidth = this._timeProvider.getNameSpace();
        Object[] items = this._data._items;
        double time0 = this._timeProvider.getTime0();
        if (time0 == (time1 = this._timeProvider.getTime1())) {
            return;
        }
        int xr = bound.x + nameWidth;
        int cfr_ignored_0 = bound.width;
        int i = 0;
        while (i < items.length) {
            TRCThread thread;
            Item item = (Item)items[i];
            if (item instanceof ThreadItem && (thread = ((ThreadItem)item)._thread) != null) {
                EList list = thread.getThreadEvents();
                for (TRCThreadEvent te : list) {
                    if (te instanceof TRCThreadStartThreadEventImpl) {
                        TRCThread child = ((TRCThreadStartThreadEventImpl)te).getStartedThread();
                        this.drawThreadThreadEvent(bound, te, child, i, 25, gc);
                        continue;
                    }
                    if (te instanceof TRCThreadHandoffLockEventImpl) {
                        if (!this.drawThreadReleases) continue;
                        this.drawExecEvent(bound, (TRCThreadExecEventImpl)te, i, 37, gc);
                        continue;
                    }
                    if (te instanceof TRCThreadNotifyAllEventImpl) {
                        if (!this.drawThreadWaits) continue;
                        this.drawExecEvent(bound, (TRCThreadExecEventImpl)te, i, 36, gc);
                        continue;
                    }
                    if (te instanceof TRCThreadNotifyEventImpl) {
                        if (!this.drawThreadWaits) continue;
                        this.drawExecEvent(bound, (TRCThreadExecEventImpl)te, i, 36, gc);
                        continue;
                    }
                    if (te instanceof TRCThreadDeadAndNotifyJoinedEventImpl) {
                        if (!this.drawThreadJoins) continue;
                        this.drawExecEvent(bound, (TRCThreadExecEventImpl)te, i, 26, gc);
                        continue;
                    }
                    if (te instanceof TRCThreadInterruptThreadEventImpl) {
                        if (!this.drawThreadWaits) continue;
                        this.drawExecEvent(bound, (TRCThreadExecEventImpl)te, i, 35, gc);
                        continue;
                    }
                    if (!(te instanceof TRCThreadWaitTimeoutExceedEventImpl)) continue;
                    this.drawThreadEvent(bound, te, i, 37, gc);
                }
            }
            ++i;
        }
    }

    void paint(Rectangle bound, PaintEvent e) {
        this._itemHeight = this.getFontHeight() + 6;
        if (bound.width < 2 || bound.height < 2 || this._timeProvider == null) {
            return;
        }
        this._idealNameWidth = 0;
        GC gc = e.gc;
        int nameWidth = this._timeProvider.getNameSpace();
        double time0 = this._timeProvider.getTime0();
        double time1 = this._timeProvider.getTime1();
        double endTime = this._timeProvider.getEndTime();
        double selectedTime = this._timeProvider.getSelectedTime();
        Object[] items = this._data._items;
        int i = this._topItem;
        while (i < items.length) {
            Item item = (Item)items[i];
            this.getNameRect(this._rect0, bound, i, nameWidth);
            if (this._rect0.y >= bound.y + bound.height) break;
            if (item instanceof GroupItem) {
                this.getStatesRect(this._rect1, bound, i, nameWidth);
                this._rect0.width += this._rect1.width;
                this.drawName(item, this._rect0, gc);
            } else {
                this.drawName(item, this._rect0, gc);
            }
            this.getStatesRect(this._rect0, bound, i, nameWidth);
            this.drawItemData(item, this._rect0, time0, time1, endTime, selectedTime, gc);
            ++i;
        }
        if (this.drawThreadsInteraction) {
            this.drawThreadInteractions(bound, e.gc);
        }
        this._rect0.x = bound.x;
        this._rect0.y += this._rect0.height;
        this._rect0.width = bound.width;
        this._rect0.height = bound.y + bound.height - this._rect0.y;
        if (this._rect0.y < bound.y + bound.height) {
            gc.setBackground(this._colors.getColor(14));
            gc.fillRectangle(this._rect0);
        }
        if (3 == this._dragState) {
            gc.setForeground(this._colors.getColor(25));
            gc.drawLine(bound.x + nameWidth, bound.y, bound.x + nameWidth, bound.y + bound.height - 1);
        } else if (this._dragState == 0 && this._mouseHover) {
            gc.setForeground(this._colors.getColor(35));
            gc.drawLine(bound.x + nameWidth, bound.y, bound.x + nameWidth, bound.y + bound.height - 1);
        }
    }

    void drawName(Item item, Rectangle rect, GC gc) {
        int elemHeight;
        boolean group = item instanceof GroupItem;
        int elemWidth = elemHeight = rect.height / 2;
        String name = item._name;
        if (group) {
            gc.setBackground(this._colors.getBkColorGroup(item._selected, this._isInFocus));
            gc.fillRectangle(rect);
            if (item._selected && this._isInFocus) {
                gc.setForeground(this._colors.getBkColor(item._selected, this._isInFocus, false));
                gc.drawRectangle(rect.x, rect.y, rect.width - 2, rect.height - 2);
            }
            gc.setForeground(this._colors.getBkColor(false, false, false));
            gc.drawLine(rect.x, rect.y + rect.height - 1, rect.width - 1, rect.y + rect.height - 1);
            gc.setForeground(this._colors.getFgColorGroup(false, false));
            gc.setBackground(this._colors.getBkColor(false, false, false));
            Utils.init(this._rect1, rect);
            this._rect1.x += 4;
            this._rect1.y += (rect.height - elemHeight) / 2;
            this._rect1.width = elemWidth;
            this._rect1.height = elemHeight;
            gc.fillRectangle(this._rect1);
            gc.drawRectangle(this._rect1.x, this._rect1.y, this._rect1.width - 1, this._rect1.height - 1);
            int p = this._rect1.y + this._rect1.height / 2;
            gc.drawLine(this._rect1.x + 2, p, this._rect1.x + this._rect1.width - 3, p);
            if (!item._expanded) {
                p = this._rect1.x + this._rect1.width / 2;
                gc.drawLine(p, this._rect1.y + 2, p, this._rect1.y + this._rect1.height - 3);
            }
            gc.setForeground(this._colors.getFgColorGroup(item._selected, this._isInFocus));
            elemWidth += 4;
        } else {
            gc.setBackground(this._colors.getBkColor(item._selected, this._isInFocus, true));
            gc.setForeground(this._colors.getFgColor(item._selected, this._isInFocus));
            gc.fillRectangle(rect);
            Utils.init(this._rect1, rect);
            this._rect1.x += 4;
            TRCThread thread = ((ThreadItem)item)._thread;
            Image img = Utils.getItemImage(thread);
            if (img != null) {
                this._rect1.y += (rect.height - img.getImageData().height) / 2;
                gc.drawImage(img, this._rect1.x, this._rect1.y);
            }
            elemWidth = 16;
            Point size = gc.stringExtent(name);
            if (this._idealNameWidth < size.x) {
                this._idealNameWidth = size.x;
            }
            int width = rect.width - 4 - 4 - elemWidth;
            int cuts = 0;
            while (size.x > width && name.length() > 1) {
                ++cuts;
                name = name.substring(0, name.length() - 1);
                size = gc.stringExtent(String.valueOf(name) + "...");
            }
            if (cuts > 0) {
                name = String.valueOf(name) + "...";
            }
            elemWidth += 4;
        }
        Utils.init(this._rect1, rect);
        int leftMargin = 4 + elemWidth;
        this._rect1.x += leftMargin;
        this._rect1.width -= leftMargin;
        int textWidth = 0;
        if (this._rect1.width > 0) {
            this._rect1.y += 2;
            textWidth = Utils.drawText(gc, name, this._rect1, true) + 8;
            this._rect1.y -= 2;
        }
        if (this._rect1.width > 0 && !group) {
            Utils.init(this._rect1, rect);
            this._rect1.x += leftMargin + textWidth;
            this._rect1.width -= textWidth;
            gc.setForeground(this._colors.getColor(34));
            int midy = this._rect1.y + this._rect1.height / 2;
            gc.drawLine(this._rect1.x, midy, this._rect1.x + this._rect1.width, midy);
        }
    }

    void drawItemData(Item item, Rectangle rect, double time0, double time1, double endTime, double selectedTime, GC gc) {
        int x;
        if (rect.isEmpty()) {
            return;
        }
        if (time1 <= time0) {
            gc.setBackground(this._colors.getBkColor(false, false, false));
            gc.fillRectangle(rect);
            return;
        }
        Utils.init(this._rect1, rect);
        boolean selected = item._selected;
        double K = (double)rect.width / (time1 - time0);
        boolean group = item instanceof GroupItem;
        if (!group && item instanceof ThreadItem) {
            int xEnd;
            TRCThread thread = ((ThreadItem)item)._thread;
            int x0 = rect.x;
            EList list = thread.getThreadEvents();
            int count = list.size();
            TRCThreadEvent lastEvent = null;
            if (count > 0) {
                double currEventTime;
                TRCThreadEvent currEvent = (TRCThreadEvent)list.get(0);
                TRCThreadEvent nextEvent = null;
                double nextEventTime = currEventTime = currEvent.getTime();
                x0 = rect.x + (int)((currEventTime - time0) * K);
                int xEnd2 = rect.x + (int)((time1 - time0) * K);
                int x1 = -1;
                int idx = 1;
                this._rect1.y += 3;
                this._rect1.height -= 6;
                if (x0 > rect.x) {
                    this._rect1.width = (x0 <= xEnd2 ? x0 : xEnd2) - this._rect1.x;
                    gc.setBackground(this._colors.getBkColor(selected, this._isInFocus, false));
                    gc.fillRectangle(this._rect1);
                    gc.setForeground(this._colors.getColor(34));
                    int midy = this._rect1.y + this._rect1.height / 2;
                    gc.drawLine(this._rect1.x, midy, this._rect1.x + this._rect1.width, midy);
                }
                while (x0 <= xEnd2 && currEvent != null) {
                    boolean stopped = false;
                    if (idx < count) {
                        nextEvent = (TRCThreadEvent)list.get(idx);
                        nextEventTime = nextEvent.getTime();
                        ++idx;
                    } else if (stopped) {
                        nextEvent = null;
                        nextEventTime = time1;
                    } else {
                        nextEvent = null;
                        nextEventTime = endTime;
                    }
                    x1 = rect.x + (int)((nextEventTime - time0) * K);
                    if (x1 >= rect.x) {
                        this._rect1.x = x0 >= rect.x ? x0 : rect.x;
                        this._rect1.width = (x1 <= xEnd2 ? x1 : xEnd2) - this._rect1.x;
                        boolean timeSelected = currEventTime <= selectedTime && selectedTime < nextEventTime;
                        Utils.drawState(this._colors, currEvent, this._rect1, gc, selected, false, timeSelected);
                    }
                    lastEvent = currEvent;
                    currEvent = nextEvent;
                    currEventTime = nextEventTime;
                    x0 = x1;
                }
            }
            if (x0 < (xEnd = rect.x + rect.width)) {
                this._rect1.x = x0 >= rect.x ? x0 : rect.x;
                this._rect1.width = xEnd - this._rect1.x;
                gc.setBackground(this._colors.getBkColor(selected, this._isInFocus, false));
                gc.fillRectangle(this._rect1);
                gc.setForeground(this._colors.getColor(Utils.getEventColor(lastEvent)));
                int midy = this._rect1.y + this._rect1.height / 2;
                int lw = gc.getLineWidth();
                gc.setLineWidth(2);
                gc.drawLine(this._rect1.x, midy, this._rect1.x + this._rect1.width, midy);
                gc.setLineWidth(lw);
            }
            Utils.init(this._rect1, rect);
            gc.setForeground(this._colors.getBkColor(selected, this._isInFocus, false));
            int y = this._rect1.y;
            gc.drawLine(this._rect1.x, y, this._rect1.x + this._rect1.width, y);
            gc.drawLine(this._rect1.x, ++y, this._rect1.x + this._rect1.width, y);
            gc.drawLine(this._rect1.x, ++y, this._rect1.x + this._rect1.width, y);
            y = this._rect1.y + this._rect1.height - 1;
            gc.drawLine(this._rect1.x, y, this._rect1.x + this._rect1.width, y);
            gc.drawLine(this._rect1.x, --y, this._rect1.x + this._rect1.width, y);
            gc.drawLine(this._rect1.x, --y, this._rect1.x + this._rect1.width, y);
        }
        if ((x = rect.x + (int)((selectedTime - time0) * K)) >= rect.x && x < rect.x + rect.width) {
            gc.setForeground(this._colors.getColor(41));
            if (group) {
                gc.drawLine(x, rect.y + rect.height - 1, x, rect.y + rect.height);
            } else {
                gc.drawLine(x, rect.y, x, rect.y + rect.height);
            }
        }
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.detail == 16 || e.detail == 8) {
            e.doit = true;
        }
    }

    public void keyPressed(KeyEvent e) {
        int idx = -1;
        if (0x1000007 == e.keyCode) {
            idx = this.getTopIndex();
        } else if (0x1000008 == e.keyCode) {
            idx = this.getBottomIndex();
        } else if (0x1000002 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            } else if (idx < this._data._items.length - 1) {
                ++idx;
            }
        } else if (0x1000001 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            } else if (idx > 0) {
                --idx;
            }
        } else if (0x1000003 == e.keyCode) {
            this.selectPrevEvent();
        } else if (0x1000004 == e.keyCode) {
            this.selectNextEvent();
        } else if (0x1000006 == e.keyCode) {
            int page = this.countPerPage();
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            }
            if ((idx += page) >= this._data._items.length) {
                idx = this._data._items.length - 1;
            }
        } else if (0x1000005 == e.keyCode) {
            int page = this.countPerPage();
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            }
            if ((idx -= page) < 0) {
                idx = 0;
            }
        } else if (13 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx >= 0) {
                if (this._data._items[idx] instanceof ThreadItem) {
                    this.fireDefaultSelection();
                } else if (this._data._items[idx] instanceof GroupItem) {
                    this.toggle(idx);
                }
            }
            idx = -1;
        }
        if (idx >= 0) {
            this.selectItem(idx, false);
            this.fireSelectionChanged();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this._isInFocus = true;
        this.redraw();
    }

    public void focusLost(FocusEvent e) {
        this._isInFocus = false;
        if (this._dragState != 0) {
            this.setCapture(false);
            this._dragState = 0;
        }
        this.redraw();
    }

    public void mouseMove(MouseEvent e) {
        if (this._timeProvider == null) {
            return;
        }
        Point size = this.getCtrlSize();
        if (1 == this._dragState) {
            int nameWidth = this._timeProvider.getNameSpace();
            int x = e.x - nameWidth;
            if (x > 0 && size.x > nameWidth && this._dragX != x) {
                double time0;
                this._dragX = x;
                double K = (double)(size.x - nameWidth) / (this._time1bak - this._time0bak);
                double timeDelta = (double)(this._dragX - this._dragX0) / K;
                double time1 = this._time1bak - timeDelta;
                double maxTime = this._timeProvider.getMaxTime();
                if (time1 > maxTime) {
                    time1 = maxTime;
                }
                if ((time0 = time1 - (this._time1bak - this._time0bak)) < this._timeProvider.getMinTime()) {
                    time0 = this._timeProvider.getMinTime();
                    time1 = time0 + (this._time1bak - this._time0bak);
                }
                this._timeProvider.setStartFinishTime(time0, time1);
            }
        } else if (3 == this._dragState) {
            this._dragX = e.x;
            this._timeProvider.setNameSpace(this._hitIdx + this._dragX - this._dragX0);
        } else if (this._dragState == 0) {
            boolean mouseHover;
            boolean bl = mouseHover = this.hitSplitTest(e.x, e.y) > 0;
            if (this._mouseHover != mouseHover) {
                this.redraw();
            }
            this._mouseHover = mouseHover;
        }
        this.updateCursor(e.x, e.y);
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this._timeProvider == null) {
            return;
        }
        if (1 == e.button) {
            int idx = this.hitSplitTest(e.x, e.y);
            if (idx >= 0) {
                this._timeProvider.setNameSpace(this._idealNameWidth + 12 + 16);
                return;
            }
            idx = this.hitTest(e.x, e.y);
            if (idx >= 0) {
                this.selectItem(idx, false);
                if (this._data._items[idx] instanceof ThreadItem) {
                    this.fireDefaultSelection();
                }
            }
        }
    }

    void updateCursor(int x, int y) {
        int idx = this.hitSplitTest(x, y);
        if (idx > 0 && !this._isDragCursor3) {
            this.setCursor(this._dragCursor3);
            this._isDragCursor3 = true;
        } else if (idx <= 0 && this._isDragCursor3) {
            this.setCursor(null);
            this._isDragCursor3 = false;
        }
    }

    public void mouseDown(MouseEvent e) {
        if (this._timeProvider == null) {
            return;
        }
        if (1 == e.button) {
            int idx = this.hitSplitTest(e.x, e.y);
            if (idx > 0) {
                this._dragState = 3;
                this._dragX = this._dragX0 = e.x;
                this._hitIdx = this._timeProvider.getNameSpace();
                this._time0bak = this._timeProvider.getTime0();
                this._time1bak = this._timeProvider.getTime1();
                this.redraw();
                return;
            }
            idx = this.hitTest(e.x, e.y);
            if (idx >= 0) {
                if (this._data._items[idx] instanceof ThreadItem) {
                    double hitTime = this.hitTimeTest(e.x, e.y);
                    if (hitTime >= 0.0) {
                        this._timeProvider.setSelectedTime(hitTime, false);
                        this.setCapture(true);
                        this._dragState = 1;
                        this._dragX = this._dragX0 = e.x - this._timeProvider.getNameSpace();
                        this._time0bak = this._timeProvider.getTime0();
                        this._time1bak = this._timeProvider.getTime1();
                    }
                } else if (this._data._items[idx] instanceof GroupItem) {
                    this._hitIdx = idx;
                    this._dragState = 2;
                }
                this.selectItem(idx, false);
                this.fireSelectionChanged();
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this._dragState != 0) {
            this.setCapture(false);
            if (2 == this._dragState) {
                if (this.hitTest(e.x, e.y) == this._hitIdx) {
                    this.toggle(this._hitIdx);
                }
            } else if (3 == this._dragState) {
                this.redraw();
            }
            this._dragState = 0;
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.adjustScrolls();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.getVerticalBar()) {
            this._topItem = this.getVerticalBar().getSelection();
            if (this._topItem < 0) {
                this._topItem = 0;
            }
            this.redraw();
        } else if (e.widget == this.getHorizontalBar() && this._timeProvider != null) {
            int startTime = this.getHorizontalBar().getSelection();
            double time0 = this._timeProvider.getTime0();
            double time1 = this._timeProvider.getTime1();
            double range = time1 - time0;
            time0 = this._timeStep * (double)startTime;
            time1 = time0 + range;
            this._timeProvider.setStartFinishTime(time0, time1);
        }
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        if (this._mouseHover) {
            this._mouseHover = false;
            this.redraw();
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseScrolled(MouseEvent e) {
    }
}

