/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.jvmti.internal.client.widgets;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.trace.jvmti.internal.client.views.UIMessages;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.ITimeDataProvider;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TimeDraw;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TimeDrawMicrosec;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TimeDrawMillisec;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TimeDrawNanosec;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TimeDrawSec;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TraceColorScheme;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.TraceCtrl;
import org.eclipse.tptp.trace.jvmti.internal.client.widgets.Utils;

public class TimeScaleCtrl
extends TraceCtrl
implements MouseListener,
MouseMoveListener {
    private ITimeDataProvider _timeProvider;
    private int _dragState = 0;
    private int _dragX0 = 0;
    private int _dragX = 0;
    private double _time0bak;
    private double _time1bak;
    private boolean _isInUpdate;
    private Rectangle _rect0 = new Rectangle(0, 0, 0, 0);
    private double _timeDeltaD;
    private long _timeDelta;
    private static TimeDraw[] _tds = new TimeDraw[]{new TimeDrawSec(), new TimeDrawMillisec(), new TimeDrawMicrosec(), new TimeDrawNanosec()};

    public TimeScaleCtrl(Composite parent, TraceColorScheme colors) {
        super(parent, colors, 0x200C0000);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
    }

    public void setTimeProvider(ITimeDataProvider timeProvider) {
        this._timeProvider = timeProvider;
    }

    private void calcTimeDelta(int width, double K) {
        long[] D = new long[]{1L, 2L, 5L};
        long pow = 1L;
        double powD = 1.0E-9;
        long td = pow;
        double tdD = powD;
        double dx = tdD * K;
        int i = 0;
        while (dx < (double)width) {
            td = D[i] * pow;
            tdD = (double)D[i] * powD;
            dx = tdD * K;
            if (++i != 3) continue;
            i = 0;
            pow *= 10L;
            powD *= 10.0;
        }
        this._timeDeltaD = tdD;
        this._timeDelta = td;
    }

    static TimeDraw getTimeDraw(long timeDelta) {
        TimeDraw timeDraw = timeDelta >= 1000000000L ? _tds[0] : (timeDelta >= 1000000L ? _tds[1] : (timeDelta >= 1000L ? _tds[2] : _tds[3]));
        return timeDraw;
    }

    void paint(Rectangle rect, PaintEvent e) {
        if (this._isInUpdate || this._timeProvider == null) {
            return;
        }
        GC gc = e.gc;
        if (this._timeProvider == null) {
            gc.fillRectangle(rect);
            return;
        }
        gc.setBackground(this._colors.getColor(20));
        gc.setForeground(this._colors.getColor(21));
        double time0 = this._timeProvider.getTime0();
        double time1 = this._timeProvider.getTime1();
        double selectedTime = this._timeProvider.getSelectedTime();
        int leftSpace = this._timeProvider.getNameSpace();
        int timeSpace = this._timeProvider.getTimeSpace();
        if (time1 <= time0 || timeSpace < 2) {
            gc.fillRectangle(rect);
            return;
        }
        double timeRange = time1 - time0;
        int numDigits = 8;
        if (timeRange < 1.0E-5) {
            numDigits = 16;
        } else if (timeRange < 0.01) {
            numDigits = 12;
        }
        Utils.init(this._rect0, rect);
        int labelWidth = gc.getCharWidth('0') * numDigits;
        double K = 1.0;
        if (rect.width - leftSpace > 0) {
            K = (double)timeSpace / (time1 - time0);
            this.calcTimeDelta(labelWidth, K);
        }
        TimeDraw timeDraw = TimeScaleCtrl.getTimeDraw(this._timeDelta);
        this._rect0.width = leftSpace;
        gc.fillRectangle(this._rect0);
        this._rect0.x += 4;
        this._rect0.width -= 4;
        if (this._rect0.width > 0) {
            Utils.drawText(gc, String.valueOf(UIMessages._Timescale) + " : ", this._rect0, true);
        }
        this._rect0.x -= 4;
        this._rect0.width += 4;
        this._rect0.x += leftSpace;
        this._rect0.width = rect.width - leftSpace;
        gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
        --this._rect0.height;
        gc.fillRectangle(this._rect0);
        if (this._rect0.isEmpty()) {
            return;
        }
        int x = this._rect0.x + (int)((selectedTime - time0) * K);
        if (x >= this._rect0.x && x < this._rect0.x + this._rect0.width) {
            gc.setForeground(this._colors.getColor(41));
            gc.drawLine(x, this._rect0.y + this._rect0.height - 6, x, this._rect0.y + this._rect0.height);
            gc.setForeground(this._colors.getColor(21));
        }
        this._rect0.y = rect.y;
        this._rect0.height = rect.height - 4;
        this._rect0.width = labelWidth;
        double time = Math.floor(time0 / this._timeDeltaD) * this._timeDeltaD;
        long t = (long)(time * 1.0E9);
        int y = this._rect0.y + this._rect0.height;
        while ((x = rect.x + leftSpace + (int)((time - time0) * K)) < rect.x + leftSpace + rect.width - this._rect0.width) {
            if (x >= rect.x + leftSpace) {
                gc.drawLine(x, y, x, y + 4);
                this._rect0.x = x;
                if (x + this._rect0.width <= rect.x + rect.width) {
                    timeDraw.draw(gc, t, this._rect0);
                }
            }
            time += this._timeDeltaD;
            t += this._timeDelta;
        }
    }

    public void mouseDown(MouseEvent e) {
        if (1 == e.button && this._timeProvider != null) {
            this.setCapture(true);
            this._dragState = 1;
            this._dragX = this._dragX0 = e.x - this._timeProvider.getNameSpace();
            this._time0bak = this._timeProvider.getTime0();
            this._time1bak = this._timeProvider.getTime1();
        }
    }

    public void mouseUp(MouseEvent e) {
        if (1 == this._dragState) {
            this.setCapture(false);
            this._dragState = 0;
        }
    }

    public void mouseMove(MouseEvent e) {
        int leftSpace;
        int x;
        if (this._dragX0 < 0) {
            return;
        }
        Point size = this.getSize();
        if (1 == this._dragState && this._timeProvider != null && (x = e.x - (leftSpace = this._timeProvider.getNameSpace())) > 0 && size.x > leftSpace && this._dragX != x) {
            this._dragX = x;
            double time1 = this._time0bak + (this._time1bak - this._time0bak) * (double)this._dragX0 / (double)this._dragX;
            this._timeProvider.setStartFinishTime(this._time0bak, time1);
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this._timeProvider != null) {
            this._timeProvider.resetStartFinishTime();
        }
    }
}

