/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.asm.ClassReader;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.asm.commons.EmptyVisitor;
import org.springframework.core.CollectionFactory;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.util.ClassUtils;

public class LocalVariableTableParameterNameDiscoverer
implements ParameterNameDiscoverer {
    private static Log logger = LogFactory.getLog((Class)LocalVariableTableParameterNameDiscoverer.class);
    private final Map parameterNamesCache = CollectionFactory.createConcurrentMapIfPossible(16);
    private final Map classReaderCache = new HashMap();

    public String[] getParameterNames(Method method) {
        String[] paramNames;
        block4: {
            paramNames = (String[])this.parameterNamesCache.get(method);
            if (paramNames == null) {
                try {
                    ParameterNameDiscoveringVisitor visitor = this.visitMethod(method);
                    if (visitor.foundTargetMember()) {
                        paramNames = visitor.getParameterNames();
                        this.parameterNamesCache.put(method, paramNames);
                    }
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("IOException whilst attempting to read '.class' file for class [" + method.getDeclaringClass().getName() + "] - unable to determine parameter names for method: " + method), (Throwable)ex);
                }
            }
        }
        return paramNames;
    }

    public String[] getParameterNames(Constructor ctor) {
        String[] paramNames;
        block4: {
            paramNames = (String[])this.parameterNamesCache.get(ctor);
            if (paramNames == null) {
                try {
                    ParameterNameDiscoveringVisitor visitor = this.visitConstructor(ctor);
                    if (visitor.foundTargetMember()) {
                        paramNames = visitor.getParameterNames();
                        this.parameterNamesCache.put(ctor, paramNames);
                    }
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug((Object)("IOException whilst attempting to read '.class' file for class [" + ctor.getDeclaringClass().getName() + "] - unable to determine parameter names for constructor: " + ctor), (Throwable)ex);
                }
            }
        }
        return paramNames;
    }

    private ParameterNameDiscoveringVisitor visitMethod(Method method) throws IOException {
        ClassReader classReader = this.getClassReader(method.getDeclaringClass());
        FindMethodParameterNamesClassVisitor classVisitor = new FindMethodParameterNamesClassVisitor(method);
        classReader.accept(classVisitor, false);
        return classVisitor;
    }

    private ParameterNameDiscoveringVisitor visitConstructor(Constructor ctor) throws IOException {
        ClassReader classReader = this.getClassReader(ctor.getDeclaringClass());
        FindConstructorParameterNamesClassVisitor classVisitor = new FindConstructorParameterNamesClassVisitor(ctor);
        classReader.accept(classVisitor, false);
        return classVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassReader getClassReader(Class clazz) throws IOException {
        Map map = this.classReaderCache;
        synchronized (map) {
            ClassReader classReader = (ClassReader)this.classReaderCache.get(clazz);
            if (classReader == null) {
                InputStream is = clazz.getResourceAsStream(ClassUtils.getClassFileName(clazz));
                if (is == null) {
                    throw new FileNotFoundException("Class file for class [" + clazz.getName() + "] not found");
                }
                try {
                    classReader = new ClassReader(is);
                    this.classReaderCache.put(clazz, classReader);
                }
                finally {
                    is.close();
                }
            }
            return classReader;
        }
    }

    private static class FindConstructorParameterNamesClassVisitor
    extends ParameterNameDiscoveringVisitor {
        public FindConstructorParameterNamesClassVisitor(Constructor cons) {
            super("<init>", false, cons.getParameterTypes());
            Type[] pTypes = new Type[cons.getParameterTypes().length];
            for (int i = 0; i < pTypes.length; ++i) {
                pTypes[i] = Type.getType(cons.getParameterTypes()[i]);
            }
            this.setDescriptorToMatch(Type.getMethodDescriptor(Type.VOID_TYPE, pTypes));
        }
    }

    private static class FindMethodParameterNamesClassVisitor
    extends ParameterNameDiscoveringVisitor {
        public FindMethodParameterNamesClassVisitor(Method method) {
            super(method.getName(), Modifier.isStatic(method.getModifiers()), method.getParameterTypes());
            this.setDescriptorToMatch(Type.getMethodDescriptor(method));
        }
    }

    private static class LocalVariableTableVisitor
    extends EmptyVisitor {
        private boolean isStatic;
        private ParameterNameDiscoveringVisitor memberVisitor;
        private int numParameters;
        private int[] lvtSlotIndices;
        private String[] parameterNames;
        private boolean hasLVTInfo = false;

        public LocalVariableTableVisitor(boolean isStatic, ParameterNameDiscoveringVisitor memberVisitor, int numParams, int[] lvtSlotIndices) {
            this.isStatic = isStatic;
            this.numParameters = numParams;
            this.parameterNames = new String[this.numParameters];
            this.memberVisitor = memberVisitor;
            this.lvtSlotIndices = lvtSlotIndices;
        }

        public void visitLocalVariable(String name, String description, String signature, Label start, Label end, int index) {
            this.hasLVTInfo = true;
            if (this.isMethodArgumentSlot(index)) {
                this.parameterNames[this.parameterNameIndexForSlot((int)index)] = name;
            }
        }

        public void visitEnd() {
            if (this.hasLVTInfo || this.isStatic && this.numParameters == 0) {
                this.memberVisitor.setParameterNames(this.parameterNames);
            }
        }

        private boolean isMethodArgumentSlot(int index) {
            for (int i = 0; i < this.lvtSlotIndices.length; ++i) {
                if (this.lvtSlotIndices[i] != index) continue;
                return true;
            }
            return false;
        }

        private int parameterNameIndexForSlot(int slot) {
            for (int i = 0; i < this.lvtSlotIndices.length; ++i) {
                if (this.lvtSlotIndices[i] != slot) continue;
                return i;
            }
            throw new IllegalStateException("Asked for index for a slot which failed the isMethodArgumentSlot test: " + slot);
        }
    }

    private static abstract class ParameterNameDiscoveringVisitor
    extends EmptyVisitor {
        private String methodNameToMatch;
        private String descriptorToMatch;
        private int numParamsExpected;
        private int[] lvtSlotIndex;
        private boolean foundTargetMember = false;
        private String[] parameterNames;

        public ParameterNameDiscoveringVisitor(String name, boolean isStatic, Class[] paramTypes) {
            this.methodNameToMatch = name;
            this.numParamsExpected = paramTypes.length;
            this.computeLVTSlotIndices(isStatic, paramTypes);
        }

        public void setDescriptorToMatch(String descriptor) {
            this.descriptorToMatch = descriptor;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals(this.methodNameToMatch) && desc.equals(this.descriptorToMatch)) {
                this.foundTargetMember = true;
                return new LocalVariableTableVisitor(this.isStatic(access), this, this.numParamsExpected, this.lvtSlotIndex);
            }
            return null;
        }

        private boolean isStatic(int access) {
            return (access & 8) > 0;
        }

        public boolean foundTargetMember() {
            return this.foundTargetMember;
        }

        public String[] getParameterNames() {
            if (!this.foundTargetMember()) {
                throw new IllegalStateException("Can't ask for parameter names when target member has not been found");
            }
            return this.parameterNames;
        }

        public void setParameterNames(String[] names) {
            this.parameterNames = names;
        }

        private void computeLVTSlotIndices(boolean isStatic, Class[] paramTypes) {
            this.lvtSlotIndex = new int[paramTypes.length];
            int nextIndex = isStatic ? 0 : 1;
            for (int i = 0; i < paramTypes.length; ++i) {
                this.lvtSlotIndex[i] = nextIndex++;
                if (!this.isWideType(paramTypes[i])) continue;
                nextIndex += 2;
            }
        }

        private boolean isWideType(Class aType) {
            return aType == Long.TYPE || aType == Double.TYPE;
        }
    }
}

