/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.compendium.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.osgi.context.BundleContextAware;
import org.springframework.osgi.util.OsgiServiceUtils;
import org.springframework.osgi.util.internal.MapBasedDictionary;
import org.springframework.util.Assert;

public class OsgiConfig
implements InitializingBean,
BeanFactoryAware,
BundleContextAware,
DisposableBean {
    private String pid;
    private List listeners;
    private BeanFactory beanFactory;
    private boolean factory = false;
    private BundleContext bundleContext;
    private ServiceRegistration registration;
    private static final Log log = LogFactory.getLog((Class)OsgiConfig.class);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Dictionary;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.pid, (String)"persistence id property is required");
        Iterator l = this.listeners.iterator();
        while (l.hasNext()) {
            ConfigListener listener = (ConfigListener)l.next();
            listener.resolve(this.beanFactory, this.factory);
        }
        MapBasedDictionary props = new MapBasedDictionary();
        ((Dictionary)props).put("service.pid", this.pid);
        this.registration = this.factory ? this.bundleContext.registerService(ManagedServiceFactory.class.getName(), (Object)new OsgiManagedServiceFactoryUpdater(), (Dictionary)props) : this.bundleContext.registerService(ManagedService.class.getName(), (Object)new OsgiManagedServiceUpdater(), (Dictionary)props);
    }

    public void destroy() throws Exception {
        OsgiServiceUtils.unregisterService(this.registration);
    }

    public void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setListeners(List listeners) {
        this.listeners = listeners;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public void setFactory(boolean factory) {
        this.factory = factory;
    }

    public static class ConfigListener {
        private String reference;
        private String updateMethod;
        private String deletedMethod;
        private Object bean;

        public void setReference(String reference) {
            this.reference = reference;
        }

        public void setUpdateMethod(String updateMethod) {
            this.updateMethod = updateMethod;
        }

        public void setDeletedMethod(String deletedMethod) {
            this.deletedMethod = deletedMethod;
        }

        void resolve(BeanFactory beanFactory, boolean isFactory) {
            this.bean = beanFactory.getBean(this.reference);
            if (isFactory) {
                try {
                    this.bean.getClass().getMethod(this.updateMethod, class$java$lang$String == null ? (class$java$lang$String = OsgiConfig.class$("java.lang.String")) : class$java$lang$String, class$java$util$Map == null ? (class$java$util$Map = OsgiConfig.class$("java.util.Map")) : class$java$util$Map);
                }
                catch (NoSuchMethodException e) {
                    try {
                        this.bean.getClass().getMethod(this.updateMethod, class$java$lang$String == null ? (class$java$lang$String = OsgiConfig.class$("java.lang.String")) : class$java$lang$String, class$java$util$Dictionary == null ? (class$java$util$Dictionary = OsgiConfig.class$("java.util.Dictionary")) : class$java$util$Dictionary);
                    }
                    catch (NoSuchMethodException e1) {
                        IllegalArgumentException illArgEx = new IllegalArgumentException("Invalid or missing update method for bean " + this.reference + "; requires signature " + this.updateMethod + "(java.util.Dictionary) or " + this.updateMethod + "(java.util.Map)");
                        illArgEx.initCause(e);
                        throw illArgEx;
                    }
                }
            } else {
                try {
                    this.bean.getClass().getMethod(this.updateMethod, class$java$util$Map == null ? (class$java$util$Map = OsgiConfig.class$("java.util.Map")) : class$java$util$Map);
                }
                catch (NoSuchMethodException e) {
                    try {
                        this.bean.getClass().getMethod(this.updateMethod, class$java$util$Dictionary == null ? (class$java$util$Dictionary = OsgiConfig.class$("java.util.Dictionary")) : class$java$util$Dictionary);
                    }
                    catch (NoSuchMethodException e1) {
                        IllegalArgumentException illArgEx = new IllegalArgumentException("Invalid or missing update method for bean " + this.reference + "; requires signature " + this.updateMethod + "(java.util.Dictionary) or " + this.updateMethod + "(java.util.Map)");
                        illArgEx.initCause(e);
                        throw illArgEx;
                    }
                }
            }
            if (this.deletedMethod != null) {
                try {
                    this.bean.getClass().getMethod(this.deletedMethod, class$java$lang$String == null ? (class$java$lang$String = OsgiConfig.class$("java.lang.String")) : class$java$lang$String);
                }
                catch (NoSuchMethodException e) {
                    IllegalArgumentException illArgEx = new IllegalArgumentException("Invalid or missing deleted method for bean " + this.reference + "; requires signature " + this.deletedMethod + "(java.lang.String)");
                    illArgEx.initCause(e);
                    throw illArgEx;
                }
            }
        }

        void updated(String instancePid, Dictionary properties) throws ConfigurationException {
            Method update;
            MapBasedDictionary props = new MapBasedDictionary(properties);
            try {
                update = this.bean.getClass().getMethod(this.updateMethod, class$java$lang$String == null ? (class$java$lang$String = OsgiConfig.class$("java.lang.String")) : class$java$lang$String, class$java$util$Map == null ? (class$java$util$Map = OsgiConfig.class$("java.util.Map")) : class$java$util$Map);
            }
            catch (NoSuchMethodException e) {
                try {
                    update = this.bean.getClass().getMethod(this.updateMethod, class$java$lang$String == null ? (class$java$lang$String = OsgiConfig.class$("java.lang.String")) : class$java$lang$String, class$java$util$Dictionary == null ? (class$java$util$Dictionary = OsgiConfig.class$("java.util.Dictionary")) : class$java$util$Dictionary);
                }
                catch (NoSuchMethodException e1) {
                    throw new ConfigurationException(instancePid, "Invalid or missing update method for bean " + this.reference + "; requires signature " + this.updateMethod + "(java.util.String, java.util.Dictionary) or " + this.updateMethod + "(java.util.Map)", (Throwable)e);
                }
            }
            try {
                update.invoke(this.bean, instancePid, props);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(instancePid, "Insufficient permission to invoke update method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException(instancePid, "Error updating", e.getTargetException());
            }
        }

        void updated(Dictionary properties, String servicePid) throws ConfigurationException {
            Method update;
            MapBasedDictionary props = new MapBasedDictionary(properties);
            try {
                update = this.bean.getClass().getMethod(this.updateMethod, class$java$util$Map == null ? (class$java$util$Map = OsgiConfig.class$("java.util.Map")) : class$java$util$Map);
            }
            catch (NoSuchMethodException e) {
                try {
                    update = this.bean.getClass().getMethod(this.updateMethod, class$java$util$Dictionary == null ? (class$java$util$Dictionary = OsgiConfig.class$("java.util.Dictionary")) : class$java$util$Dictionary);
                }
                catch (NoSuchMethodException e1) {
                    throw new ConfigurationException(servicePid, "Invalid or missing update method for bean " + this.reference + "; requires signature " + this.updateMethod + "(java.util.Dictionary) or " + this.updateMethod + "(java.util.Map)", (Throwable)e);
                }
            }
            try {
                update.invoke(this.bean, props);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(servicePid, "Insufficient permission to invoke update method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException(servicePid, "Error updating", e.getTargetException());
            }
        }

        void deleted(String instancePid) {
            Method deleted;
            if (this.deletedMethod == null) {
                return;
            }
            try {
                deleted = this.bean.getClass().getMethod(this.deletedMethod, class$java$lang$String == null ? (class$java$lang$String = OsgiConfig.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (NoSuchMethodException e) {
                throw (IllegalStateException)new IllegalStateException("Invalid or missing deleted method for bean " + this.reference + "; requires signature " + this.deletedMethod + "(java.lang.String)").initCause(e);
            }
            try {
                deleted.invoke(this.bean, instancePid);
            }
            catch (IllegalAccessException e) {
                throw (IllegalStateException)new IllegalStateException("Insufficient permission to invoke deleted method").initCause(e);
            }
            catch (InvocationTargetException e) {
                throw (IllegalStateException)new IllegalStateException("Error deleting").initCause(e.getTargetException());
            }
        }
    }

    private class OsgiManagedServiceFactoryUpdater
    implements ManagedServiceFactory {
        private OsgiManagedServiceFactoryUpdater() {
        }

        public void deleted(String instancePid) {
            Iterator l = OsgiConfig.this.listeners.iterator();
            while (l.hasNext()) {
                ConfigListener listener = (ConfigListener)l.next();
                listener.deleted(instancePid);
            }
        }

        public String getName() {
            return "Managed service factory updater for: [" + OsgiConfig.this.pid + "]";
        }

        public void updated(String instancePid, Dictionary properties) throws ConfigurationException {
            Iterator l = OsgiConfig.this.listeners.iterator();
            while (l.hasNext()) {
                ConfigListener listener = (ConfigListener)l.next();
                listener.updated(instancePid, properties);
            }
        }
    }

    private class OsgiManagedServiceUpdater
    implements ManagedService {
        private OsgiManagedServiceUpdater() {
        }

        public void updated(Dictionary properties) throws ConfigurationException {
            Iterator l = OsgiConfig.this.listeners.iterator();
            while (l.hasNext()) {
                ConfigListener listener = (ConfigListener)l.next();
                listener.updated(properties, OsgiConfig.this.pid);
            }
        }
    }
}

