/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.internal.aop;

import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.osgi.framework.Bundle;
import org.springframework.osgi.service.importer.ImportedOsgiServiceProxy;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.util.BundleDelegatingClassLoader;
import org.springframework.util.ObjectUtils;

public class ServiceProviderTCCLInterceptor
implements MethodInterceptor {
    private static final int hashCode = ServiceProviderTCCLInterceptor.class.hashCode() * 13;
    private final Object lock = new Object();
    private Bundle serviceBundle;
    private ClassLoader serviceClassLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        ClassLoader current = this.getServiceProvidedClassLoader();
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(current);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previous);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getServiceProvidedClassLoader() {
        Object object = this.lock;
        synchronized (object) {
            return this.serviceClassLoader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServiceProvidedClassLoader(Bundle serviceBundle) {
        Object object = this.lock;
        synchronized (object) {
            this.serviceBundle = serviceBundle;
            this.serviceClassLoader = serviceBundle != null ? BundleDelegatingClassLoader.createBundleClassLoaderFor(serviceBundle, null) : null;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ServiceProviderTCCLInterceptor) {
            ServiceProviderTCCLInterceptor oth = (ServiceProviderTCCLInterceptor)other;
            return ObjectUtils.nullSafeEquals((Object)this.serviceBundle, (Object)oth.serviceBundle);
        }
        return false;
    }

    public int hashCode() {
        return hashCode;
    }

    public class ServiceProviderTCCLListener
    implements OsgiServiceLifecycleListener {
        public void bind(Object service, Map properties) throws Exception {
            if (service instanceof ImportedOsgiServiceProxy) {
                ServiceProviderTCCLInterceptor.this.setServiceProvidedClassLoader(((ImportedOsgiServiceProxy)service).getServiceReference().getBundle());
            }
        }

        public void unbind(Object service, Map properties) throws Exception {
        }
    }
}

