/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.internal.aop;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.ObjectUtils;

public class ServiceTCCLInterceptor
implements MethodInterceptor {
    private static final int hashCode = ServiceTCCLInterceptor.class.hashCode() * 13;
    private final ClassLoader loader;

    public ServiceTCCLInterceptor(ClassLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        ClassLoader previous = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.loader);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(previous);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ServiceTCCLInterceptor) {
            ServiceTCCLInterceptor oth = (ServiceTCCLInterceptor)other;
            return ObjectUtils.nullSafeEquals((Object)this.loader, (Object)oth.loader);
        }
        return false;
    }

    public int hashCode() {
        return hashCode;
    }
}

