/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.service.importer.support;

import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceReference;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.osgi.service.importer.ImportedOsgiServiceProxy;
import org.springframework.osgi.service.importer.OsgiServiceLifecycleListener;
import org.springframework.osgi.service.importer.internal.aop.ServiceDynamicInterceptor;
import org.springframework.osgi.service.importer.internal.aop.ServiceProviderTCCLInterceptor;
import org.springframework.osgi.service.importer.internal.support.RetryTemplate;
import org.springframework.osgi.service.importer.support.AbstractOsgiServiceImportFactoryBean;
import org.springframework.osgi.service.importer.support.AbstractServiceProxyCreator;
import org.springframework.osgi.service.importer.support.Cardinality;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class OsgiServiceProxyFactoryBean
extends AbstractOsgiServiceImportFactoryBean {
    private static final Log log = LogFactory.getLog((Class)OsgiServiceProxyFactoryBean.class);
    private RetryTemplate retryTemplate = new RetryTemplate();
    private ImportedOsgiServiceProxy proxy;
    private DisposableBean disposable;

    public Class getObjectType() {
        Class clazz = this.proxy != null ? this.proxy.getClass() : (ObjectUtils.isEmpty((Object[])this.getInterfaces()) ? Object.class : this.getInterfaces()[0]);
        return clazz;
    }

    public boolean isSatisfied() {
        if (!this.isMandatory()) {
            return true;
        }
        return this.proxy == null ? true : this.proxy.getServiceReference().getBundle() != null;
    }

    Object createProxy() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"creating a single service proxy ...");
        }
        final ServiceProviderTCCLInterceptor tcclAdvice = new ServiceProviderTCCLInterceptor();
        ServiceProviderTCCLInterceptor.ServiceProviderTCCLListener tcclListener = tcclAdvice.new ServiceProviderTCCLInterceptor.ServiceProviderTCCLListener();
        final ServiceDynamicInterceptor lookupAdvice = new ServiceDynamicInterceptor(this.getBundleContext(), this.getUnifiedFilter(), this.getBeanClassLoader());
        lookupAdvice.setRequiredAtStartup(this.isMandatory());
        OsgiServiceLifecycleListener[] listeners = this.addListener(this.getListeners(), tcclListener);
        lookupAdvice.setListeners(listeners);
        lookupAdvice.setRetryTemplate(new RetryTemplate(this.retryTemplate));
        lookupAdvice.setDependencyListeners(this.getDepedencyListeners());
        lookupAdvice.setServiceImporter(this);
        AbstractServiceProxyCreator creator = new AbstractServiceProxyCreator(this.getInterfaces(), this.getBeanClassLoader(), this.getBundleContext(), this.getContextClassLoader()){

            Advice createDispatcherInterceptor(ServiceReference reference) {
                return lookupAdvice;
            }

            Advice createServiceProviderTCCLAdvice(ServiceReference reference) {
                return tcclAdvice;
            }
        };
        this.disposable = lookupAdvice;
        this.proxy = (ImportedOsgiServiceProxy)creator.createServiceProxy(lookupAdvice.getServiceReference());
        lookupAdvice.setProxy(this.proxy);
        lookupAdvice.afterPropertiesSet();
        return this.proxy;
    }

    private OsgiServiceLifecycleListener[] addListener(OsgiServiceLifecycleListener[] listeners, OsgiServiceLifecycleListener listener) {
        int size = listeners == null ? 1 : listeners.length + 1;
        OsgiServiceLifecycleListener[] list = new OsgiServiceLifecycleListener[size];
        list[0] = listener;
        if (listeners != null) {
            System.arraycopy(listeners, 0, list, 1, listeners.length);
        }
        return list;
    }

    DisposableBean getDisposable() {
        return this.disposable;
    }

    public void setRetryTimes(int maxRetries) {
        this.retryTemplate.setRetryNumbers(maxRetries);
    }

    public int getRetryTimes() {
        return this.retryTemplate.getRetryNumbers();
    }

    public void setTimeout(long millisBetweenRetries) {
        this.retryTemplate.setWaitTime(millisBetweenRetries);
    }

    public long getTimeout() {
        return this.retryTemplate.getWaitTime();
    }

    public void setCardinality(Cardinality cardinality) {
        Assert.notNull((Object)((Object)cardinality));
        Assert.isTrue((boolean)cardinality.isSingle(), (String)"only singular cardinality ('X..1') accepted");
        super.setCardinality(cardinality);
    }
}

