/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import java.util.Dictionary;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.springframework.osgi.extender.internal.util.ConfigUtils;
import org.springframework.osgi.util.OsgiStringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ApplicationContextConfiguration {
    private final Bundle bundle;
    private boolean asyncCreation = true;
    private String[] configurationLocations = new String[0];
    private boolean isSpringPoweredBundle = true;
    private boolean publishContextAsService = true;
    private boolean waitForDeps = true;
    private String toString;
    private long timeout = 300000L;
    private static final Log log = LogFactory.getLog((Class)ApplicationContextConfiguration.class);

    public ApplicationContextConfiguration(Bundle forBundle) {
        this.bundle = forBundle;
        this.initialise();
        StringBuffer buf = new StringBuffer();
        buf.append("AppCtxCfg [Bundle=");
        buf.append(OsgiStringUtils.nullSafeSymbolicName((Bundle)this.bundle));
        buf.append("]isSpringBundle=");
        buf.append(this.isSpringPoweredBundle);
        buf.append("|async=");
        buf.append(this.asyncCreation);
        buf.append("|wait-for-deps=");
        buf.append(this.waitForDeps);
        buf.append("|publishCtx=");
        buf.append(this.publishContextAsService);
        buf.append("|timeout=");
        buf.append(this.timeout / 1000L);
        buf.append("s");
        this.toString = buf.toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("configuration: " + this.toString));
        }
    }

    public boolean isSpringPoweredBundle() {
        return this.isSpringPoweredBundle;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isCreateAsynchronously() {
        return this.asyncCreation;
    }

    public boolean isPublishContextAsService() {
        return this.publishContextAsService;
    }

    public boolean isWaitForDependencies() {
        return this.waitForDeps;
    }

    public String[] getConfigurationLocations() {
        return this.configurationLocations;
    }

    private void initialise() {
        Dictionary headers = this.bundle.getHeaders();
        this.isSpringPoweredBundle = ConfigUtils.isSpringOsgiPoweredBundle(this.bundle);
        if (this.isSpringPoweredBundle) {
            String springContextHeader = ConfigUtils.getSpringContextHeader(headers);
            if (StringUtils.hasText((String)springContextHeader)) {
                long option = ConfigUtils.getTimeOut(headers);
                this.timeout = option >= 0L ? option * 1000L : option;
                this.publishContextAsService = ConfigUtils.getPublishContext(headers);
                this.asyncCreation = ConfigUtils.getCreateAsync(headers);
                this.waitForDeps = ConfigUtils.getWaitForDependencies(headers);
            }
            this.configurationLocations = ConfigUtils.getConfigLocations(headers);
            if (ObjectUtils.isEmpty((Object[])this.configurationLocations)) {
                log.error((Object)("Bundle claims to be Spring powered, but does not contain any configuration resources: " + OsgiStringUtils.nullSafeSymbolicName((Bundle)this.bundle)));
                this.isSpringPoweredBundle = false;
            }
        }
    }

    public String toString() {
        return this.toString;
    }
}

