/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.extender.internal.support;

import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceReference;
import org.springframework.osgi.service.importer.support.AbstractOsgiServiceImportFactoryBean;

public class Dependency {
    protected String filterString;
    protected Filter filter;
    protected boolean isMandatory;
    protected BundleContext bundleContext;

    public Dependency(BundleContext bc, AbstractOsgiServiceImportFactoryBean reference) {
        this.filter = reference.getUnifiedFilter();
        this.filterString = this.filter.toString();
        this.isMandatory = reference.isMandatory();
        this.bundleContext = bc;
    }

    public boolean matches(ServiceEvent event) {
        return this.filter.match(event.getServiceReference());
    }

    public void appendTo(StringBuffer sb) {
        sb.append(this.filterString);
    }

    public boolean isSatisfied() {
        ServiceReference[] refs;
        try {
            refs = this.bundleContext.getServiceReferences(null, this.filterString);
        }
        catch (InvalidSyntaxException e) {
            throw (IllegalStateException)new IllegalStateException("Filter '" + this.filterString + "' has invalid syntax: " + e.getMessage()).initCause(e);
        }
        return !this.isMandatory || refs != null && refs.length != 0;
    }

    public String toString() {
        return "Dependency on [" + this.filter + "]";
    }

    public Filter getFilter() {
        return this.filter;
    }
}

