/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.messages.DeliverServiceMessage;
import ch.ethz.iks.util.StringUtils;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

final class CodeAnalyzer
implements ClassVisitor {
    private final ClassLoader loader;
    private final ArrayList closure = new ArrayList();
    final HashSet visited = new HashSet();
    private final HashMap injections = new HashMap();
    private final HashMap importsMap;
    private final HashMap exportsMap;
    private final HashSet proxyImports = new HashSet(0);
    private final HashSet proxyExports = new HashSet(0);
    private final MethodVisitor methodVisitor = new MethodAnalyzer();
    private String currentClass;

    CodeAnalyzer(ClassLoader loader, String imports, String exports) {
        int pos;
        int i;
        String[] tokens;
        this.loader = loader;
        if (imports != null) {
            tokens = StringUtils.stringToArray(imports, ",");
            this.importsMap = new HashMap(tokens.length);
            i = 0;
            while (i < tokens.length) {
                pos = tokens[i].indexOf(";");
                if (pos > -1) {
                    this.importsMap.put(tokens[i].substring(0, pos), tokens[i].substring(pos + 1, tokens[i].length()));
                } else {
                    this.importsMap.put(tokens[i], null);
                }
                ++i;
            }
        } else {
            this.importsMap = new HashMap(0);
        }
        if (exports != null) {
            tokens = StringUtils.stringToArray(exports, ",");
            this.exportsMap = new HashMap(tokens.length);
            i = 0;
            while (i < tokens.length) {
                pos = tokens[i].indexOf(";");
                if (pos > -1) {
                    this.exportsMap.put(tokens[i].substring(0, pos), tokens[i].substring(pos + 1, tokens[i].length()));
                } else {
                    this.exportsMap.put(tokens[i], null);
                }
                ++i;
            }
        } else {
            this.exportsMap = new HashMap(0);
        }
    }

    DeliverServiceMessage analyze(String[] ifaces, String smartProxy, String[] explicitInjections, String presentation) throws ClassNotFoundException, IOException {
        this.closure.addAll(Arrays.asList(ifaces));
        if (smartProxy != null) {
            this.closure.add(smartProxy);
        }
        if (presentation != null) {
            this.closure.add(presentation);
        }
        if (explicitInjections != null) {
            this.closure.addAll(Arrays.asList(explicitInjections));
        }
        while (!this.closure.isEmpty()) {
            this.visit((String)this.closure.remove(0));
        }
        int i = 0;
        while (i < ifaces.length) {
            this.proxyImports.add(this.packageOf(ifaces[i]));
            this.proxyExports.add(this.packageOf(ifaces[i]));
            ++i;
        }
        this.proxyImports.remove("org.osgi.framework");
        this.proxyImports.remove("ch.ethz.iks.r_osgi");
        this.proxyImports.remove("ch.ethz.iks.r_osgi.types");
        this.proxyImports.remove("ch.ethz.iks.r_osgi.channels");
        StringBuffer importDeclaration = new StringBuffer();
        StringBuffer exportDeclaration = new StringBuffer();
        String[] pi = ((AbstractCollection)this.proxyImports).toArray(new String[this.proxyImports.size()]);
        int i2 = 0;
        while (i2 < pi.length) {
            importDeclaration.append(pi[i2]);
            Object v = this.importsMap.get(pi[i2]);
            if (v != null) {
                importDeclaration.append("; ");
                importDeclaration.append(v);
            }
            if (i2 < pi.length - 1) {
                importDeclaration.append(", ");
            }
            ++i2;
        }
        String[] pe = ((AbstractCollection)this.proxyExports).toArray(new String[this.proxyExports.size()]);
        int i3 = 0;
        while (i3 < pe.length) {
            exportDeclaration.append(pe[i3]);
            Object v = this.exportsMap.get(pe[i3]);
            if (v != null) {
                exportDeclaration.append("; ");
                exportDeclaration.append(v);
            }
            if (i3 < pe.length - 1) {
                exportDeclaration.append(", ");
            }
            ++i3;
        }
        DeliverServiceMessage message = new DeliverServiceMessage();
        message.setInterfaceNames(ifaces);
        message.setSmartProxyName(smartProxy);
        message.setInjections((HashMap)this.injections.clone());
        message.setImports(importDeclaration.toString());
        message.setExports(exportDeclaration.toString());
        this.visited.clear();
        this.injections.clear();
        this.closure.clear();
        return message;
    }

    private void visit(String className) throws ClassNotFoundException {
        this.currentClass = className.replace('.', '/');
        if (this.currentClass.startsWith("[L")) {
            this.currentClass = this.currentClass.substring(2);
        } else if (this.currentClass.startsWith("L")) {
            this.currentClass = this.currentClass.substring(1);
        }
        String classFile = String.valueOf(this.currentClass) + ".class";
        String pkg = this.packageOf(className);
        if (this.importsMap.containsKey(pkg) || this.exportsMap.containsKey(pkg)) {
            this.proxyExports.add(pkg);
        }
        try {
            ClassReader reader = new ClassReader(this.loader.getResourceAsStream(classFile));
            this.injections.put(classFile, reader.b);
            if (this.exportsMap.containsKey(pkg)) {
                this.proxyExports.add(pkg);
            }
            reader.accept((ClassVisitor)this, 6);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(className);
        }
    }

    private String packageOf(String cls) {
        int p = cls.lastIndexOf(".");
        return p > -1 ? cls.substring(0, p).trim() : "";
    }

    void visitType(Type t) {
        if (t.getSort() < 9) {
            this.visited.add(t.getClassName());
            return;
        }
        if (t.getSort() == 9) {
            this.visitType(t.getElementType());
            return;
        }
        if ("null".equals(t.getClassName())) {
            return;
        }
        String className = t.getClassName();
        String iClassName = className.replace('.', '/');
        if (this.visited.contains(iClassName)) {
            return;
        }
        if (className.startsWith("java")) {
            this.visited.add(iClassName);
            return;
        }
        String pkg = this.packageOf(className);
        if (this.importsMap.containsKey(pkg)) {
            this.visited.add(iClassName);
            this.proxyImports.add(pkg);
            return;
        }
        if (className.startsWith("org.osgi")) {
            this.visited.add(iClassName);
            return;
        }
        this.visited.add(iClassName);
        this.closure.add(className);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (superName != null && !this.visited.contains(superName)) {
            this.visitType(Type.getType((String)(String.valueOf('L') + superName + ';')));
        }
        int i = 0;
        while (i < interfaces.length) {
            if (!this.visited.contains(interfaces[i])) {
                this.visitType(Type.getType((String)(String.valueOf('L') + interfaces[i] + ';')));
            }
            ++i;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitEnd() {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (!this.visited.contains(desc)) {
            this.visitType(Type.getType((String)desc));
        }
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (!name.equals(this.currentClass) && !this.visited.contains(this.currentClass)) {
            this.closure.add(name.replace('/', '.'));
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Type[] methodTypes = Type.getArgumentTypes((String)desc);
        int i = 0;
        while (i < methodTypes.length) {
            if (!this.visited.contains(methodTypes[i].getClassName().replace('.', '/'))) {
                this.visitType(methodTypes[i]);
            }
            ++i;
        }
        Type returnType = Type.getReturnType((String)desc);
        if (!this.visited.contains(returnType.getClassName().replace('.', '/'))) {
            this.visitType(returnType);
        }
        if (exceptions != null) {
            int i2 = 0;
            while (i2 < exceptions.length) {
                if (!this.visited.contains(exceptions[i2])) {
                    this.visitType(Type.getType((String)(String.valueOf('L') + exceptions[i2] + ';')));
                }
                ++i2;
            }
        }
        if ((access & 0x400) == 0) {
            return this.methodVisitor;
        }
        return null;
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitSource(String source, String debug) {
    }

    final class MethodAnalyzer
    implements MethodVisitor {
        MethodAnalyzer() {
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (!CodeAnalyzer.this.visited.contains(desc)) {
                CodeAnalyzer.this.visitType(Type.getType((String)("L" + desc + ";")));
            }
            return null;
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return null;
        }

        public void visitAttribute(Attribute attr) {
        }

        public void visitCode() {
        }

        public void visitEnd() {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (!CodeAnalyzer.this.visited.contains(owner)) {
                CodeAnalyzer.this.visitType(Type.getType((String)("L" + owner + ";")));
            }
            if (!CodeAnalyzer.this.visited.contains(desc)) {
                CodeAnalyzer.this.visitType(Type.getType((String)desc));
            }
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            if (!CodeAnalyzer.this.visited.contains(desc)) {
                CodeAnalyzer.this.visitType(Type.getType((String)("L" + desc + ";")));
            }
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (!CodeAnalyzer.this.visited.contains(owner)) {
                CodeAnalyzer.this.visitType(Type.getType((String)("L" + owner + ";")));
            }
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            if (!CodeAnalyzer.this.visited.contains(desc)) {
                CodeAnalyzer.this.visitType(Type.getType((String)("L" + desc + ";")));
            }
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            if (!CodeAnalyzer.this.visited.contains(desc)) {
                CodeAnalyzer.this.visitType(Type.getType((String)("L" + desc + ";")));
            }
            return null;
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (!CodeAnalyzer.this.visited.contains(type)) {
                CodeAnalyzer.this.visitType(Type.getType((String)("L" + type + ";")));
            }
        }

        public void visitTypeInsn(int opcode, String desc) {
            if (!CodeAnalyzer.this.visited.contains(desc)) {
                CodeAnalyzer.this.visitType(Type.getType((String)("L" + desc + ";")));
            }
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitFrame(int arg0, int arg1, Object[] arg2, int arg3, Object[] arg4) {
        }
    }
}

