/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BeanSerializer
extends AbstractSerializer {
    private static final Logger log = Logger.getLogger(BeanSerializer.class.getName());
    private static final Object[] NULL_ARGS = new Object[0];
    private Method[] _methods;
    private String[] _names;
    private Object _writeReplaceFactory;
    private Method _writeReplace;

    public BeanSerializer(Class cl) {
        int i;
        this.introspectWriteReplace(cl);
        ArrayList<Method> primitiveMethods = new ArrayList<Method>();
        ArrayList<Method> compoundMethods = new ArrayList<Method>();
        while (cl != null) {
            Method[] methods = cl.getDeclaredMethods();
            i = 0;
            while (i < methods.length) {
                Class<?> type;
                String name;
                Method method = methods[i];
                if (!Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 0 && (name = method.getName()).startsWith("get") && !(type = method.getReturnType()).equals(Void.TYPE) && this.findSetter(methods, name, type) != null) {
                    method.setAccessible(true);
                    if (type.isPrimitive() || type.getName().startsWith("java.lang.") && !type.equals(Object.class)) {
                        primitiveMethods.add(method);
                    } else {
                        compoundMethods.add(method);
                    }
                }
                ++i;
            }
            cl = cl.getSuperclass();
        }
        ArrayList<Method> methodList = new ArrayList<Method>();
        methodList.addAll(primitiveMethods);
        methodList.addAll(compoundMethods);
        this._methods = new Method[methodList.size()];
        methodList.toArray(this._methods);
        this._names = new String[this._methods.length];
        i = 0;
        while (i < this._methods.length) {
            String name = this._methods[i].getName();
            name = name.substring(3);
            int j = 0;
            while (j < name.length() && Character.isUpperCase(name.charAt(j))) {
                ++j;
            }
            if (j == 1) {
                name = String.valueOf(name.substring(0, j).toLowerCase()) + name.substring(j);
            } else if (j > 1) {
                name = String.valueOf(name.substring(0, j - 1).toLowerCase()) + name.substring(j - 1);
            }
            this._names[i] = name;
            ++i;
        }
    }

    private void introspectWriteReplace(Class cl) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            String className = String.valueOf(cl.getName()) + "HessianSerializer";
            Class<?> serializerClass = Class.forName(className, false, loader);
            Object serializerObject = serializerClass.newInstance();
            Method writeReplace = this.getWriteReplace(serializerClass, cl);
            if (writeReplace != null) {
                this._writeReplaceFactory = serializerObject;
                this._writeReplace = writeReplace;
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        this._writeReplace = this.getWriteReplace(cl);
    }

    protected Method getWriteReplace(Class cl) {
        while (cl != null) {
            Method[] methods = cl.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                Method method = methods[i];
                if (method.getName().equals("writeReplace") && method.getParameterTypes().length == 0) {
                    return method;
                }
                ++i;
            }
            cl = cl.getSuperclass();
        }
        return null;
    }

    protected Method getWriteReplace(Class cl, Class param) {
        while (cl != null) {
            Method[] methodArray = cl.getDeclaredMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("writeReplace") && method.getParameterTypes().length == 1 && param.equals(method.getParameterTypes()[0])) {
                    return method;
                }
                ++n2;
            }
            cl = cl.getSuperclass();
        }
        return null;
    }

    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (out.addRef(obj)) {
            return;
        }
        Class<?> cl = obj.getClass();
        try {
            if (this._writeReplace != null) {
                Object repl = this._writeReplaceFactory != null ? this._writeReplace.invoke(this._writeReplaceFactory, obj) : this._writeReplace.invoke(obj, new Object[0]);
                out.removeRef(obj);
                out.writeObject(repl);
                out.replaceRef(repl, obj);
                return;
            }
        }
        catch (Exception e) {
            log.log(Level.FINER, e.toString(), e);
        }
        int ref = out.writeObjectBegin(cl.getName());
        if (ref < -1) {
            int i = 0;
            while (i < this._methods.length) {
                Method cfr_ignored_0 = this._methods[i];
                Object value = null;
                try {
                    value = this._methods[i].invoke(obj, null);
                }
                catch (Exception e) {
                    log.log(Level.FINE, e.toString(), e);
                }
                out.writeString(this._names[i]);
                out.writeObject(value);
                ++i;
            }
            out.writeMapEnd();
        } else {
            int i;
            if (ref == -1) {
                out.writeInt(this._names.length);
                i = 0;
                while (i < this._names.length) {
                    out.writeString(this._names[i]);
                    ++i;
                }
                out.writeObjectBegin(cl.getName());
            }
            i = 0;
            while (i < this._methods.length) {
                Method cfr_ignored_1 = this._methods[i];
                Object value = null;
                try {
                    value = this._methods[i].invoke(obj, null);
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
                out.writeObject(value);
                ++i;
            }
        }
    }

    private Method findSetter(Method[] methods, String getterName, Class arg) {
        String setterName = "set" + getterName.substring(3);
        int i = 0;
        while (i < methods.length) {
            Class<?>[] params;
            Method method = methods[i];
            if (method.getName().equals(setterName) && method.getReturnType().equals(Void.TYPE) && (params = method.getParameterTypes()).length == 1 && params[0].equals(arg)) {
                return method;
            }
            ++i;
        }
        return null;
    }
}

