/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSFile;
import com.mongodb.util.SimplePool;
import com.mongodb.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import org.bson.types.ObjectId;

public class GridFSInputFile
extends GridFSFile {
    private final InputStream _in;
    private boolean _savedChunks = false;
    private byte[] _buffer = null;
    private int _currentChunkNumber = 0;
    private int _currentBufferPosition = 0;
    private long _totalBytes = 0L;
    private MessageDigest _messageDigester = null;
    private OutputStream _outputStream = null;
    static SimplePool<MessageDigest> _md5Pool = new SimplePool<MessageDigest>("md5", 10, -1, false, false){

        @Override
        protected MessageDigest createNew() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("your system doesn't have md5!");
            }
        }
    };

    GridFSInputFile(GridFS fs, InputStream in, String filename) {
        this._fs = fs;
        this._in = in;
        this._filename = filename;
        this._id = new ObjectId();
        this._chunkSize = 262144L;
        this._uploadDate = new Date();
        this._messageDigester = _md5Pool.get();
        this._messageDigester.reset();
        this._buffer = new byte[(int)this._chunkSize];
    }

    GridFSInputFile(GridFS fs, String filename) {
        this(fs, null, filename);
    }

    GridFSInputFile(GridFS fs) {
        this(fs, null, null);
    }

    public DBObject getMetaData() {
        if (this._metadata == null) {
            this._metadata = new BasicDBObject();
        }
        return this._metadata;
    }

    public void setFilename(String fn) {
        this._filename = fn;
    }

    public void setContentType(String ct) {
        this._contentType = ct;
    }

    public void setChunkSize(long _chunkSize) {
        if (this._outputStream != null || this._savedChunks) {
            return;
        }
        this._chunkSize = _chunkSize;
    }

    public void save() {
        this.save(this._chunkSize);
    }

    public void save(long chunkSize) {
        if (this._outputStream != null) {
            throw new MongoException("cannot mix OutputStream and regular save()");
        }
        if (!this._savedChunks) {
            try {
                this.saveChunks(chunkSize);
            }
            catch (IOException ioe) {
                throw new MongoException("couldn't save chunks", ioe);
            }
        }
        super.save();
    }

    public int saveChunks() throws IOException {
        return this.saveChunks(this._chunkSize);
    }

    public int saveChunks(long chunkSize) throws IOException {
        if (this._outputStream != null) {
            throw new MongoException("cannot mix OutputStream and regular save()");
        }
        if (this._savedChunks) {
            throw new MongoException("chunks already saved!");
        }
        if (this._chunkSize != chunkSize) {
            this._chunkSize = chunkSize;
            this._buffer = new byte[(int)this._chunkSize];
        }
        if ((double)chunkSize > 3500000.0) {
            throw new MongoException("chunkSize must be less than 3.5MiB!");
        }
        int bytesRead = 0;
        while (bytesRead >= 0) {
            this._currentBufferPosition = 0;
            bytesRead = this._readStream2Buffer();
            this._dumpBuffer(true);
        }
        this._finishData();
        return this._currentChunkNumber;
    }

    public OutputStream getOutputStream() {
        if (this._outputStream == null) {
            this._outputStream = new MyOutputStream();
        }
        return this._outputStream;
    }

    private void _dumpBuffer(boolean writePartial) {
        if ((long)this._currentBufferPosition < this._chunkSize && !writePartial) {
            return;
        }
        if (this._currentBufferPosition == 0) {
            return;
        }
        byte[] writeBuffer = this._buffer;
        if ((long)this._currentBufferPosition != this._chunkSize) {
            writeBuffer = new byte[this._currentBufferPosition];
            System.arraycopy(this._buffer, 0, writeBuffer, 0, this._currentBufferPosition);
        }
        DBObject chunk = BasicDBObjectBuilder.start().add("files_id", this._id).add("n", this._currentChunkNumber).add("data", writeBuffer).get();
        this._fs._chunkCollection.save(chunk);
        ++this._currentChunkNumber;
        this._totalBytes += (long)writeBuffer.length;
        this._messageDigester.update(writeBuffer);
        this._currentBufferPosition = 0;
    }

    private int _readStream2Buffer() throws IOException {
        int bytesRead = 0;
        while ((long)this._currentBufferPosition < this._chunkSize && bytesRead >= 0) {
            bytesRead = this._in.read(this._buffer, this._currentBufferPosition, (int)this._chunkSize - this._currentBufferPosition);
            if (bytesRead > 0) {
                this._currentBufferPosition += bytesRead;
                continue;
            }
            if (bytesRead != 0) continue;
            throw new RuntimeException("i'm doing something wrong");
        }
        return bytesRead;
    }

    private void _finishData() {
        if (!this._savedChunks) {
            this._md5 = Util.toHex(this._messageDigester.digest());
            _md5Pool.done(this._messageDigester);
            this._messageDigester = null;
            this._length = this._totalBytes;
            this._savedChunks = true;
        }
    }

    class MyOutputStream
    extends OutputStream {
        MyOutputStream() {
        }

        public void write(int b) throws IOException {
            byte[] byteArray = new byte[]{(byte)(b & 0xFF)};
            this.write(byteArray, 0, 1);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            int offset = off;
            int length = len;
            int toCopy = 0;
            while (length > 0) {
                toCopy = length;
                if ((long)toCopy > GridFSInputFile.this._chunkSize - (long)GridFSInputFile.this._currentBufferPosition) {
                    toCopy = (int)GridFSInputFile.this._chunkSize - GridFSInputFile.this._currentBufferPosition;
                }
                System.arraycopy(b, offset, GridFSInputFile.this._buffer, GridFSInputFile.this._currentBufferPosition, toCopy);
                GridFSInputFile gridFSInputFile = GridFSInputFile.this;
                gridFSInputFile._currentBufferPosition = gridFSInputFile._currentBufferPosition + toCopy;
                offset += toCopy;
                length -= toCopy;
                if ((long)GridFSInputFile.this._currentBufferPosition != GridFSInputFile.this._chunkSize) continue;
                GridFSInputFile.this._dumpBuffer(false);
            }
        }

        public void close() {
            GridFSInputFile.this._dumpBuffer(true);
            GridFSInputFile.this._finishData();
            GridFSInputFile.super.save();
        }
    }
}

