/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

public final class Hash {
    static final long _longHashConstant = 4095L;

    public static final int hashBackward(String s) {
        int hash = 0;
        int i = s.length() - 1;
        while (i >= 0) {
            hash = hash * 31 + s.charAt(i);
            --i;
        }
        return hash;
    }

    public static final long hashBackwardLong(String s) {
        long hash = 0L;
        int i = s.length() - 1;
        while (i >= 0) {
            hash = hash * 63L + (long)s.charAt(i);
            --i;
        }
        return hash;
    }

    public static final long longHash(String s) {
        return Hash.longHash(s, 0, s.length());
    }

    public static final long longHash(String s, int start, int end) {
        long hash = 0L;
        while (start < end) {
            hash = 4095L * hash + (long)s.charAt(start);
            ++start;
        }
        return hash;
    }

    public static final long longLowerHash(String s) {
        return Hash.longLowerHash(s, 0, s.length());
    }

    public static final long longLowerHash(String s, int start, int end) {
        long hash = 0L;
        while (start < end) {
            hash = 4095L * hash + (long)Character.toLowerCase(s.charAt(start));
            ++start;
        }
        return hash;
    }

    public static final long longLowerHash(String s, int start, int end, long hash) {
        while (start < end) {
            hash = 4095L * hash + (long)Character.toLowerCase(s.charAt(start));
            ++start;
        }
        return hash;
    }

    public static final long longLowerHashAppend(long hash, char c) {
        return hash * 4095L + (long)Character.toLowerCase(c);
    }

    public static final long longHashAppend(long hash, char c) {
        return hash * 4095L + (long)c;
    }

    public static final int lowerCaseHash(String s) {
        int h = 0;
        int len = s.length();
        int i = 0;
        while (i < len) {
            h = 31 * h + Character.toLowerCase(s.charAt(i));
            ++i;
        }
        return h;
    }

    public static final int lowerCaseHash(String s, int start, int end) {
        int h = 0;
        int len = s.length();
        int i = start;
        while (i < len && i < end) {
            h = 31 * h + Character.toLowerCase(s.charAt(i));
            ++i;
        }
        return h;
    }

    public static final int hashCode(CharSequence s, int start, int end) {
        int h = 0;
        int len = s.length();
        int i = start;
        while (i < len && i < end) {
            h = 31 * h + s.charAt(i);
            ++i;
        }
        return h;
    }

    public static final int nospaceLowerHash(String s, int start, int end) {
        int h = 0;
        int len = s.length();
        int i = start;
        while (i < len && i < end) {
            char c = s.charAt(i);
            if (!Character.isWhitespace(c)) {
                h = 31 * h + Character.toLowerCase(c);
            }
            ++i;
        }
        return h;
    }

    public static final int lowerCaseSpaceTrimHash(String s) {
        int h = 0;
        int len = s.length();
        while (len > 1 && Character.isWhitespace(s.charAt(len - 1))) {
            --len;
        }
        boolean lastWasSpace = true;
        int i = 0;
        while (i < len) {
            boolean isSpace = Character.isWhitespace(s.charAt(i));
            if (!isSpace || !lastWasSpace) {
                lastWasSpace = isSpace;
                h = 31 * h + Character.toLowerCase(s.charAt(i));
            }
            ++i;
        }
        return h;
    }

    public static final int lowerCaseSpaceTrimHash(String s, int start, int end) {
        int h = 0;
        int len = s.length();
        while (len > 1 && Character.isWhitespace(s.charAt(len - 1))) {
            --len;
        }
        boolean lastWasSpace = true;
        int i = start;
        while (i < len && i < end) {
            boolean isSpace = Character.isWhitespace(s.charAt(i));
            if (!isSpace || !lastWasSpace) {
                lastWasSpace = isSpace;
                h = 31 * h + Character.toLowerCase(s.charAt(i));
            }
            ++i;
        }
        return h;
    }

    public static final int hashCode(String ... strings) {
        int h = 0;
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int len = s.length();
            int i = 0;
            while (i < len) {
                h = 31 * h + s.charAt(i);
                ++i;
            }
            ++n2;
        }
        return h;
    }
}

