/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class Bits {
    public static void readFully(InputStream in, byte[] b) throws IOException {
        Bits.readFully(in, b, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int l) throws IOException {
        int x = 0;
        while (x < l) {
            int temp = in.read(b, x, l - x);
            if (temp < 0) {
                throw new EOFException();
            }
            x += temp;
        }
    }

    public static int readInt(InputStream in) throws IOException {
        return Bits.readInt(in, new byte[4]);
    }

    public static int readInt(InputStream in, byte[] data) throws IOException {
        Bits.readFully(in, data, 4);
        return Bits.readInt(data);
    }

    public static int readInt(byte[] data) {
        return Bits.readInt(data, 0);
    }

    public static int readInt(byte[] data, int offset) {
        int x = 0;
        x |= (0xFF & data[offset + 0]) << 0;
        x |= (0xFF & data[offset + 1]) << 8;
        x |= (0xFF & data[offset + 2]) << 16;
        return x |= (0xFF & data[offset + 3]) << 24;
    }

    public static long readLong(InputStream in) throws IOException {
        return Bits.readLong(in, new byte[8]);
    }

    public static long readLong(InputStream in, byte[] data) throws IOException {
        Bits.readFully(in, data, 8);
        return Bits.readLong(data);
    }

    public static long readLong(byte[] data) {
        return Bits.readLong(data, 0);
    }

    public static long readLong(byte[] data, int offset) {
        long x = 0L;
        x |= (0xFFL & (long)data[offset + 0]) << 0;
        x |= (0xFFL & (long)data[offset + 1]) << 8;
        x |= (0xFFL & (long)data[offset + 2]) << 16;
        x |= (0xFFL & (long)data[offset + 3]) << 24;
        x |= (0xFFL & (long)data[offset + 4]) << 32;
        x |= (0xFFL & (long)data[offset + 5]) << 40;
        x |= (0xFFL & (long)data[offset + 6]) << 48;
        return x |= (0xFFL & (long)data[offset + 7]) << 56;
    }
}

