/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.bson.io.OutputBuffer;
import org.bson.io.UTF8Encoding;
import org.bson.util.SimplePool;

public class PoolOutputBuffer
extends OutputBuffer {
    public static final int BUF_SIZE = 16384;
    final byte[] _mine = new byte[16384];
    final char[] _chars = new char[16384];
    final List<byte[]> _fromPool = new ArrayList<byte[]>();
    final UTF8Encoding _encoding = new UTF8Encoding();
    private final Position _cur = new Position();
    private final Position _end = new Position();
    private static SimplePool<byte[]> _extra = new SimplePool<byte[]>(640){

        @Override
        protected byte[] createNew() {
            return new byte[16384];
        }
    };

    public PoolOutputBuffer() {
        this.reset();
    }

    public void reset() {
        this._cur.reset();
        this._end.reset();
        int i = 0;
        while (i < this._fromPool.size()) {
            _extra.done(this._fromPool.get(i));
            ++i;
        }
        this._fromPool.clear();
    }

    public int getPosition() {
        return this._cur.pos();
    }

    public void setPosition(int position) {
        this._cur.reset(position);
    }

    public void seekEnd() {
        this._cur.reset(this._end);
    }

    public void seekStart() {
        this._cur.reset();
    }

    public int size() {
        return this._end.pos();
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) {
        while (len > 0) {
            byte[] bs = this._cur();
            int space = Math.min(bs.length - this._cur.y, len);
            System.arraycopy(b, off, bs, this._cur.y, space);
            this._cur.inc(space);
            len -= space;
            off += space;
            this._afterWrite();
        }
    }

    public void write(int b) {
        byte[] bs = this._cur();
        bs[this._cur.getAndInc()] = (byte)(b & 0xFF);
        this._afterWrite();
    }

    void _afterWrite() {
        if (this._cur.pos() < this._end.pos()) {
            if (this._cur.y == 16384) {
                this._cur.nextBuffer();
            }
            return;
        }
        this._end.reset(this._cur);
        if (this._end.y < 16384) {
            return;
        }
        this._fromPool.add(_extra.get());
        this._end.nextBuffer();
        this._cur.reset(this._end);
    }

    byte[] _cur() {
        return this._get(this._cur.x);
    }

    byte[] _get(int z) {
        if (z < 0) {
            return this._mine;
        }
        return this._fromPool.get(z);
    }

    public int pipe(OutputStream out) throws IOException {
        if (out == null) {
            throw new NullPointerException("out is null");
        }
        int total = 0;
        int i = -1;
        while (i < this._fromPool.size()) {
            byte[] b = this._get(i);
            int amt = this._end.len(i);
            out.write(b, 0, amt);
            total += amt;
            ++i;
        }
        return total;
    }

    public String asAscii() {
        if (this._fromPool.size() > 0) {
            return super.asString();
        }
        int m = this.size();
        char[] c = m < this._chars.length ? this._chars : new char[m];
        int i = 0;
        while (i < m) {
            c[i] = (char)this._mine[i];
            ++i;
        }
        return new String(c, 0, m);
    }

    public String asString(String encoding) throws UnsupportedEncodingException {
        if (this._fromPool.size() > 0) {
            return super.asString(encoding);
        }
        if (encoding.equals("UTF8") || encoding.equals("UTF-8")) {
            try {
                return this._encoding.decode(this._mine, 0, this.size());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new String(this._mine, 0, this.size(), encoding);
    }

    static class Position {
        int x;
        int y;

        Position() {
            this.reset();
        }

        void reset() {
            this.x = -1;
            this.y = 0;
        }

        void reset(Position other) {
            this.x = other.x;
            this.y = other.y;
        }

        void reset(int pos) {
            this.x = pos / 16384 - 1;
            this.y = pos % 16384;
        }

        int pos() {
            return (this.x + 1) * 16384 + this.y;
        }

        int getAndInc() {
            return this.y++;
        }

        void inc(int amt) {
            this.y += amt;
            if (this.y > 16384) {
                throw new IllegalArgumentException("something is wrong");
            }
        }

        void nextBuffer() {
            if (this.y != 16384) {
                throw new IllegalArgumentException("broken");
            }
            ++this.x;
            this.y = 0;
        }

        int len(int which) {
            if (which < this.x) {
                return 16384;
            }
            return this.y;
        }

        public String toString() {
            return String.valueOf(this.x) + "," + this.y;
        }
    }
}

