/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.hideshow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import net.sourceforge.nattable.hideshow.AbstractColumnHideShowLayer;
import net.sourceforge.nattable.hideshow.command.ColumnHideCommandHandler;
import net.sourceforge.nattable.hideshow.command.MultiColumnHideCommandHandler;
import net.sourceforge.nattable.hideshow.command.MultiColumnShowCommandHandler;
import net.sourceforge.nattable.hideshow.command.ShowAllColumnsCommandHandler;
import net.sourceforge.nattable.hideshow.event.HideColumnPositionsEvent;
import net.sourceforge.nattable.hideshow.event.ShowColumnPositionsEvent;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.IUniqueIndexLayer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnHideShowLayer
extends AbstractColumnHideShowLayer {
    public static final String PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES = ".hiddenColumnIndexes";
    private final Set<Integer> hiddenColumnIndexes = new TreeSet<Integer>();

    public ColumnHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.registerCommandHandler(new MultiColumnHideCommandHandler(this));
        this.registerCommandHandler(new ColumnHideCommandHandler(this));
        this.registerCommandHandler(new ShowAllColumnsCommandHandler(this));
        this.registerCommandHandler(new MultiColumnShowCommandHandler(this));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        if (this.hiddenColumnIndexes.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : this.hiddenColumnIndexes) {
                strBuilder.append(index);
                strBuilder.append(',');
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES, strBuilder.toString());
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES);
        if (property != null) {
            this.hiddenColumnIndexes.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                this.hiddenColumnIndexes.add(Integer.valueOf(index));
            }
        }
        super.loadState(prefix, properties);
    }

    @Override
    public boolean isColumnIndexHidden(int columnIndex) {
        return this.hiddenColumnIndexes.contains(columnIndex);
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        return this.hiddenColumnIndexes;
    }

    public void hideColumnPositions(Collection<Integer> columnPositions) {
        HashSet<Integer> columnIndexes = new HashSet<Integer>();
        for (Integer columnPosition : columnPositions) {
            columnIndexes.add(this.getColumnIndexByPosition(columnPosition));
        }
        this.hiddenColumnIndexes.addAll(columnIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideColumnPositionsEvent((ILayer)this, columnPositions));
    }

    public void showColumnIndexes(int[] columnIndexes) {
        HashSet<Integer> columnIndexesSet = new HashSet<Integer>();
        int i = 0;
        while (i < columnIndexes.length) {
            columnIndexesSet.add(columnIndexes[i]);
            ++i;
        }
        this.hiddenColumnIndexes.removeAll(columnIndexesSet);
        this.invalidateCache();
        this.fireLayerEvent(new ShowColumnPositionsEvent(this, this.getColumnPositionsByIndexes(columnIndexes)));
    }

    protected void showColumnIndexes(Collection<Integer> columnIndexes) {
        for (int columnIndex : columnIndexes) {
            this.hiddenColumnIndexes.remove(columnIndex);
        }
        this.invalidateCache();
        this.fireLayerEvent(new ShowColumnPositionsEvent(this, columnIndexes));
    }

    public void showAllColumns() {
        ArrayList<Integer> hiddenColumns = new ArrayList<Integer>(this.hiddenColumnIndexes);
        this.hiddenColumnIndexes.clear();
        this.invalidateCache();
        this.fireLayerEvent(new ShowColumnPositionsEvent(this, hiddenColumns));
    }

    private Collection<Integer> getColumnPositionsByIndexes(int[] columnIndexes) {
        HashSet<Integer> columnPositions = new HashSet<Integer>();
        int[] nArray = columnIndexes;
        int n = columnIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int columnIndex = nArray[n2];
            columnPositions.add(this.getColumnPositionByIndex(columnIndex));
            ++n2;
        }
        return columnPositions;
    }
}

