/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.MaterialPreparedStatement;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.PreparedStatementCallbackInterface;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;

public class CallableStatement
extends PreparedStatement
implements java.sql.PreparedStatement,
java.sql.CallableStatement,
PreparedStatementCallbackInterface {
    public MaterialPreparedStatement materialCallableStatement_ = null;
    private int wasNull_ = 0;
    private static final int WAS_NULL = 1;
    private static final int WAS_NOT_NULL = 2;
    private static final int WAS_NULL_UNSET = 0;

    private void initCallableStatement() {
        this.materialCallableStatement_ = null;
        this.wasNull_ = 0;
    }

    public void reset(boolean fullReset) throws SqlException {
        if (fullReset) {
            this.connection_.resetPrepareCall(this);
        } else {
            super.reset(fullReset);
        }
        this.wasNull_ = 0;
    }

    public CallableStatement(Agent agent, Connection connection, String sql, int type, int concurrency, int holdability, ClientPooledConnection cpc) throws SqlException {
        super(agent, connection, sql, type, concurrency, holdability, 2, null, null, cpc);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, Connection connection, String sql, int type, int concurrency, int holdability) throws SqlException {
        super.resetPreparedStatement(agent, connection, sql, type, concurrency, holdability, 2, null, null);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, Connection connection, String sql, Section section) throws SqlException {
        super.resetPreparedStatement(agent, connection, sql, section);
        this.initCallableStatement();
    }

    public void resetCallableStatement(Agent agent, Connection connection, String sql, Section section, ColumnMetaData parameterMetaData, ColumnMetaData resultSetMetaData) throws SqlException {
        super.resetPreparedStatement(agent, connection, sql, section, parameterMetaData, resultSetMetaData);
        this.initCallableStatement();
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize");
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearParameters");
            }
            super.clearParameters();
            this.outputRegistered_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int parameterIndex, int jdbcType) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", parameterIndex, jdbcType);
                }
                this.registerOutParameterX(parameterIndex, jdbcType);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    void registerOutParameterX(int parameterIndex, int jdbcType) throws SqlException {
        super.checkForClosedStatement();
        int scale = 0;
        this.registerOutParameterX(parameterIndex, jdbcType, scale);
    }

    private int guessScaleForDecimalOrNumeric(int parameterIndex) throws SqlException {
        if (this.parameterMetaData_.types_[parameterIndex - 1] == 3 && this.parameters_[parameterIndex - 1] != null) {
            return this.parameterMetaData_.sqlScale_[parameterIndex - 1];
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int parameterIndex, int jdbcType, int scale) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", parameterIndex, jdbcType, scale);
                }
                super.checkForClosedStatement();
                this.registerOutParameterX(parameterIndex, jdbcType, scale);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void registerOutParameterX(int parameterIndex, int jdbcType, int scale) throws SqlException {
        super.checkForValidParameterIndex(parameterIndex);
        this.checkForValidScale(scale);
        this.outputRegistered_ = true;
        this.parameterRegistered_[parameterIndex - 1] = true;
    }

    public void registerOutParameter(int parameterIndex, int jdbcType, String typeName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", parameterIndex, jdbcType, (Object)typeName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public boolean wasNull() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "wasNull");
            }
            boolean result = this.wasNullX();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "wasNull", result);
            }
            return result;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean wasNullX() throws SqlException {
        super.checkForClosedStatement();
        if (this.wasNull_ == 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ088.S"));
        }
        return this.wasNull_ == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                boolean result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBoolean", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                boolean bl = result = this.wasNullX() ? false : this.singletonRowData_.getBoolean(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBoolean", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                byte result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getByte", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                byte by = result = this.wasNullX() ? (byte)0 : this.singletonRowData_.getByte(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getByte", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                short result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getShort", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                short s = result = this.wasNullX() ? (short)0 : this.singletonRowData_.getShort(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getShort", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getInt", parameterIndex);
                }
                int result = this.getIntX(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getInt", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    int getIntX(int parameterIndex) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(parameterIndex);
        this.setWasNull(parameterIndex);
        return this.wasNullX() ? 0 : this.singletonRowData_.getInt(parameterIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getLong", parameterIndex);
                }
                long result = this.getLongX(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getLong", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    long getLongX(int parameterIndex) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(parameterIndex);
        this.setWasNull(parameterIndex);
        return this.wasNullX() ? 0L : this.singletonRowData_.getLong(parameterIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                float result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getFloat", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                float f = result = this.wasNullX() ? 0.0f : this.singletonRowData_.getFloat(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getFloat", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                double result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getDouble", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                double d = result = this.wasNullX() ? 0.0 : this.singletonRowData_.getDouble(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDouble", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException, ArithmeticException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                BigDecimal result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedEntry((Object)this, "getBigDecimal", parameterIndex, scale);
                }
                super.checkForClosedStatement();
                this.checkForValidScale(scale);
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                BigDecimal bigDecimal = result = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(parameterIndex);
                if (result != null) {
                    result = result.setScale(scale, 1);
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceDeprecatedExit((Object)this, "getBigDecimal", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                BigDecimal result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBigDecimal", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                BigDecimal bigDecimal = result = this.wasNullX() ? null : this.singletonRowData_.getBigDecimal(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBigDecimal", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Date result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getDate", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Date date = result = this.wasNullX() ? null : this.singletonRowData_.getDate(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getDate", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getDate", parameterIndex, (Object)cal);
            }
            Date result = this.getDate(parameterIndex);
            if (cal == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S")).getSQLException();
            }
            if (result != null) {
                Calendar targetCalendar = Calendar.getInstance(cal.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(result);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(result);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                result.setTime(result.getTime() - timeZoneOffset);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getDate", result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Time result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getTime", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Time time = result = this.wasNullX() ? null : this.singletonRowData_.getTime(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getTime", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTime", parameterIndex, (Object)cal);
            }
            Time result = this.getTime(parameterIndex);
            if (cal == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S")).getSQLException();
            }
            if (result != null) {
                Calendar targetCalendar = Calendar.getInstance(cal.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(result);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(result);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                result.setTime(result.getTime() - timeZoneOffset);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTime", result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Timestamp result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Timestamp timestamp = result = this.wasNullX() ? null : this.singletonRowData_.getTimestamp(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", parameterIndex, (Object)cal);
            }
            Timestamp result = this.getTimestamp(parameterIndex);
            if (cal == null) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ090.S")).getSQLException();
            }
            if (result != null) {
                int nano = result.getNanos();
                Calendar targetCalendar = Calendar.getInstance(cal.getTimeZone());
                targetCalendar.clear();
                targetCalendar.setTime(result);
                Calendar defaultCalendar = Calendar.getInstance();
                defaultCalendar.clear();
                defaultCalendar.setTime(result);
                long timeZoneOffset = targetCalendar.get(15) - defaultCalendar.get(15) + targetCalendar.get(16) - defaultCalendar.get(16);
                result.setTime(result.getTime() - timeZoneOffset);
                result.setNanos(nano);
            }
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getTimestamp", result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getString", parameterIndex);
                }
                String result = this.getStringX(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getString", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    String getStringX(int parameterIndex) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(parameterIndex);
        this.setWasNull(parameterIndex);
        return this.wasNullX() ? null : this.singletonRowData_.getString(parameterIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBytes", parameterIndex);
                }
                byte[] result = this.getBytesX(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBytes", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    byte[] getBytesX(int parameterIndex) throws SqlException {
        super.checkForClosedStatement();
        this.checkGetterPreconditions(parameterIndex);
        this.setWasNull(parameterIndex);
        return this.wasNullX() ? null : this.singletonRowData_.getBytes(parameterIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Blob result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBlob", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Blob blob = result = this.wasNullX() ? null : this.singletonRowData_.getBlob(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getBlob", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Clob result;
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Clob clob = result = this.wasNullX() ? null : this.singletonRowData_.getClob(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getClob", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Array getArray(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getArray", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Array result = this.wasNullX() ? null : this.singletonRowData_.getArray(parameterIndex);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getRef", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Ref result = this.wasNullX() ? null : this.singletonRowData_.getRef(parameterIndex);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                Object result;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getObject", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Object object = result = this.wasNullX() ? null : this.singletonRowData_.getObject(parameterIndex);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getObject", result);
                }
                return result;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getObject", parameterIndex, (Object)map);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", (Object)parameterName, sqlType);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", (Object)parameterName, sqlType, scale);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "registerOutParameter", (Object)parameterName, sqlType, (Object)typeName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public URL getURL(int parameterIndex) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getURL", parameterIndex);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setURL(String parameterName, URL x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setURL", (Object)parameterName, (Object)x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setNull", (Object)parameterName, sqlType);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBoolean", (Object)parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setByte", (Object)parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setShort(String parameterName, short x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setShort", (Object)parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setInt(String parameterName, int x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setInt", (Object)parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setLong(String parameterName, long x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setLong", (Object)parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setFloat", (Object)parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setDouble", (Object)parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBigDecimal", (Object)parameterName, (Object)x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setString(String parameterName, String x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setString", (Object)parameterName, (Object)x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBytes", (Object)parameterName, (Object)x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setDate", (Object)parameterName, (Object)x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTime", (Object)parameterName, (Object)x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", (Object)parameterName, (Object)x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setAsciiStream", (Object)parameterName, (Object)x, length);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setBinaryStream", (Object)parameterName, (Object)x, length);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setObject", (Object)parameterName, x, targetSqlType, scale);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setObject", (Object)parameterName, x, targetSqlType);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setObject", (Object)parameterName, x);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setCharacterStream", (Object)parameterName, (Object)reader, length);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setDate(String parameterName, Date x, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setDate", (Object)parameterName, (Object)x, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setTime(String parameterName, Time x, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTime", (Object)parameterName, (Object)x, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setTimestamp", (Object)parameterName, (Object)x, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "setNull", (Object)parameterName, sqlType, (Object)typeName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public String getString(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getString", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBoolean", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public byte getByte(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getByte", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public short getShort(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getShort", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public int getInt(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getInt", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public long getLong(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getLong", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public float getFloat(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getFloat", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public double getDouble(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDouble", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBytes", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Date getDate(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDate", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Time getTime(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTime", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Object getObject(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getObject", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBigDecimal", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getObject", (Object)parameterName, (Object)map);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Ref getRef(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getRef", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Blob getBlob(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getBlob", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Clob getClob(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getClob", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Array getArray(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getArray", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Date getDate(String parameterName, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getDate", (Object)parameterName, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Time getTime(String parameterName, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTime", (Object)parameterName, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public Timestamp getTimestamp(String parameterName, Calendar calendar) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getTimestamp", (Object)parameterName, (Object)calendar);
        }
        throw this.jdbcMethodNotImplemented();
    }

    public URL getURL(String parameterName) throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "getURL", parameterName);
        }
        throw this.jdbcMethodNotImplemented();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getCharacterStream", parameterIndex);
                }
                super.checkForClosedStatement();
                this.checkGetterPreconditions(parameterIndex);
                this.setWasNull(parameterIndex);
                Reader reader = null;
                if (this.wasNull_ == 2) {
                    reader = this.singletonRowData_.getCharacterStream(parameterIndex);
                }
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
                }
                return reader;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    protected String getJdbcStatementInterfaceName() {
        return "java.sql.CallableStatement";
    }

    private void checkGetterPreconditions(int parameterIndex) throws SqlException {
        super.checkForValidParameterIndex(parameterIndex);
        this.checkForValidOutParameter(parameterIndex);
    }

    private void checkForValidOutParameter(int parameterIndex) throws SqlException {
        if (this.parameterMetaData_ == null || this.parameterMetaData_.sqlxParmmode_[parameterIndex - 1] < 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ091.S"), new Integer(parameterIndex));
        }
    }

    private void setWasNull(int parameterIndex) {
        this.wasNull_ = this.singletonRowData_ == null ? 0 : (this.singletonRowData_.isNull_[parameterIndex - 1] ? 1 : 2);
    }

    private SQLException jdbcMethodNotImplemented() throws SQLException {
        try {
            super.checkForClosedStatement();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1")).getSQLException();
    }
}

