/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.SqlException;

public class ClobOutputStream
extends OutputStream {
    private Clob clob_;
    private long offset_;

    public ClobOutputStream(Clob clob, long offset) throws SqlException {
        this.clob_ = clob;
        this.offset_ = offset;
        if (this.offset_ - 1L > this.clob_.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void write(int b) throws IOException {
        byte[] newByte = new byte[]{(byte)b};
        this.writeBytes(newByte);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        byte[] newByte = new byte[len];
        System.arraycopy(b, off, newByte, 0, len);
        this.writeBytes(newByte);
    }

    private void writeBytes(byte[] b) throws IOException {
        String str = new String(b, "ISO-8859-1");
        this.clob_.string_ = this.clob_.string_.substring(0, (int)this.offset_ - 1);
        this.clob_.string_ = this.clob_.string_.concat(str);
        this.clob_.asciiStream_ = new StringBufferInputStream(this.clob_.string_);
        this.clob_.unicodeStream_ = new StringBufferInputStream(this.clob_.string_);
        this.clob_.characterStream_ = new StringReader(this.clob_.string_);
        this.clob_.setSqlLength(this.clob_.string_.length());
        this.offset_ += (long)b.length;
    }
}

