/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.apache.derby.iapi.services.sanity.SanityManager;

public final class EncodedInputStream
extends InputStream {
    private static final int BUFFERED_CHAR_LEN = 1024;
    private static final ByteArrayInputStream suspendMarker = new ByteArrayInputStream(new byte[0]);
    private Reader reader_;
    private final char[] decodedBuffer_;
    private OutputStreamWriter encodedStreamWriter_;
    private PublicBufferOutputStream encodedOutputStream_;
    private ByteArrayInputStream encodedInputStream_;

    public static EncodedInputStream createUTF8Stream(Reader reader) {
        return new EncodedInputStream(reader, "UTF8", 1024, 3072);
    }

    static EncodedInputStream createUTF16BEStream(Reader reader) {
        return new EncodedInputStream(reader, "UTF-16BE", 1024, 2048);
    }

    private EncodedInputStream(Reader reader, String encoding, int charBufferSize, int initialByteBufferSize) {
        this.reader_ = reader;
        this.decodedBuffer_ = new char[charBufferSize];
        this.encodedOutputStream_ = new PublicBufferOutputStream(initialByteBufferSize);
        try {
            this.encodedStreamWriter_ = new OutputStreamWriter((OutputStream)this.encodedOutputStream_, encoding);
        }
        catch (UnsupportedEncodingException e) {
            SanityManager.THROWASSERT("Unavailable encoding specified: " + encoding, e);
        }
        this.encodedInputStream_ = suspendMarker;
    }

    private ByteArrayInputStream reEncode(Reader reader) throws IOException {
        int count;
        while ((count = reader.read(this.decodedBuffer_, 0, this.decodedBuffer_.length)) == 0) {
        }
        if (count < 0) {
            return null;
        }
        this.encodedOutputStream_.reset();
        this.encodedStreamWriter_.write(this.decodedBuffer_, 0, count);
        this.encodedStreamWriter_.flush();
        int encodedLength = this.encodedOutputStream_.size();
        return new ByteArrayInputStream(this.encodedOutputStream_.getBuffer(), 0, encodedLength);
    }

    public int available() throws IOException {
        if (this.encodedInputStream_ == suspendMarker) {
            this.encodedInputStream_ = this.reEncode(this.reader_);
        }
        if (this.encodedInputStream_ == null) {
            return 0;
        }
        return this.encodedInputStream_.available();
    }

    public void close() throws IOException {
        if (this.encodedInputStream_ != null) {
            this.encodedInputStream_.close();
            this.encodedInputStream_ = null;
        }
        if (this.reader_ != null) {
            this.reader_.close();
            this.reader_ = null;
        }
        if (this.encodedStreamWriter_ != null) {
            this.encodedStreamWriter_.close();
            this.encodedStreamWriter_ = null;
        }
    }

    public int read() throws IOException {
        if (this.encodedInputStream_ == suspendMarker) {
            this.encodedInputStream_ = this.reEncode(this.reader_);
        }
        if (this.encodedInputStream_ == null) {
            return -1;
        }
        int c = this.encodedInputStream_.read();
        if (c > -1) {
            return c;
        }
        this.encodedInputStream_ = this.reEncode(this.reader_);
        if (this.encodedInputStream_ == null) {
            return -1;
        }
        return this.encodedInputStream_.read();
    }

    protected void finalize() throws IOException {
        this.close();
    }

    static class PublicBufferOutputStream
    extends ByteArrayOutputStream {
        PublicBufferOutputStream(int size) {
            super(size);
        }

        public byte[] getBuffer() {
            return this.buf;
        }
    }
}

