/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.CallableStatement;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.DatabaseMetaData;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.EncryptionManager;
import org.apache.derby.client.am.LogWriter;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.ProductLevel;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SectionManager;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Statement;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCallableStatement;
import org.apache.derby.client.net.NetConfiguration;
import org.apache.derby.client.net.NetDatabaseMetaData;
import org.apache.derby.client.net.NetLogWriter;
import org.apache.derby.client.net.NetPreparedStatement;
import org.apache.derby.client.net.NetStatement;
import org.apache.derby.client.net.NetXAResource;
import org.apache.derby.client.net.OpenSocketAction;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.jdbc.ClientBaseDataSource;
import org.apache.derby.jdbc.ClientDriver;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class NetConnection
extends Connection {
    protected static MessageUtil msgutil = SqlException.getMessageUtil();
    protected NetAgent netAgent_;
    private final ClientPooledConnection pooledConnection_;
    private final boolean closeStatementsOnClose;
    protected int pendingEndXACallinfoOffset_ = -1;
    protected int targetAgent_ = 7;
    protected int targetCmntcpip_ = 5;
    protected int targetRdb_ = 7;
    public int targetSecmgr_ = 7;
    protected int targetCmnappc_ = 0;
    protected int targetXamgr_ = 7;
    protected int targetSyncptmgr_ = 0;
    protected int targetRsyncmgr_ = 0;
    String targetExtnam_;
    String extnam_;
    public String targetSrvclsnm_;
    protected String targetSrvnam_;
    public String targetSrvrlslv_;
    transient byte[] publicKey_;
    transient byte[] targetPublicKey_;
    transient byte[] sourceSeed_;
    transient byte[] targetSeed_;
    byte[] prddta_;
    public byte[] crrtkn_;
    int targetSecmec_;
    protected int securityMechanism_;
    private transient char[] deferredResetPassword_ = null;
    private boolean connectionNull = false;
    protected byte[] cnntkn_ = null;
    private int rmId_ = 0;
    protected NetXAResource xares_ = null;
    protected Hashtable indoubtTransactions_ = null;
    protected int currXACallInfoOffset_ = 0;
    private short seqNo_ = 1;
    protected boolean readOnlyTransaction_ = true;

    private void setDeferredResetPassword(String password) {
        this.deferredResetPassword_ = password == null ? null : this.flipBits(password.toCharArray());
    }

    private String getDeferredResetPassword() {
        if (this.deferredResetPassword_ == null) {
            return null;
        }
        String password = new String(this.flipBits(this.deferredResetPassword_));
        this.flipBits(this.deferredResetPassword_);
        return password;
    }

    public NetConnection(NetLogWriter netLogWriter, String databaseName, Properties properties) throws SqlException {
        super(netLogWriter, 0, "", -1, databaseName, properties);
        this.pooledConnection_ = null;
        this.closeStatementsOnClose = true;
    }

    public NetConnection(NetLogWriter netLogWriter, ClientBaseDataSource dataSource, String user, String password) throws SqlException {
        super(netLogWriter, user, password, dataSource);
        this.pooledConnection_ = null;
        this.closeStatementsOnClose = true;
        this.setDeferredResetPassword(password);
    }

    public NetConnection(NetLogWriter netLogWriter, int driverManagerLoginTimeout, String serverName, int portNumber, String databaseName, Properties properties) throws SqlException {
        super(netLogWriter, driverManagerLoginTimeout, serverName, portNumber, databaseName, properties);
        this.pooledConnection_ = null;
        this.closeStatementsOnClose = true;
        this.netAgent_ = (NetAgent)this.agent_;
        if (this.netAgent_.exceptionOpeningSocket_ != null) {
            throw this.netAgent_.exceptionOpeningSocket_;
        }
        this.checkDatabaseName();
        String password = ClientBaseDataSource.getPassword(properties);
        this.securityMechanism_ = ClientBaseDataSource.getSecurityMechanism(properties);
        this.flowConnect(password, this.securityMechanism_);
        if (!this.isConnectionNull()) {
            this.completeConnect();
        }
    }

    public NetConnection(NetLogWriter netLogWriter, String user, String password, ClientBaseDataSource dataSource, int rmId, boolean isXAConn) throws SqlException {
        super(netLogWriter, user, password, isXAConn, dataSource);
        this.pooledConnection_ = null;
        this.closeStatementsOnClose = true;
        this.netAgent_ = (NetAgent)this.agent_;
        this.initialize(password, dataSource, rmId, isXAConn);
    }

    public NetConnection(NetLogWriter netLogWriter, String ipaddr, int portNumber, ClientBaseDataSource dataSource, boolean isXAConn) throws SqlException {
        super(netLogWriter, isXAConn, dataSource);
        this.pooledConnection_ = null;
        this.closeStatementsOnClose = true;
        this.netAgent_ = (NetAgent)this.agent_;
        if (this.netAgent_.exceptionOpeningSocket_ != null) {
            throw this.netAgent_.exceptionOpeningSocket_;
        }
        this.checkDatabaseName();
        this.isXAConnection_ = isXAConn;
        this.flowSimpleConnect();
        this.productID_ = this.targetSrvrlslv_;
        super.completeConnect();
    }

    public NetConnection(NetLogWriter netLogWriter, String user, String password, ClientBaseDataSource dataSource, int rmId, boolean isXAConn, ClientPooledConnection cpc) throws SqlException {
        super(netLogWriter, user, password, isXAConn, dataSource);
        this.netAgent_ = (NetAgent)this.agent_;
        this.initialize(password, dataSource, rmId, isXAConn);
        this.pooledConnection_ = cpc;
        this.closeStatementsOnClose = !cpc.isStatementPoolingEnabled();
    }

    private void initialize(String password, ClientBaseDataSource dataSource, int rmId, boolean isXAConn) throws SqlException {
        this.securityMechanism_ = dataSource.getSecurityMechanism(password);
        this.setDeferredResetPassword(password);
        this.checkDatabaseName();
        this.dataSource_ = dataSource;
        this.rmId_ = rmId;
        this.isXAConnection_ = isXAConn;
        this.flowConnect(password, this.securityMechanism_);
        if (!this.isConnectionNull()) {
            this.completeConnect();
        } else {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("XCY00.S"), (Object)"databaseName", (Object)this.databaseName_));
        }
    }

    public void resetNetConnection(LogWriter logWriter) throws SqlException {
        super.resetConnection(logWriter);
        this.targetExtnam_ = null;
        this.targetSrvclsnm_ = null;
        this.targetSrvnam_ = null;
        this.targetSrvrlslv_ = null;
        this.publicKey_ = null;
        this.targetPublicKey_ = null;
        this.sourceSeed_ = null;
        this.targetSeed_ = null;
        this.targetSecmec_ = 0;
        this.resetConnectionAtFirstSql_ = false;
        boolean isDeferredReset = this.flowReconnect(this.getDeferredResetPassword(), this.securityMechanism_);
        this.completeReset(isDeferredReset);
    }

    protected void reset_(LogWriter logWriter) throws SqlException {
        if (this.inUnitOfWork_) {
            throw new SqlException(logWriter, new ClientMessageId("XN001.S"));
        }
        this.resetNetConnection(logWriter);
    }

    List getSpecialRegisters() {
        if (this.xares_ != null) {
            return this.xares_.getSpecialRegisters();
        }
        return null;
    }

    public void addSpecialRegisters(String s) {
        if (this.xares_ != null) {
            this.xares_.addSpecialRegisters(s);
        }
    }

    public void completeConnect() throws SqlException {
        super.completeConnect();
    }

    protected void completeReset(boolean isDeferredReset) throws SqlException {
        super.completeReset(isDeferredReset, this.closeStatementsOnClose);
    }

    public void flowConnect(String password, int securityMechanism) throws SqlException {
        this.netAgent_ = (NetAgent)this.agent_;
        this.constructExtnam();
        this.constructPrddta();
        this.netAgent_.typdef_ = new Typdef(this.netAgent_, 1208, "QTDSQLASC", 1200, 1208);
        this.netAgent_.originalTargetTypdef_ = this.netAgent_.targetTypdef_ = new Typdef(this.netAgent_);
        this.setDeferredResetPassword(password);
        try {
            switch (securityMechanism) {
                case 3: {
                    this.checkUserPassword(this.user_, password);
                    this.flowUSRIDPWDconnect(password);
                    break;
                }
                case 4: {
                    this.checkUser(this.user_);
                    this.flowUSRIDONLconnect();
                    break;
                }
                case 7: {
                    this.checkUserPassword(this.user_, password);
                    this.flowUSRENCPWDconnect(password);
                    break;
                }
                case 9: {
                    this.checkUserPassword(this.user_, password);
                    this.flowEUSRIDPWDconnect(password);
                    break;
                }
                case 12: {
                    this.checkUserPassword(this.user_, password);
                    this.flowEUSRIDDTAconnect();
                    break;
                }
                case 13: {
                    this.checkUserPassword(this.user_, password);
                    this.flowEUSRPWDDTAconnect(password);
                    break;
                }
                case 8: {
                    this.checkUserPassword(this.user_, password);
                    this.flowUSRSSBPWDconnect(password);
                    break;
                }
                default: {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.5"), new Integer(securityMechanism));
                }
            }
        }
        catch (Throwable e) {
            this.open_ = false;
            SqlException exceptionToBeThrown = e instanceof SqlException ? (SqlException)e : new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), (Object)e.getClass().getName(), (Object)e.getMessage(), e);
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException ignoreMe) {
                // empty catch block
            }
            throw exceptionToBeThrown;
        }
    }

    protected void flowSimpleConnect() throws SqlException {
        this.netAgent_ = (NetAgent)this.agent_;
        this.constructExtnam();
        this.constructPrddta();
        this.netAgent_.typdef_ = new Typdef(this.netAgent_, 1208, "QTDSQLASC", 1200, 1208);
        this.netAgent_.originalTargetTypdef_ = this.netAgent_.targetTypdef_ = new Typdef(this.netAgent_);
        try {
            this.flowServerAttributes();
        }
        catch (Throwable e) {
            this.open_ = false;
            SqlException exceptionToBeThrown = e instanceof SqlException ? (SqlException)e : new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ001.U"), (Object)e.getClass().getName(), (Object)e.getMessage(), e);
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException sqlException) {
                // empty catch block
            }
            throw exceptionToBeThrown;
        }
    }

    protected boolean flowReconnect(String password, int securityMechanism) throws SqlException {
        this.constructExtnam();
        this.constructPrddta();
        this.checkSecmgrForSecmecSupport(securityMechanism);
        try {
            switch (securityMechanism) {
                case 3: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
                case 4: {
                    this.checkUser(this.user_);
                    this.resetConnectionAtFirstSql_ = true;
                    return true;
                }
                case 7: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
                case 9: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
                case 12: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
                case 13: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
                case 8: {
                    this.checkUserPassword(this.user_, password);
                    this.resetConnectionAtFirstSql_ = true;
                    this.setDeferredResetPassword(password);
                    return true;
                }
            }
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.5"), new Integer(securityMechanism));
        }
        catch (SqlException sqle) {
            this.open_ = false;
            try {
                if (this.agent_ != null) {
                    this.agent_.close();
                }
            }
            catch (SqlException ignoreMe) {
                // empty catch block
            }
            throw sqle;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    protected byte[] getCnnToken() {
        return this.cnntkn_;
    }

    protected short getSequenceNumber() {
        this.seqNo_ = (short)(this.seqNo_ + 1);
        return this.seqNo_;
    }

    private void flowUSRIDPWDconnect(String password) throws SqlException {
        this.flowServerAttributesAndKeyExchange(3, null);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, password, null, null);
    }

    private void flowUSRIDONLconnect() throws SqlException {
        this.flowServerAttributesAndKeyExchange(4, null);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, null);
    }

    private void flowUSRENCPWDconnect(String password) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(7);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(7, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, this.encryptedPasswordForUSRENCPWD(password));
    }

    private void flowEUSRIDPWDconnect(String password) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(9);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(9, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(password));
    }

    private void flowEUSRIDDTAconnect() throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(9);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(12, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), null);
    }

    private void flowEUSRPWDDTAconnect(String password) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(13);
        this.initializePublicKeyForEncryption();
        this.flowKeyExchange(13, this.publicKey_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(password));
    }

    private void flowUSRSSBPWDconnect(String password) throws SqlException {
        this.flowServerAttributes();
        this.checkSecmgrForSecmecSupport(8);
        this.initializeClientSeed();
        this.flowSeedExchange(8, this.sourceSeed_);
        this.flowSecurityCheckAndAccessRdb(this.targetSecmec_, this.user_, null, null, this.passwordSubstituteForUSRSSBPWD(password));
    }

    private void flowServerAttributes() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeExchangeServerAttributes(this.extnam_, this.targetAgent_, this.netAgent_.targetSqlam_, this.targetRdb_, this.targetSecmgr_, this.targetCmntcpip_, this.targetCmnappc_, this.targetXamgr_, this.targetSyncptmgr_, this.targetRsyncmgr_);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readExchangeServerAttributes(this);
        this.agent_.endReadChain();
    }

    private void flowKeyExchange(int securityMechanism, byte[] publicKey) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(securityMechanism, this.databaseName_, publicKey);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, securityMechanism);
        this.agent_.endReadChain();
    }

    private void flowSeedExchange(int securityMechanism, byte[] sourceSeed) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(securityMechanism, this.databaseName_, sourceSeed);
        this.agent_.flowOutsideUOW();
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, securityMechanism);
        this.agent_.endReadChain();
    }

    private void flowServerAttributesAndKeyExchange(int securityMechanism, byte[] publicKey) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeServerAttributesAndKeyExchange(securityMechanism, publicKey);
        this.agent_.flowOutsideUOW();
        this.readServerAttributesAndKeyExchange(securityMechanism);
        this.agent_.endReadChain();
    }

    private void flowServerAttributesAndSeedExchange(int securityMechanism, byte[] sourceSeed) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeServerAttributesAndSeedExchange(sourceSeed);
        this.agent_.flowOutsideUOW();
        this.readServerAttributesAndSeedExchange();
        this.agent_.endReadChain();
    }

    private void flowSecurityCheckAndAccessRdb(int securityMechanism, String user, String password, byte[] encryptedUserid, byte[] encryptedPassword) throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeSecurityCheckAndAccessRdb(securityMechanism, user, password, encryptedUserid, encryptedPassword);
        this.agent_.flowOutsideUOW();
        this.readSecurityCheckAndAccessRdb();
        this.agent_.endReadChain();
    }

    private void writeAllConnectCommandsChained(int securityMechanism, String user, String password) throws SqlException {
        this.writeServerAttributesAndKeyExchange(securityMechanism, null);
        this.writeSecurityCheckAndAccessRdb(securityMechanism, user, password, null, null);
    }

    private void readAllConnectCommandsChained(int securityMechanism) throws SqlException {
        this.readServerAttributesAndKeyExchange(securityMechanism);
        this.readSecurityCheckAndAccessRdb();
    }

    private void writeServerAttributesAndKeyExchange(int securityMechanism, byte[] publicKey) throws SqlException {
        this.netAgent_.netConnectionRequest_.writeExchangeServerAttributes(this.extnam_, this.targetAgent_, this.netAgent_.targetSqlam_, this.targetRdb_, this.targetSecmgr_, this.targetCmntcpip_, this.targetCmnappc_, this.targetXamgr_, this.targetSyncptmgr_, this.targetRsyncmgr_);
        this.netAgent_.netConnectionRequest_.writeAccessSecurity(securityMechanism, this.databaseName_, publicKey);
    }

    private void writeServerAttributesAndSeedExchange(byte[] sourceSeed) throws SqlException {
        this.writeServerAttributesAndKeyExchange(8, sourceSeed);
    }

    private void readServerAttributesAndKeyExchange(int securityMechanism) throws SqlException {
        this.netAgent_.netConnectionReply_.readExchangeServerAttributes(this);
        this.netAgent_.netConnectionReply_.readAccessSecurity(this, securityMechanism);
    }

    private void readServerAttributesAndSeedExchange() throws SqlException {
        this.readServerAttributesAndKeyExchange(8);
    }

    private void writeSecurityCheckAndAccessRdb(int securityMechanism, String user, String password, byte[] encryptedUserid, byte[] encryptedPassword) throws SqlException {
        this.netAgent_.netConnectionRequest_.writeSecurityCheck(securityMechanism, this.databaseName_, user, password, encryptedUserid, encryptedPassword);
        this.netAgent_.netConnectionRequest_.writeAccessDatabase(this.databaseName_, false, this.crrtkn_, this.prddta_, this.netAgent_.typdef_);
    }

    private void readSecurityCheckAndAccessRdb() throws SqlException {
        this.netAgent_.netConnectionReply_.readSecurityCheck(this);
        this.netAgent_.netConnectionReply_.readAccessDatabase(this);
    }

    void writeDeferredReset() throws SqlException {
        if (this.securityMechanism_ == 3) {
            this.writeAllConnectCommandsChained(3, this.user_, this.getDeferredResetPassword());
        } else if (this.securityMechanism_ == 4) {
            this.writeAllConnectCommandsChained(4, this.user_, null);
        } else {
            if (this.securityMechanism_ == 8) {
                this.initializeClientSeed();
            } else {
                this.initializePublicKeyForEncryption();
            }
            this.resetConnectionAtFirstSql_ = false;
            if (this.securityMechanism_ == 8) {
                this.flowSeedExchange(this.securityMechanism_, this.sourceSeed_);
            } else {
                this.flowServerAttributesAndKeyExchange(this.securityMechanism_, this.publicKey_);
            }
            this.agent_.beginWriteChainOutsideUOW();
            this.resetConnectionAtFirstSql_ = true;
            if (this.securityMechanism_ == 7) {
                this.writeSecurityCheckAndAccessRdb(7, this.user_, null, null, this.encryptedPasswordForUSRENCPWD(this.getDeferredResetPassword()));
            } else if (this.securityMechanism_ == 8) {
                this.writeSecurityCheckAndAccessRdb(8, this.user_, null, null, this.passwordSubstituteForUSRSSBPWD(this.getDeferredResetPassword()));
            } else {
                this.writeSecurityCheckAndAccessRdb(9, null, null, this.encryptedUseridForEUSRIDPWD(), this.encryptedPasswordForEUSRIDPWD(this.getDeferredResetPassword()));
            }
        }
    }

    void readDeferredReset() throws SqlException {
        this.resetConnectionAtFirstSql_ = false;
        if (this.securityMechanism_ == 3 || this.securityMechanism_ == 4) {
            this.readAllConnectCommandsChained(this.securityMechanism_);
        } else {
            this.readSecurityCheckAndAccessRdb();
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceConnectResetExit(this);
        }
    }

    void setServerAttributeData(String extnam, String srvclsnm, String srvnam, String srvrlslv) {
        this.targetExtnam_ = extnam;
        this.targetSrvclsnm_ = srvclsnm;
        this.targetSrvnam_ = srvnam;
        this.targetSrvrlslv_ = srvrlslv;
    }

    void setAccessSecurityData(int secchkcd, int desiredSecmec, int[] secmecList, boolean sectknReceived, byte[] sectkn) throws DisconnectException {
        if (secchkcd != 0) {
            this.netAgent_.setSvrcod(CodePoint.SVRCOD_ERROR);
            this.agent_.accumulateReadException(this.mapSecchkcd(secchkcd));
        } else if (secmecList.length == 1 && secmecList[0] == desiredSecmec) {
            this.targetSecmec_ = secmecList[0];
            if (this.targetSecmec_ == 7 || this.targetSecmec_ == 9 || this.targetSecmec_ == 8 || this.targetSecmec_ == 12 || this.targetSecmec_ == 13) {
                if (!sectknReceived) {
                    this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.19")));
                } else {
                    if (this.targetSecmec_ == 8) {
                        this.targetSeed_ = sectkn;
                    } else {
                        this.targetPublicKey_ = sectkn;
                    }
                    if (this.encryptionManager_ != null) {
                        this.encryptionManager_.resetSecurityKeys();
                    }
                }
            }
        } else {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, new ClientMessageId("XN002.U")));
        }
    }

    void securityCheckComplete(int svrcod, int secchkcd) {
        this.netAgent_.setSvrcod(svrcod);
        if (secchkcd == 0) {
            return;
        }
        this.agent_.accumulateReadException(this.mapSecchkcd(secchkcd));
    }

    void rdbAccessed(int svrcod, String prdid, boolean crrtknReceived, byte[] crrtkn) {
        if (crrtknReceived) {
            this.crrtkn_ = crrtkn;
        }
        this.netAgent_.setSvrcod(svrcod);
        this.productID_ = prdid;
    }

    protected Agent newAgent_(LogWriter logWriter, int loginTimeout, String serverName, int portNumber, int clientSSLMode) throws SqlException {
        return new NetAgent(this, (NetLogWriter)logWriter, loginTimeout, serverName, portNumber, clientSSLMode);
    }

    protected Statement newStatement_(int type, int concurrency, int holdability) throws SqlException {
        return new NetStatement((NetAgent)this.netAgent_, (NetConnection)this, (int)type, (int)concurrency, (int)holdability).statement_;
    }

    protected void resetStatement_(Statement statement, int type, int concurrency, int holdability) throws SqlException {
        ((NetStatement)statement.materialStatement_).resetNetStatement(this.netAgent_, this, type, concurrency, holdability);
    }

    protected PreparedStatement newPositionedUpdatePreparedStatement_(String sql, Section section) throws SqlException {
        return new NetPreparedStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)sql, (Section)section, (ClientPooledConnection)this.pooledConnection_).preparedStatement_;
    }

    protected PreparedStatement newPreparedStatement_(String sql, int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        return new NetPreparedStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)sql, (int)type, (int)concurrency, (int)holdability, (int)autoGeneratedKeys, (String[])columnNames, (int[])columnIndexes, (ClientPooledConnection)this.pooledConnection_).preparedStatement_;
    }

    protected void resetPreparedStatement_(PreparedStatement ps, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        ((NetPreparedStatement)ps.materialPreparedStatement_).resetNetPreparedStatement(this.netAgent_, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability, autoGeneratedKeys, columnNames, columnIndexes);
    }

    protected CallableStatement newCallableStatement_(String sql, int type, int concurrency, int holdability) throws SqlException {
        return new NetCallableStatement((NetAgent)this.netAgent_, (NetConnection)this, (String)sql, (int)type, (int)concurrency, (int)holdability, (ClientPooledConnection)this.pooledConnection_).callableStatement_;
    }

    protected void resetCallableStatement_(CallableStatement cs, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SqlException {
        ((NetCallableStatement)cs.materialCallableStatement_).resetNetCallableStatement(this.netAgent_, this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    protected DatabaseMetaData newDatabaseMetaData_() {
        return ClientDriver.getFactory().newNetDatabaseMetaData(this.netAgent_, this);
    }

    private void checkDatabaseName() throws SqlException {
        if (this.databaseName_ == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08001.C.1"), "databaseName");
        }
    }

    private void checkUserLength(String user) throws SqlException {
        int usridLength = user.length();
        if (usridLength == 0 || usridLength > 255) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.5"), (Object)new Integer(usridLength), new Integer(255));
        }
    }

    private void checkPasswordLength(String password) throws SqlException {
        int passwordLength = password.length();
        if (passwordLength == 0 || passwordLength > 255) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.6"), (Object)new Integer(passwordLength), new Integer(255));
        }
    }

    private void checkUser(String user) throws SqlException {
        if (user == null) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.7"));
        }
        this.checkUserLength(user);
    }

    private void checkUserPassword(String user, String password) throws SqlException {
        this.checkUser(user);
        if (password == null) {
            throw new SqlException(this.netAgent_.logWriter_, new ClientMessageId("08001.C.8"));
        }
        this.checkPasswordLength(password);
    }

    private void checkSecmgrForSecmecSupport(int securityMechanism) throws SqlException {
        boolean secmecSupported = false;
        int[] supportedSecmecs = null;
        supportedSecmecs = NetConfiguration.SECMGR_SECMECS;
        for (int i = 0; i < supportedSecmecs.length && !secmecSupported; ++i) {
            if (supportedSecmecs[i] != securityMechanism) continue;
            secmecSupported = true;
        }
        if (!secmecSupported) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.5"), new Integer(securityMechanism));
        }
    }

    private SqlException mapSecchkcd(int secchkcd) {
        if (secchkcd == 0) {
            return null;
        }
        switch (secchkcd) {
            case 1: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J110"));
            }
            case 16: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J111"));
            }
            case 18: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J112"));
            }
            case 19: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J113"));
            }
            case 20: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J114"));
            }
            case 21: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J115"));
            }
            case 10: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J116"));
            }
            case 11: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J117"));
            }
            case 14: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J118"));
            }
            case 15: {
                return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J113"));
            }
        }
        return new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil.getTextMessage("J120"));
    }

    protected void constructCrrtkn() throws SqlException {
        byte[] localAddressBytes = null;
        long time = 0L;
        int num = 0;
        int halfByte = 0;
        int i = 0;
        int j = 0;
        if (this.crrtkn_ == null) {
            this.crrtkn_ = new byte[19];
        } else {
            Arrays.fill(this.crrtkn_, (byte)0);
        }
        localAddressBytes = this.netAgent_.socket_.getLocalAddress().getAddress();
        i = 0;
        j = 0;
        while (i < 4) {
            num = localAddressBytes[i] < 0 ? localAddressBytes[i] + 256 : localAddressBytes[i];
            halfByte = num >> 4 & 0xF;
            this.crrtkn_[j] = i == 0 ? this.netAgent_.sourceCcsidManager_.numToSnaRequiredCrrtknChar_[halfByte] : this.netAgent_.sourceCcsidManager_.numToCharRepresentation_[halfByte];
            halfByte = num & 0xF;
            this.crrtkn_[j + 1] = this.netAgent_.sourceCcsidManager_.numToCharRepresentation_[halfByte];
            ++i;
            j += 2;
        }
        this.crrtkn_[8] = this.netAgent_.sourceCcsidManager_.dot_;
        num = this.netAgent_.socket_.getLocalPort();
        halfByte = num >> 12 & 0xF;
        this.crrtkn_[9] = this.netAgent_.sourceCcsidManager_.numToSnaRequiredCrrtknChar_[halfByte];
        halfByte = num >> 8 & 0xF;
        this.crrtkn_[10] = this.netAgent_.sourceCcsidManager_.numToCharRepresentation_[halfByte];
        halfByte = num >> 4 & 0xF;
        this.crrtkn_[11] = this.netAgent_.sourceCcsidManager_.numToCharRepresentation_[halfByte];
        halfByte = num & 0xF;
        this.crrtkn_[12] = this.netAgent_.sourceCcsidManager_.numToCharRepresentation_[halfByte];
        time = System.currentTimeMillis();
        for (i = 0; i < 6; ++i) {
            this.crrtkn_[i + 13] = (byte)(time >>> 40 - i * 8);
        }
    }

    private void constructExtnam() throws SqlException {
        this.extnam_ = "derbydnc" + Thread.currentThread().getName();
    }

    private void constructPrddta() throws SqlException {
        int prddtaLen = 1;
        if (this.prddta_ == null) {
            this.prddta_ = new byte[255];
        } else {
            Arrays.fill(this.prddta_, (byte)0);
        }
        for (int i = 0; i < 55; ++i) {
            this.prddta_[i] = this.netAgent_.sourceCcsidManager_.space_;
        }
        prddtaLen = this.netAgent_.sourceCcsidManager_.convertFromUCS2(NetConfiguration.PRDID, this.prddta_, prddtaLen, this.netAgent_);
        prddtaLen = this.netAgent_.sourceCcsidManager_.convertFromUCS2("JVM               ", this.prddta_, prddtaLen, this.netAgent_);
        int extnamTruncateLength = Utils.min(this.extnam_.length(), 20);
        this.netAgent_.sourceCcsidManager_.convertFromUCS2(this.extnam_.substring(0, extnamTruncateLength), this.prddta_, prddtaLen, this.netAgent_);
        prddtaLen += 20;
        if (this.user_ != null) {
            int userTruncateLength = Utils.min(this.user_.length(), 8);
            this.netAgent_.sourceCcsidManager_.convertFromUCS2(this.user_.substring(0, userTruncateLength), this.prddta_, prddtaLen, this.netAgent_);
        }
        prddtaLen += 8;
        this.prddta_[55] = 0;
        this.prddta_[0] = (byte)(++prddtaLen - 1);
    }

    private void initializePublicKeyForEncryption() throws SqlException {
        if (this.encryptionManager_ == null) {
            this.encryptionManager_ = new EncryptionManager(this.agent_);
        }
        this.publicKey_ = this.encryptionManager_.obtainPublicKey();
    }

    private void initializeClientSeed() throws SqlException {
        if (this.encryptionManager_ == null) {
            this.encryptionManager_ = new EncryptionManager(this.agent_, "SHA-1");
        }
        this.sourceSeed_ = this.encryptionManager_.generateSeed();
    }

    private byte[] encryptedPasswordForUSRENCPWD(String password) throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.sourceCcsidManager_.convertFromUCS2(password, this.netAgent_), 7, this.netAgent_.sourceCcsidManager_.convertFromUCS2(this.user_, this.netAgent_), this.targetPublicKey_);
    }

    private byte[] encryptedUseridForEUSRIDPWD() throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.sourceCcsidManager_.convertFromUCS2(this.user_, this.netAgent_), 9, this.targetPublicKey_, this.targetPublicKey_);
    }

    private byte[] encryptedPasswordForEUSRIDPWD(String password) throws SqlException {
        return this.encryptionManager_.encryptData(this.netAgent_.sourceCcsidManager_.convertFromUCS2(password, this.netAgent_), 9, this.targetPublicKey_, this.targetPublicKey_);
    }

    private byte[] passwordSubstituteForUSRSSBPWD(String password) throws SqlException {
        String dataSourceUserName;
        String userName = this.user_;
        if (this.dataSource_ != null && !(dataSourceUserName = this.dataSource_.getUser()).equals("")) {
            if (userName.equalsIgnoreCase("APP")) {
                if (!dataSourceUserName.equalsIgnoreCase("APP")) {
                    userName = dataSourceUserName;
                }
            }
        }
        return this.encryptionManager_.substitutePassword(userName, password, this.sourceSeed_, this.targetSeed_);
    }

    public int getSQLAM() {
        return this.netAgent_.targetSqlam_;
    }

    public int getAGENT() {
        return this.targetAgent_;
    }

    public int getCMNTCPIP() {
        return this.targetCmntcpip_;
    }

    public int getRDB() {
        return this.targetRdb_;
    }

    public int getSECMGR() {
        return this.targetSecmgr_;
    }

    public int getXAMGR() {
        return this.targetXamgr_;
    }

    public int getSYNCPTMGR() {
        return this.targetSyncptmgr_;
    }

    public int getRSYNCMGR() {
        return this.targetRsyncmgr_;
    }

    private char[] flipBits(char[] array) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = (char)(array[n] ^ 0xFF);
        }
        return array;
    }

    public void writeCommitSubstitute_() throws SqlException {
        this.netAgent_.connectionRequest_.writeCommitSubstitute(this);
    }

    public void readCommitSubstitute_() throws SqlException {
        this.netAgent_.connectionReply_.readCommitSubstitute(this);
    }

    public void writeLocalXAStart_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXAStart(this);
    }

    public void readLocalXAStart_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXAStart(this);
    }

    public void writeLocalXACommit_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXACommit(this);
    }

    public void readLocalXACommit_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXACommit(this);
    }

    public void writeLocalXARollback_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalXARollback(this);
    }

    public void readLocalXARollback_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalXARollback(this);
    }

    public void writeLocalCommit_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalCommit(this);
    }

    public void readLocalCommit_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalCommit(this);
    }

    public void writeLocalRollback_() throws SqlException {
        this.netAgent_.connectionRequest_.writeLocalRollback(this);
    }

    public void readLocalRollback_() throws SqlException {
        this.netAgent_.connectionReply_.readLocalRollback(this);
    }

    protected void markClosed_() {
    }

    protected boolean isGlobalPending_() {
        return false;
    }

    protected boolean doCloseStatementsOnClose_() {
        return this.closeStatementsOnClose;
    }

    protected boolean allowCloseInUOW_() {
        return this.autoCommit_ || !this.allowLocalCommitRollback_();
    }

    protected boolean allowLocalCommitRollback_() {
        return this.getXAState() == 0;
    }

    public void setInputStream(InputStream inputStream) {
        this.netAgent_.setInputStream(inputStream);
    }

    public void setOutputStream(OutputStream outputStream) {
        this.netAgent_.setOutputStream(outputStream);
    }

    public InputStream getInputStream() {
        return this.netAgent_.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.netAgent_.getOutputStream();
    }

    public void writeTransactionStart(Statement statement) throws SqlException {
    }

    public void readTransactionStart() throws SqlException {
        super.readTransactionStart();
    }

    public void setIndoubtTransactions(Hashtable indoubtTransactions) {
        if (this.isXAConnection_) {
            if (this.indoubtTransactions_ != null) {
                this.indoubtTransactions_.clear();
            }
            this.indoubtTransactions_ = indoubtTransactions;
        }
    }

    protected void setReadOnlyTransactionFlag(boolean flag) {
        this.readOnlyTransaction_ = flag;
    }

    public SectionManager newSectionManager(String collection, Agent agent, String databaseName) {
        return new SectionManager(collection, agent, databaseName);
    }

    protected int getSocketAndInputOutputStreams(String server, int port, int clientSSLMode) {
        try {
            this.netAgent_.socket_ = (Socket)AccessController.doPrivileged(new OpenSocketAction(server, port, clientSSLMode));
        }
        catch (PrivilegedActionException e) {
            Exception openSocketException = e.getException();
            if (this.netAgent_.loggingEnabled()) {
                this.netAgent_.logWriter_.tracepoint("[net]", 101, "Client Re-route: " + openSocketException.getClass().getName() + " : " + openSocketException.getMessage());
            }
            return -1;
        }
        try {
            this.netAgent_.rawSocketOutputStream_ = this.netAgent_.socket_.getOutputStream();
            this.netAgent_.rawSocketInputStream_ = this.netAgent_.socket_.getInputStream();
        }
        catch (IOException e) {
            if (this.netAgent_.loggingEnabled()) {
                this.netAgent_.logWriter_.tracepoint("[net]", 103, "Client Re-route: java.io.IOException " + e.getMessage());
            }
            try {
                this.netAgent_.socket_.close();
            }
            catch (IOException doNothing) {
                // empty catch block
            }
            return -1;
        }
        return 0;
    }

    protected int checkAlternateServerHasEqualOrHigherProductLevel(ProductLevel orgLvl, int orgServerType) {
        boolean alternateServerIsEqualOrHigherToOriginalServer;
        if (orgLvl == null && orgServerType == 0) {
            return 0;
        }
        ProductLevel alternateServerProductLvl = this.netAgent_.netConnection_.databaseMetaData_.productLevel_;
        boolean bl = alternateServerIsEqualOrHigherToOriginalServer = alternateServerProductLvl.greaterThanOrEqualTo(orgLvl.versionLevel_, orgLvl.releaseLevel_, orgLvl.modificationLevel_);
        if (!alternateServerIsEqualOrHigherToOriginalServer && this.netAgent_.loggingEnabled()) {
            this.netAgent_.logWriter_.tracepoint("[net]", 99, "Client Re-route failed because the alternate server is on a lower product level than the origianl server.");
        }
        return alternateServerIsEqualOrHigherToOriginalServer ? 0 : -1;
    }

    public boolean willAutoCommitGenerateFlow() {
        if (!this.autoCommit_) {
            return false;
        }
        if (!this.isXAConnection_) {
            return true;
        }
        boolean doCommit = false;
        int xaState = this.getXAState();
        if (xaState == 0) {
            doCommit = true;
        }
        return doCommit;
    }

    public int getSecurityMechanism() {
        return this.securityMechanism_;
    }

    public EncryptionManager getEncryptionManager() {
        return this.encryptionManager_;
    }

    public byte[] getTargetPublicKey() {
        return this.targetPublicKey_;
    }

    public String getProductID() {
        return this.targetSrvclsnm_;
    }

    public void doResetNow() throws SqlException {
        if (!this.resetConnectionAtFirstSql_) {
            return;
        }
        this.agent_.beginWriteChainOutsideUOW();
        this.agent_.flowOutsideUOW();
        this.agent_.endReadChain();
    }

    public boolean isConnectionNull() {
        return this.connectionNull;
    }

    public void setConnectionNull(boolean connectionNull) {
        this.connectionNull = connectionNull;
    }

    public final boolean serverSupportsQryclsimp() {
        NetDatabaseMetaData metadata = (NetDatabaseMetaData)this.databaseMetaData_;
        return metadata.serverSupportsQryclsimp();
    }

    public final boolean serverSupportsLayerBStreaming() {
        NetDatabaseMetaData metadata = (NetDatabaseMetaData)this.databaseMetaData_;
        return metadata.serverSupportsLayerBStreaming();
    }

    protected final boolean supportsSessionDataCaching() {
        NetDatabaseMetaData metadata = (NetDatabaseMetaData)this.databaseMetaData_;
        return metadata.serverSupportsSessionDataCaching();
    }

    protected final boolean serverSupportsLocators() {
        return this.serverSupportsLayerBStreaming();
    }

    public boolean isOpen() {
        return this.open_;
    }

    public synchronized void close() throws SQLException {
        super.close();
        if (!this.isXAConnection_) {
            return;
        }
        if (this.isOpen()) {
            return;
        }
    }

    public synchronized void closeX() throws SQLException {
        super.closeX();
        if (!this.isXAConnection_) {
            return;
        }
        if (this.isOpen()) {
            return;
        }
    }

    public synchronized void closeForReuse() throws SqlException {
        super.closeForReuse(this.closeStatementsOnClose);
        if (!this.isXAConnection_) {
            return;
        }
        if (this.isOpen()) {
            return;
        }
    }

    public synchronized void closeResources() throws SQLException {
        super.closeResources();
        if (!this.isXAConnection_) {
            return;
        }
        if (this.isOpen()) {
            return;
        }
    }

    protected void writeXACommit_() throws SqlException {
        this.xares_.netXAConn_.writeCommit();
    }

    protected void readXACommit_() throws SqlException {
        this.xares_.netXAConn_.readCommit();
    }

    protected void writeXARollback_() throws SqlException {
        this.xares_.netXAConn_.writeRollback();
    }

    protected void readXARollback_() throws SqlException {
        this.xares_.netXAConn_.readRollback();
    }

    protected void writeXATransactionStart(Statement statement) throws SqlException {
        this.xares_.netXAConn_.writeTransactionStart(statement);
    }
}

