/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.Hashtable;
import javax.transaction.xa.Xid;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.client.am.UnitOfWorkListener;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.ConnectionReplyInterface;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.Reply;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.i18n.MessageUtil;

public class NetConnectionReply
extends Reply
implements ConnectionReplyInterface {
    private static MessageUtil msgutil_ = SqlException.getMessageUtil();

    NetConnectionReply(NetAgent netAgent, int bufferSize) {
        super(netAgent, bufferSize);
    }

    void readExchangeServerAttributes(Connection connection) throws SqlException {
        this.startSameIdChainParse();
        this.parseEXCSATreply((NetConnection)connection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void verifyConnectReply(int codept) throws SqlException {
        if (this.peekCodePoint() != codept) {
            this.parseConnectError();
            return;
        }
        this.readLengthAndCodePoint();
        this.skipBytes();
        if (codept == 8705) {
            int peekCP = this.peekCodePoint();
            if (peekCP == -2) {
                return;
            }
            this.parseTypdefsOrMgrlvlovrs();
            NetSqlca netSqlca = this.parseSQLCARD(null);
            this.netAgent_.netConnection_.completeSqlca(netSqlca);
        }
    }

    void parseConnectError() throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4624: {
                this.parseMGRLVLRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void readDummyExchangeServerAttributes(Connection connection) throws SqlException {
        this.startSameIdChainParse();
        this.parseDummyEXCSATreply((NetConnection)connection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void readAccessSecurity(Connection connection, int securityMechanism) throws SqlException {
        this.startSameIdChainParse();
        this.parseACCSECreply((NetConnection)connection, securityMechanism);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void readSecurityCheck(Connection connection) throws SqlException {
        this.startSameIdChainParse();
        this.parseSECCHKreply((NetConnection)connection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    void readAccessDatabase(Connection connection) throws SqlException {
        this.startSameIdChainParse();
        this.parseACCRDBreply((NetConnection)connection);
        this.endOfSameIdChainData();
        this.agent_.checkForChainBreakingException_();
    }

    public void readCommitSubstitute(ConnectionCallbackInterface connection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseDummyEXCSATreply((NetConnection)connection);
        this.endOfSameIdChainData();
    }

    public void readLocalCommit(ConnectionCallbackInterface connection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseRDBCMMreply(connection);
        this.endOfSameIdChainData();
    }

    public void readLocalRollback(ConnectionCallbackInterface connection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseRDBRLLBCKreply(connection);
        this.endOfSameIdChainData();
    }

    public void readLocalXAStart(ConnectionCallbackInterface connection) throws DisconnectException {
    }

    public void readLocalXACommit(ConnectionCallbackInterface connection) throws DisconnectException {
    }

    public void readLocalXARollback(ConnectionCallbackInterface connection) throws DisconnectException {
    }

    protected void readXaStartUnitOfWork(NetConnection conn) throws DisconnectException {
    }

    protected int readXaEndUnitOfWork(NetConnection conn) throws DisconnectException {
        return 0;
    }

    protected int readXaPrepare(NetConnection conn) throws DisconnectException {
        return 0;
    }

    protected void readXaCommit(NetConnection conn) throws DisconnectException {
    }

    protected int readXaRollback(NetConnection conn) throws DisconnectException {
        return 0;
    }

    protected void readXaRecover(NetConnection conn) throws DisconnectException {
    }

    protected void readXaForget(NetConnection conn) throws DisconnectException {
    }

    private void parseRDBCMMreply(ConnectionCallbackInterface connection) throws DisconnectException {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP != 8716 && peekCP != 9224) {
            this.parseCommitError(connection);
            return;
        }
        if (peekCP == 8716) {
            this.parseENDUOWRM(connection);
            peekCP = this.parseTypdefsOrMgrlvlovrs();
        }
        NetSqlca netSqlca = this.parseSQLCARD(null);
        connection.completeSqlca(netSqlca);
    }

    private void parseRDBRLLBCKreply(ConnectionCallbackInterface connection) throws DisconnectException {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP != 8716) {
            this.parseRollbackError();
            return;
        }
        this.parseENDUOWRM(connection);
        peekCP = this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        connection.completeSqlca(netSqlca);
    }

    private void parseEXCSATreply(NetConnection netConnection) throws DisconnectException {
        if (this.peekCodePoint() != 5187) {
            this.parseExchangeServerAttributesError();
            return;
        }
        this.parseEXCSATRD(netConnection);
    }

    private void parseDummyEXCSATreply(NetConnection netConnection) throws DisconnectException {
        if (this.peekCodePoint() != 5187) {
            this.parseExchangeServerAttributesError();
            return;
        }
        this.parseDummyEXCSATRD(netConnection);
    }

    private void parseACCSECreply(NetConnection netConnection, int securityMechanism) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        if (peekCP != 5292) {
            this.parseAccessSecurityError(netConnection);
            return;
        }
        this.parseACCSECRD(netConnection, securityMechanism);
        this.netAgent_.exceptionConvertingRdbnam = null;
        peekCP = this.peekCodePoint();
        if (peekCP == -2) {
            return;
        }
    }

    private void parseSECCHKreply(NetConnection netConnection) throws DisconnectException {
        if (this.peekCodePoint() != 4633) {
            this.parseSecurityCheckError(netConnection);
            return;
        }
        this.parseSECCHKRM(netConnection);
        if (this.peekCodePoint() == 4572) {
            boolean done = false;
            byte[] byArray = this.parseSECTKN(false);
        }
    }

    private void parseACCRDBreply(NetConnection netConnection) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        if (peekCP != 8705) {
            this.parseAccessRdbError(netConnection);
            return;
        }
        this.parseACCRDBRM(netConnection);
        peekCP = this.peekCodePoint();
        if (peekCP == -2) {
            return;
        }
        this.parseTypdefsOrMgrlvlovrs();
        NetSqlca netSqlca = this.parseSQLCARD(null);
        netConnection.completeSqlca(netSqlca);
    }

    protected int parseTypdefsOrMgrlvlovrs() throws DisconnectException {
        int peekCP;
        boolean targetTypedefCloned = false;
        while (true) {
            if ((peekCP = this.peekCodePoint()) == 47) {
                if (!targetTypedefCloned) {
                    this.netAgent_.targetTypdef_ = (Typdef)this.netAgent_.targetTypdef_.clone();
                    targetTypedefCloned = true;
                }
                this.parseTYPDEFNAM();
                continue;
            }
            if (peekCP != 53) break;
            if (!targetTypedefCloned) {
                this.netAgent_.targetTypdef_ = (Typdef)this.netAgent_.targetTypdef_.clone();
                targetTypedefCloned = true;
            }
            this.parseTYPDEFOVR();
        }
        return peekCP;
    }

    protected void parseCommitError(ConnectionCallbackInterface connection) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(connection, null);
                connection.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseRollbackError() throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseExchangeServerAttributesError() throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4624: {
                this.parseMGRLVLRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseAccessSecurityError(NetConnection netConnection) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8721: {
                this.parseRDBNFNRM(netConnection);
                break;
            }
            case 8730: {
                this.parseRdbAccessFailed(netConnection);
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseSecurityCheckError(NetConnection netConnection) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4691: {
                this.parseOBJNSPRM();
                break;
            }
            case 8721: {
                this.parseRDBNFNRM(netConnection);
                break;
            }
            case 8730: {
                this.parseRdbAccessFailed(netConnection);
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseAccessRdbError(NetConnection netConnection) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8711: {
                this.parseRDBACCRM();
                break;
            }
            case 8730: {
                this.parseRdbAccessFailed(netConnection);
                break;
            }
            case 8907: {
                this.parseRDBATHRM(netConnection);
                break;
            }
            case 8721: {
                this.parseRDBNFNRM(netConnection);
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    void parseCommonError(int peekCP) throws DisconnectException {
        switch (peekCP) {
            case 4688: {
                this.parseCMDNSPRM();
                break;
            }
            case 4677: {
                this.parsePRCCNVRM();
                break;
            }
            case 4684: {
                this.parseSYNTAXRM();
                break;
            }
            case 4690: {
                this.parseVALNSPRM();
                break;
            }
            default: {
                this.doObjnsprmSemantics(peekCP);
            }
        }
    }

    NetSqlca parseAbnormalEndUow(ConnectionCallbackInterface connection, UnitOfWorkListener uwl) throws DisconnectException {
        NetSqlca netSqlca;
        this.parseABNUOWRM();
        if (this.peekCodePoint() != 9224) {
            this.parseTypdefsOrMgrlvlovrs();
        }
        if (ExceptionUtil.getSeverityFromIdentifier((netSqlca = this.parseSQLCARD(null)).getSqlState()) > 20000 || uwl == null) {
            connection.completeAbnormalUnitOfWork();
        } else {
            connection.completeAbnormalUnitOfWork(uwl);
        }
        return netSqlca;
    }

    NetSqlca parseAbnormalEndUow(StatementCallbackInterface s) throws DisconnectException {
        return this.parseAbnormalEndUow(s.getConnectionCallbackInterface(), s);
    }

    NetSqlca parseAbnormalEndUow(ResultSetCallbackInterface r) throws DisconnectException {
        return this.parseAbnormalEndUow(r.getConnectionCallbackInterface(), r);
    }

    void parseRdbAccessFailed(NetConnection netConnection) throws DisconnectException {
        this.parseRDBAFLRM();
        if (this.peekCodePoint() == 47) {
            this.parseTYPDEFNAM();
            this.parseTYPDEFOVR();
        } else {
            this.parseTYPDEFOVR();
            this.parseTYPDEFNAM();
        }
        NetSqlca netSqlca = this.parseSQLCARD(null);
        if (netSqlca.getSqlErrmc() == null) {
            netConnection.setConnectionNull(true);
        } else {
            netConnection.completeSqlca(netSqlca);
        }
    }

    private void parseSECCHKRM(NetConnection netConnection) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean secchkcdReceived = false;
        int secchkcd = 0;
        boolean sectknReceived = false;
        byte[] sectkn = null;
        this.parseLengthAndMatchCodePoint(4633);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SEVERE);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4516) {
                foundInPass = true;
                secchkcdReceived = this.checkAndGetReceivedFlag(secchkcdReceived);
                secchkcd = this.parseSECCHKCD();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4572) {
                foundInPass = true;
                sectknReceived = this.checkAndGetReceivedFlag(sectknReceived);
                sectkn = this.parseSECTKN(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, secchkcdReceived);
        netConnection.securityCheckComplete(svrcod, secchkcd);
    }

    private void parseACCRDBRM(NetConnection netConnection) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean prdidReceived = false;
        String prdid = null;
        boolean typdefnamReceived = false;
        boolean typdefovrReceived = false;
        boolean rdbinttknReceived = false;
        boolean crrtknReceived = false;
        byte[] crrtkn = null;
        boolean usridReceived = false;
        String usrid = null;
        this.parseLengthAndMatchCodePoint(8705);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_WARNING);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4398) {
                foundInPass = true;
                prdidReceived = this.checkAndGetReceivedFlag(prdidReceived);
                prdid = this.parsePRDID(false);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 47) {
                foundInPass = true;
                typdefnamReceived = this.checkAndGetReceivedFlag(typdefnamReceived);
                this.parseTYPDEFNAM();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 53) {
                foundInPass = true;
                typdefovrReceived = this.checkAndGetReceivedFlag(typdefovrReceived);
                this.parseTYPDEFOVR();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4512) {
                foundInPass = true;
                usridReceived = this.checkAndGetReceivedFlag(usridReceived);
                usrid = this.parseUSRID(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8501) {
                foundInPass = true;
                crrtknReceived = this.checkAndGetReceivedFlag(crrtknReceived);
                crrtkn = this.parseCRRTKN(false);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, prdidReceived, typdefnamReceived, typdefovrReceived);
        netConnection.rdbAccessed(svrcod, prdid, crrtknReceived, crrtkn);
    }

    void parseENDUOWRM(ConnectionCallbackInterface connection) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean uowdspReceived = false;
        int uowdsp = 0;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8716);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_WARNING);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8469) {
                foundInPass = true;
                uowdspReceived = this.checkAndGetReceivedFlag(uowdspReceived);
                uowdsp = this.parseUOWDSP();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, uowdspReceived);
        this.netAgent_.setSvrcod(svrcod);
        if (uowdsp == 1) {
            connection.completeLocalCommit();
        } else {
            connection.completeLocalRollback();
        }
    }

    protected void parseCMDCHKRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(4692);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_INFO, CodePoint.SVRCOD_SESDMG);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4444) {
                foundInPass = true;
                this.parseLengthAndMatchCodePoint(4444);
                this.skipBytes();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)msgutil_.getTextMessage("J123")));
    }

    void parseRDBNACRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8708);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)msgutil_.getTextMessage("J122")));
    }

    private void parseRDBNFNRM(NetConnection netConnection) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8721);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08004.C.2"), (Object)netConnection.databaseName_));
    }

    private void parseRDBATHRM(NetConnection netConnection) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8907);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.netAgent_.accumulateReadException(new SqlException(this.agent_.logWriter_, new ClientMessageId("08004.C.1"), msgutil_.getTextMessage("J121")));
    }

    protected void parseSYNTAXRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean synerrcdReceived = false;
        int synerrcd = 0;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean codpntReceived = false;
        int codpnt = 0;
        this.parseLengthAndMatchCodePoint(4684);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4426) {
                foundInPass = true;
                synerrcdReceived = this.checkAndGetReceivedFlag(synerrcdReceived);
                synerrcd = this.parseSYNERRCD();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 12) {
                foundInPass = true;
                codpntReceived = this.checkAndGetReceivedFlag(codpntReceived);
                codpnt = this.parseCODPNT();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, synerrcdReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.doSyntaxrmSemantics(codpnt);
    }

    private void parseRDBACCRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8711);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)msgutil_.getTextMessage("J124")));
    }

    private void parseRDBAFLRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8730);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived);
        this.netAgent_.setSvrcod(svrcod);
    }

    protected void parseVALNSPRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean codpntReceived = false;
        int codpnt = 0;
        this.parseLengthAndMatchCodePoint(4690);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 12) {
                foundInPass = true;
                codpntReceived = this.checkAndGetReceivedFlag(codpntReceived);
                codpnt = this.parseCODPNT();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, codpntReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.doValnsprmSemantics(codpnt, "\"\"");
    }

    protected void parsePRCCNVRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean prccnvcdReceived = false;
        int prccnvcd = 0;
        this.parseLengthAndMatchCodePoint(4677);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_SESDMG);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4415) {
                foundInPass = true;
                prccnvcdReceived = this.checkAndGetReceivedFlag(prccnvcdReceived);
                prccnvcd = this.parsePRCCNVCD();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, prccnvcdReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.doPrccnvrmSemantics(4677);
    }

    void parseOBJNSPRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean codpntReceived = false;
        int codpnt = 0;
        this.parseLengthAndMatchCodePoint(4691);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_SEVERE);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 12) {
                foundInPass = true;
                codpntReceived = this.checkAndGetReceivedFlag(codpntReceived);
                codpnt = this.parseCODPNT();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, codpntReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.doObjnsprmSemantics(codpnt);
    }

    private void parseMGRLVLRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean mgrlvllsReceived = false;
        int[] managerCodePoint = null;
        int[] managerLevel = null;
        this.parseLengthAndMatchCodePoint(4624);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 5124) {
                foundInPass = true;
                mgrlvllsReceived = this.checkAndGetReceivedFlag(mgrlvllsReceived);
                this.parseLengthAndMatchCodePoint(5124);
                int managerListLength = this.getDdmLength();
                if (managerListLength == 0 || managerListLength % 7 != 0) {
                    this.doSyntaxrmSemantics(CodePoint.SYNERRCD_OBJ_LEN_NOT_ALLOWED);
                }
                int managerCount = managerListLength / 7;
                managerCodePoint = new int[managerCount];
                managerLevel = new int[managerCount];
                for (int i = 0; i < managerCount; ++i) {
                    managerCodePoint[i] = this.parseCODPNTDR();
                    managerLevel[i] = this.parseMGRLVLN();
                }
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, mgrlvllsReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
    }

    protected void parseCMDNSPRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean srvdgnReceived = false;
        Object srvdgn = null;
        boolean codpntReceived = false;
        int codpnt = 0;
        this.parseLengthAndMatchCodePoint(4688);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 12) {
                foundInPass = true;
                codpntReceived = this.checkAndGetReceivedFlag(codpntReceived);
                codpnt = this.parseCODPNT();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, codpntReceived);
        this.netAgent_.setSvrcod(svrcod);
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58014.C"), (Object)Integer.toHexString(codpnt)));
    }

    void parseABNUOWRM() throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8717);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived);
        this.netAgent_.setSvrcod(svrcod);
    }

    private void parseEXCSATRD(NetConnection netConnection) throws DisconnectException {
        boolean extnamReceived = false;
        String extnam = null;
        boolean mgrlvllsReceived = false;
        boolean srvclsnmReceived = false;
        String srvclsnm = null;
        boolean srvnamReceived = false;
        String srvnam = null;
        boolean srvrlslvReceived = false;
        String srvrlslv = null;
        this.parseLengthAndMatchCodePoint(5187);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4446) {
                foundInPass = true;
                extnamReceived = this.checkAndGetReceivedFlag(extnamReceived);
                extnam = this.parseEXTNAM();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 5124) {
                foundInPass = true;
                mgrlvllsReceived = this.checkAndGetReceivedFlag(mgrlvllsReceived);
                this.parseMGRLVLLS(netConnection);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4423) {
                foundInPass = true;
                srvclsnmReceived = this.checkAndGetReceivedFlag(srvclsnmReceived);
                srvclsnm = this.parseSRVCLSNM();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4461) {
                foundInPass = true;
                srvnamReceived = this.checkAndGetReceivedFlag(srvnamReceived);
                srvnam = this.parseSRVNAM();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4442) {
                foundInPass = true;
                srvrlslvReceived = this.checkAndGetReceivedFlag(srvrlslvReceived);
                srvrlslv = this.parseSRVRLSLV();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        netConnection.setServerAttributeData(extnam, srvclsnm, srvnam, srvrlslv);
    }

    private void parseDummyEXCSATRD(NetConnection netConnection) throws DisconnectException {
        boolean extnamReceived = false;
        String extnam = null;
        boolean mgrlvllsReceived = false;
        boolean srvclsnmReceived = false;
        String srvclsnm = null;
        boolean srvnamReceived = false;
        String srvnam = null;
        boolean srvrlslvReceived = false;
        String srvrlslv = null;
        this.parseLengthAndMatchCodePoint(5187);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4446) {
                foundInPass = true;
                extnamReceived = this.checkAndGetReceivedFlag(extnamReceived);
                extnam = this.parseEXTNAM();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 5124) {
                foundInPass = true;
                mgrlvllsReceived = this.checkAndGetReceivedFlag(mgrlvllsReceived);
                this.parseMGRLVLLS(netConnection);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4423) {
                foundInPass = true;
                srvclsnmReceived = this.checkAndGetReceivedFlag(srvclsnmReceived);
                srvclsnm = this.parseSRVCLSNM();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4461) {
                foundInPass = true;
                srvnamReceived = this.checkAndGetReceivedFlag(srvnamReceived);
                srvnam = this.parseSRVNAM();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4442) {
                foundInPass = true;
                srvrlslvReceived = this.checkAndGetReceivedFlag(srvrlslvReceived);
                srvrlslv = this.parseSRVRLSLV();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
    }

    private void parseACCSECRD(NetConnection netConnection, int securityMechanism) throws DisconnectException {
        boolean secmecReceived = false;
        int[] secmecList = null;
        boolean sectknReceived = false;
        byte[] sectkn = null;
        boolean secchkcdReceived = false;
        int secchkcd = 0;
        this.parseLengthAndMatchCodePoint(5292);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4514) {
                foundInPass = true;
                secmecReceived = this.checkAndGetReceivedFlag(secmecReceived);
                secmecList = this.parseSECMEC();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4572) {
                foundInPass = true;
                sectknReceived = this.checkAndGetReceivedFlag(sectknReceived);
                sectkn = this.parseSECTKN(false);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4516) {
                foundInPass = true;
                secchkcdReceived = this.checkAndGetReceivedFlag(secchkcdReceived);
                secchkcd = this.parseSECCHKCD();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(secmecReceived);
        netConnection.setAccessSecurityData(secchkcd, securityMechanism, secmecList, sectknReceived, sectkn);
    }

    void parseTYPDEFNAM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(47);
        this.netAgent_.targetTypdef_.setTypdefnam(this.readString());
    }

    void parseTYPDEFOVR() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(53);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4508) {
                foundInPass = true;
                this.netAgent_.targetTypdef_.setCcsidSbc(this.parseCCSIDSBC());
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4509) {
                foundInPass = true;
                this.netAgent_.targetTypdef_.setCcsidDbc(this.parseCCSIDDBC());
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4510) {
                foundInPass = true;
                this.netAgent_.targetTypdef_.setCcsidMbc(this.parseCCSIDMBC());
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
    }

    int parseSYNCCRD(ConnectionCallbackInterface connection) throws DisconnectException {
        return 0;
    }

    protected int parseXARETVAL() throws DisconnectException {
        return 0;
    }

    protected byte parseSYNCTYPE() throws DisconnectException {
        return 0;
    }

    protected int parseSYNCCTLreply(ConnectionCallbackInterface connection) throws DisconnectException {
        if (this.peekCodePoint() == 49152) {
            this.parsePBSD();
        }
        return 0;
    }

    void parseSYNCCTLError(int peekCP) throws DisconnectException {
        switch (peekCP) {
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4677: {
                this.parsePRCCNVRM();
                break;
            }
            case 4684: {
                this.parseSYNTAXRM();
                break;
            }
            case 4690: {
                this.parseVALNSPRM();
                break;
            }
            default: {
                this.doObjnsprmSemantics(peekCP);
            }
        }
    }

    private void parseMGRLVLLS(NetConnection netConnection) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(5124);
        int managerListLength = this.getDdmLength();
        if (managerListLength == 0 || managerListLength % 4 != 0) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_OBJ_LEN_NOT_ALLOWED);
        }
        int managerCount = managerListLength / 4;
        block11: for (int i = 0; i < managerCount; ++i) {
            int managerCodePoint = this.parseCODPNTDR();
            int managerLevel = this.parseMGRLVLN();
            switch (managerCodePoint) {
                case 5123: {
                    if (managerLevel < 3 || managerLevel > netConnection.targetAgent_) {
                        this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
                    }
                    netConnection.targetAgent_ = managerLevel;
                    continue block11;
                }
                case 5236: {
                    if (managerLevel < 5 || managerLevel > netConnection.targetCmntcpip_) {
                        this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
                    }
                    netConnection.targetCmntcpip_ = managerLevel;
                    continue block11;
                }
                case 9231: {
                    if (managerLevel < 3 || managerLevel > netConnection.targetRdb_) {
                        this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
                    }
                    netConnection.targetRdb_ = managerLevel;
                    continue block11;
                }
                case 5184: {
                    if (managerLevel < 5 || managerLevel > netConnection.targetSecmgr_) {
                        this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
                    }
                    netConnection.targetSecmgr_ = managerLevel;
                    continue block11;
                }
                case 9223: {
                    if (managerLevel < 4 || managerLevel > this.netAgent_.targetSqlam_) {
                        this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
                    }
                    this.netAgent_.orignalTargetSqlam_ = managerLevel;
                    continue block11;
                }
                case 5188: {
                    if (managerLevel < 3 || managerLevel > netConnection.targetCmnappc_) {
                        this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
                    }
                    netConnection.targetCmnappc_ = managerLevel;
                    continue block11;
                }
                case 7169: {
                    if (managerLevel != 0 && managerLevel < 7 || managerLevel > netConnection.targetXamgr_) {
                        this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
                    }
                    netConnection.targetXamgr_ = managerLevel;
                    continue block11;
                }
                case 5312: {
                    if (managerLevel != 0 && managerLevel < 5 || managerLevel > netConnection.targetSyncptmgr_) {
                        this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
                    }
                    netConnection.targetSyncptmgr_ = managerLevel;
                    continue block11;
                }
                case 5313: {
                    if (managerLevel != 0 && managerLevel < 5 || managerLevel > netConnection.targetRsyncmgr_) {
                        this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
                    }
                    netConnection.targetRsyncmgr_ = managerLevel;
                    continue block11;
                }
                default: {
                    this.doMgrlvlrmSemantics(managerCodePoint, managerLevel);
                }
            }
        }
    }

    protected String parseEXTNAM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4446);
        return this.readString();
    }

    protected String parseSRVCLSNM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4423);
        return this.readString();
    }

    protected String parseSRVNAM() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4461);
        return this.readString();
    }

    protected String parseSRVRLSLV() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4442);
        return this.readString();
    }

    protected int parseMGRLVLN() throws DisconnectException {
        return this.readUnsignedShort();
    }

    protected int[] parseSECMEC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4514);
        return this.readUnsignedShortList();
    }

    protected byte[] parseSECTKN(boolean skip) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4572);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readBytes();
    }

    protected int parseSECCHKCD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4516);
        int secchkcd = this.readUnsignedByte();
        if (secchkcd < 0 || secchkcd > 21) {
            this.doValnsprmSemantics(4516, secchkcd);
        }
        return secchkcd;
    }

    protected String parsePRDID(boolean skip) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4398);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    protected String parseUSRID(boolean skip) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4512);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    protected int parseCODPNTDR() throws DisconnectException {
        return this.readUnsignedShort();
    }

    protected byte[] parseCRRTKN(boolean skip) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8501);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readBytes();
    }

    protected int parseUOWDSP() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8469);
        int uowdsp = this.readUnsignedByte();
        if (uowdsp != 1 && uowdsp != 2) {
            this.doValnsprmSemantics(8469, uowdsp);
        }
        return uowdsp;
    }

    protected String parseRDBNAM(boolean skip) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(8464);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    protected int parseXIDCNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6406);
        return this.readUnsignedShort();
    }

    protected Xid parseXID() throws DisconnectException {
        return null;
    }

    protected Hashtable parseIndoubtList() throws DisconnectException {
        return null;
    }

    protected int parseSYNERRCD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4426);
        int synerrcd = this.readUnsignedByte();
        if (synerrcd < 1 || synerrcd > 29) {
            this.doValnsprmSemantics(4426, synerrcd);
        }
        return synerrcd;
    }

    protected int parseCODPNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(12);
        return this.parseCODPNTDR();
    }

    protected int parsePRCCNVCD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4415);
        int prccnvcd = this.readUnsignedByte();
        if (prccnvcd != 1 && prccnvcd != 2 && prccnvcd != 3 && prccnvcd != 4 && prccnvcd != 5 && prccnvcd != 6 && prccnvcd != 16 && prccnvcd != 17 && prccnvcd != 18 && prccnvcd != 19 && prccnvcd != 21) {
            this.doValnsprmSemantics(4415, prccnvcd);
        }
        return prccnvcd;
    }

    protected int parseCCSIDSBC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4508);
        return this.readUnsignedShort();
    }

    protected int parseCCSIDMBC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4510);
        return this.readUnsignedShort();
    }

    protected int parseCCSIDDBC() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4509);
        return this.readUnsignedShort();
    }

    protected int parseSVRCOD(int minSvrcod, int maxSvrcod) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4425);
        int svrcod = this.readUnsignedShort();
        if (svrcod != CodePoint.SVRCOD_INFO && svrcod != CodePoint.SVRCOD_WARNING && svrcod != CodePoint.SVRCOD_ERROR && svrcod != CodePoint.SVRCOD_SEVERE && svrcod != CodePoint.SVRCOD_ACCDMG && svrcod != CodePoint.SVRCOD_PRMDMG && svrcod != CodePoint.SVRCOD_SESDMG) {
            this.doValnsprmSemantics(4425, svrcod);
        }
        if (svrcod < minSvrcod || svrcod > maxSvrcod) {
            this.doValnsprmSemantics(4425, svrcod);
        }
        return svrcod;
    }

    protected int parseFastSVRCOD(int minSvrcod, int maxSvrcod) throws DisconnectException {
        this.matchCodePoint(4425);
        int svrcod = this.readFastUnsignedShort();
        if (svrcod != CodePoint.SVRCOD_INFO && svrcod != CodePoint.SVRCOD_WARNING && svrcod != CodePoint.SVRCOD_ERROR && svrcod != CodePoint.SVRCOD_SEVERE && svrcod != CodePoint.SVRCOD_ACCDMG && svrcod != CodePoint.SVRCOD_PRMDMG && svrcod != CodePoint.SVRCOD_SESDMG) {
            this.doValnsprmSemantics(4425, svrcod);
        }
        if (svrcod < minSvrcod || svrcod > maxSvrcod) {
            this.doValnsprmSemantics(4425, svrcod);
        }
        return svrcod;
    }

    protected NetSqlca parseSQLCARD(Sqlca[] rowsetSqlca) throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9224);
        int ddmLength = this.getDdmLength();
        this.ensureBLayerDataInBuffer(ddmLength);
        NetSqlca netSqlca = this.parseSQLCARDrow(rowsetSqlca);
        this.adjustLengths(this.getDdmLength());
        return netSqlca;
    }

    NetSqlca parseSQLCARDrow(Sqlca[] rowsetSqlca) throws DisconnectException {
        return this.parseSQLCAGRP(rowsetSqlca);
    }

    int parseSQLNUMROW() throws DisconnectException {
        return this.parseSQLNUMGRP();
    }

    int parseFastSQLNUMROW() throws DisconnectException {
        return this.parseFastSQLNUMGRP();
    }

    private int parseSQLNUMGRP() throws DisconnectException {
        return this.readShort();
    }

    private int parseFastSQLNUMGRP() throws DisconnectException {
        return this.readFastShort();
    }

    private NetSqlca parseSQLCAGRP(Sqlca[] rowsetSqlca) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return null;
        }
        int sqlcode = this.readFastInt();
        byte[] sqlstate = this.readFastBytes(5);
        byte[] sqlerrproc = this.readFastBytes(8);
        NetSqlca netSqlca = null;
        try {
            netSqlca = new NetSqlca((Connection)this.netAgent_.netConnection_, sqlcode, sqlstate, sqlerrproc);
        }
        catch (SqlException sqle) {
            throw new DisconnectException((Agent)this.netAgent_, sqle);
        }
        this.parseSQLCAXGRP(netSqlca);
        if (this.netAgent_.targetSqlam_ >= 7) {
            netSqlca.setRowsetRowCount(this.parseSQLDIAGGRP(rowsetSqlca));
        }
        return netSqlca;
    }

    private void parseSQLCAXGRP(NetSqlca netSqlca) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            netSqlca.setContainsSqlcax(false);
            return;
        }
        if (this.netAgent_.targetSqlam_ < 7) {
            this.skipFastBytes(18);
        }
        int[] sqlerrd = new int[6];
        this.readFastIntArray(sqlerrd);
        byte[] sqlwarn = this.readFastBytes(11);
        if (this.netAgent_.targetSqlam_ >= 7) {
            this.parseFastVCS();
        }
        int sqlerrmcCcsid = 0;
        byte[] sqlerrmc = this.readFastLDBytes();
        if (sqlerrmc != null) {
            sqlerrmcCcsid = this.netAgent_.targetTypdef_.getCcsidMbc();
            this.skipFastBytes(2);
        } else {
            sqlerrmc = this.readFastLDBytes();
            sqlerrmcCcsid = this.netAgent_.targetTypdef_.getCcsidSbc();
        }
        netSqlca.setSqlerrd(sqlerrd);
        netSqlca.setSqlwarnBytes(sqlwarn);
        netSqlca.setSqlerrmcBytes(sqlerrmc, sqlerrmcCcsid);
    }

    private long parseSQLDIAGGRP(Sqlca[] rowsetSqlca) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return 0L;
        }
        long row_count = this.parseSQLDIAGSTT(rowsetSqlca);
        this.parseSQLDIAGCI(rowsetSqlca);
        this.parseSQLDIAGCN();
        return row_count;
    }

    protected String parseFastVCS() throws DisconnectException {
        return this.readFastString(this.readFastUnsignedShort(), this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
    }

    protected boolean checkAndGetReceivedFlag(boolean receivedFlag) throws DisconnectException {
        if (receivedFlag) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DUP_OBJ_PRESENT);
        }
        return true;
    }

    protected void checkRequiredObjects(boolean receivedFlag) throws DisconnectException {
        if (!receivedFlag) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void checkRequiredObjects(boolean receivedFlag, boolean receivedFlag2) throws DisconnectException {
        if (!receivedFlag || !receivedFlag2) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void checkRequiredObjects(boolean receivedFlag, boolean receivedFlag2, boolean receivedFlag3) throws DisconnectException {
        if (!(receivedFlag && receivedFlag2 && receivedFlag3)) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void checkRequiredObjects(boolean receivedFlag, boolean receivedFlag2, boolean receivedFlag3, boolean receivedFlag4) throws DisconnectException {
        if (!(receivedFlag && receivedFlag2 && receivedFlag3 && receivedFlag4)) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void checkRequiredObjects(boolean receivedFlag, boolean receivedFlag2, boolean receivedFlag3, boolean receivedFlag4, boolean receivedFlag5, boolean receivedFlag6) throws DisconnectException {
        if (!(receivedFlag && receivedFlag2 && receivedFlag3 && receivedFlag4 && receivedFlag5 && receivedFlag6)) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void checkRequiredObjects(boolean receivedFlag, boolean receivedFlag2, boolean receivedFlag3, boolean receivedFlag4, boolean receivedFlag5, boolean receivedFlag6, boolean receivedFlag7) throws DisconnectException {
        if (!(receivedFlag && receivedFlag2 && receivedFlag3 && receivedFlag4 && receivedFlag5 && receivedFlag6 && receivedFlag7)) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_REQ_OBJ_NOT_FOUND);
        }
    }

    protected void doObjnsprmSemantics(int codePoint) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58015.C"), (Object)Integer.toHexString(codePoint)));
    }

    protected void doPrmnsprmSemantics(int codePoint) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58016.C"), (Object)Integer.toHexString(codePoint)));
    }

    void doValnsprmSemantics(int codePoint, int value) throws DisconnectException {
        this.doValnsprmSemantics(codePoint, Integer.toString(value));
    }

    void doValnsprmSemantics(int codePoint, String value) throws DisconnectException {
        if (codePoint == 5242) {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, new ClientMessageId("58017.C"), Integer.toHexString(codePoint)));
            return;
        }
        if (codePoint == 4508 || codePoint == 4509 || codePoint == 4510) {
            int cpValue = 0;
            switch (codePoint) {
                case 4508: {
                    cpValue = this.netAgent_.typdef_.getCcsidSbc();
                    break;
                }
                case 4509: {
                    cpValue = this.netAgent_.typdef_.getCcsidDbc();
                    break;
                }
                case 4510: {
                    cpValue = this.netAgent_.typdef_.getCcsidSbc();
                    break;
                }
                default: {
                    cpValue = 0;
                }
            }
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("57017.C"), (Object)new Integer(cpValue), (Object)value));
            return;
        }
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58017.C"), (Object)Integer.toHexString(codePoint)));
    }

    void doDtamchrmSemantics() throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)msgutil_.getTextMessage("J125")));
    }

    private void doMgrlvlrmSemantics(String manager, String level) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58010.C"), (Object)manager, (Object)level));
    }

    private void doMgrlvlrmSemantics(int manager, int level) throws DisconnectException {
        this.doMgrlvlrmSemantics("0x" + Integer.toHexString(manager), "0x" + Integer.toHexString(level));
    }

    private void doMgrlvlrmSemantics(int[] nameList, int[] levelList) throws DisconnectException {
        StringBuffer managerNames = new StringBuffer(100);
        StringBuffer managerLevels = new StringBuffer(100);
        int count = nameList.length;
        for (int i = 0; i < count; ++i) {
            managerNames.append("0x");
            managerNames.append(nameList[i]);
            managerLevels.append("0x");
            managerLevels.append(levelList[i]);
            if (i == count - 1) continue;
            managerNames.append(",");
            managerLevels.append(",");
        }
        this.doMgrlvlrmSemantics(managerNames.toString(), managerLevels.toString());
    }

    protected void doPrccnvrmSemantics(int conversationProtocolErrorCode) throws DisconnectException {
        this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), (Object)msgutil_.getTextMessage("J126", Integer.toHexString(conversationProtocolErrorCode))));
    }

    void parseSQLDCTOKS() throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        int num = this.parseFastSQLNUMROW();
        for (int i = 0; i < num; ++i) {
            this.parseSQLTOKROW();
        }
    }

    private void parseSQLDIAGCI(Sqlca[] rowsetSqlca) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        int num = this.parseFastSQLNUMROW();
        if (num == 0) {
            this.resetRowsetSqlca(rowsetSqlca, 0);
        }
        int lastRow = 1;
        for (int i = 0; i < num; ++i) {
            lastRow = this.parseSQLDCROW(rowsetSqlca, lastRow);
        }
        this.resetRowsetSqlca(rowsetSqlca, lastRow + 1);
    }

    private void parseSQLDIAGCN() throws DisconnectException {
        if (this.readUnsignedByte() == 255) {
            return;
        }
        int num = this.parseFastSQLNUMROW();
        for (int i = 0; i < num; ++i) {
            this.parseSQLCNROW();
        }
    }

    private void parseSQLCNROW() throws DisconnectException {
        this.parseSQLCNGRP();
    }

    private int parseSQLDCROW(Sqlca[] rowsetSqlca, int lastRow) throws DisconnectException {
        return this.parseSQLDCGRP(rowsetSqlca, lastRow);
    }

    private void parseSQLTOKROW() throws DisconnectException {
        this.parseSQLTOKGRP();
    }

    private void parseSQLTOKGRP() throws DisconnectException {
        this.skipFastNVCMorNVCS();
    }

    private long parseSQLDIAGSTT(Sqlca[] rowsetSqlca) throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return 0L;
        }
        int sqldsFcod = this.readFastInt();
        int sqldsCost = this.readFastInt();
        int sqldsLrow = this.readFastInt();
        this.skipFastBytes(16);
        long sqldsRowc = this.readFastLong();
        this.skipFastBytes(24);
        return sqldsRowc;
    }

    private void parseSQLCNGRP() throws DisconnectException {
        this.skipBytes(18);
        String sqlcnRDB = this.parseFastVCS();
        String sqlcnClass = this.parseFastVCS();
        String sqlcnAuthid = this.parseFastVCS();
    }

    private int parseSQLDCGRP(Sqlca[] rowsetSqlca, int lastRow) throws DisconnectException {
        int sqldcCode = this.readFastInt();
        String sqldcState = this.readFastString(5, "UTF8");
        int sqldcReason = this.readFastInt();
        int sqldcLinen = this.readFastInt();
        int sqldcRown = (int)this.readFastLong();
        if (sqldcCode == 20237) {
            rowsetSqlca[0] = new NetSqlca((Connection)this.netAgent_.netConnection_, sqldcCode, sqldcState, null);
        } else if (rowsetSqlca[sqldcRown] != null) {
            rowsetSqlca[sqldcRown].resetRowsetSqlca(this.netAgent_.netConnection_, sqldcCode, sqldcState, null);
        } else {
            rowsetSqlca[sqldcRown] = new NetSqlca((Connection)this.netAgent_.netConnection_, sqldcCode, sqldcState, null);
        }
        for (int i = lastRow + 1; i < sqldcRown; ++i) {
            rowsetSqlca[i] = null;
        }
        this.skipFastBytes(47);
        String sqldcRdb = this.parseFastVCS();
        this.parseSQLDCTOKS();
        String sqldcMsg = this.parseFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseSQLDCXGRP();
        return sqldcRown;
    }

    private void parseSQLDCXGRP() throws DisconnectException {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        String sqldcxCrdb = this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
    }

    private String parseFastNVCMorNVCS() throws DisconnectException {
        String stringToBeSet = null;
        int vcm_length = 0;
        int vcs_length = 0;
        if (this.readFastUnsignedByte() != 255) {
            vcm_length = this.readFastUnsignedShort();
            if (vcm_length > 0) {
                stringToBeSet = this.readFastString(vcm_length, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
            }
            if (this.readFastUnsignedByte() != 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.20")));
            }
        } else if (this.readFastUnsignedByte() != 255 && (vcs_length = this.readFastUnsignedShort()) > 0) {
            stringToBeSet = this.readFastString(vcs_length, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        }
        return stringToBeSet;
    }

    private void skipFastNVCMorNVCS() throws DisconnectException {
        int vcm_length = 0;
        int vcs_length = 0;
        if (this.readFastUnsignedByte() != 255) {
            vcm_length = this.readFastUnsignedShort();
            if (vcm_length > 0) {
                this.skipFastBytes(vcm_length);
            }
            if (this.readFastUnsignedByte() != 255) {
                this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("58009.C.20")));
            }
        } else if (this.readFastUnsignedByte() != 255 && (vcs_length = this.readFastUnsignedShort()) > 0) {
            this.skipFastBytes(vcs_length);
        }
    }

    void resetRowsetSqlca(Sqlca[] rowsetSqlca, int row) {
        int count = rowsetSqlca == null ? 0 : rowsetSqlca.length;
        for (int i = row; i < count; ++i) {
            rowsetSqlca[i] = null;
        }
    }

    protected void parsePBSD() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(49152);
        int peekCP = this.peekCodePoint();
        while (peekCP != -2) {
            this.parseLengthAndMatchCodePoint(peekCP);
            switch (peekCP) {
                case 49153: {
                    this.netAgent_.netConnection_.completePiggyBackIsolation(this.readUnsignedByte());
                    break;
                }
                case 49154: {
                    this.netAgent_.netConnection_.completePiggyBackSchema(this.readString(this.getDdmLength(), "UTF-8"));
                    break;
                }
                default: {
                    this.parseCommonError(peekCP);
                }
            }
            peekCP = this.peekCodePoint();
        }
    }
}

