/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Provider;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;

public final class AliasDescriptor
extends TupleDescriptor
implements UniqueTupleDescriptor,
Provider {
    private final UUID aliasID;
    private final String aliasName;
    private final UUID schemaID;
    private final String javaClassName;
    private final char aliasType;
    private final char nameSpace;
    private final boolean systemAlias;
    private final AliasInfo aliasInfo;
    private final String specificName;

    public AliasDescriptor(DataDictionary dataDictionary, UUID aliasID, String aliasName, UUID schemaID, String javaClassName, char aliasType, char nameSpace, boolean systemAlias, AliasInfo aliasInfo, String specificName) {
        super(dataDictionary);
        this.aliasID = aliasID;
        this.aliasName = aliasName;
        this.schemaID = schemaID;
        this.javaClassName = javaClassName;
        this.aliasType = aliasType;
        this.nameSpace = nameSpace;
        this.systemAlias = systemAlias;
        this.aliasInfo = aliasInfo;
        if (specificName == null) {
            specificName = dataDictionary.getSystemSQLName();
        }
        this.specificName = specificName;
    }

    public UUID getUUID() {
        return this.aliasID;
    }

    public UUID getSchemaUUID() {
        return this.schemaID;
    }

    public String getJavaClassName() {
        return this.javaClassName;
    }

    public char getAliasType() {
        return this.aliasType;
    }

    public char getNameSpace() {
        return this.nameSpace;
    }

    public boolean getSystemAlias() {
        return this.systemAlias;
    }

    public AliasInfo getAliasInfo() {
        return this.aliasInfo;
    }

    public String toString() {
        return "aliasID: " + this.aliasID + "\n" + "aliasName: " + this.aliasName + "\n" + "schemaID: " + this.schemaID + "\n" + "javaClassName: " + this.javaClassName + "\n" + "aliasType: " + this.aliasType + "\n" + "nameSpace: " + this.nameSpace + "\n" + "systemAlias: " + this.systemAlias + "\n" + "aliasInfo: " + this.aliasInfo + "\n";
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof AliasDescriptor)) {
            return false;
        }
        AliasDescriptor other = (AliasDescriptor)otherObject;
        return this.aliasID.equals(other.getUUID());
    }

    public int hashCode() {
        return this.aliasID.hashCode();
    }

    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(136);
    }

    public String getObjectName() {
        return this.aliasName;
    }

    public UUID getObjectID() {
        return this.aliasID;
    }

    public String getClassType() {
        return "Alias";
    }

    public String getDescriptorType() {
        return AliasDescriptor.getAliasType(this.aliasType);
    }

    public static final String getAliasType(char nameSpace) {
        switch (nameSpace) {
            case 'P': {
                return "PROCEDURE";
            }
            case 'F': {
                return "FUNCTION";
            }
            case 'S': {
                return "SYNONYM";
            }
        }
        return null;
    }

    public String getDescriptorName() {
        return this.aliasName;
    }

    public String getSpecificName() {
        return this.specificName;
    }

    public boolean isPersistent() {
        return !this.getSchemaUUID().toString().equals("c013800d-00fb-2642-07ec-000000134f30");
    }

    public boolean isTableFunction() {
        if (this.getAliasType() != 'F') {
            return false;
        }
        RoutineAliasInfo rai = (RoutineAliasInfo)this.getAliasInfo();
        return rai.getReturnType().isRowMultiSet();
    }

    public void drop(LanguageConnectionContext lcc) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        DependencyManager dm = dd.getDependencyManager();
        int invalidationType = 0;
        switch (this.getAliasType()) {
            case 'F': 
            case 'P': {
                invalidationType = 6;
                break;
            }
            case 'S': {
                invalidationType = 43;
            }
        }
        dm.invalidateFor(this, invalidationType, lcc);
        if (this.getAliasType() == 'S') {
            SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaID, tc);
            DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
            TableDescriptor td = ddg.newTableDescriptor(this.aliasName, sd, 4, 'R');
            dd.dropTableDescriptor(td, sd, tc);
        } else {
            dd.dropAllRoutinePermDescriptors(this.getUUID(), tc);
        }
        dd.dropAliasDescriptor(this, tc);
    }
}

