/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.io.DirRandomAccessFile;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

class DirFile
extends File
implements StorageFile {
    DirFile(String path) {
        super(path);
    }

    DirFile(String directoryName, String fileName) {
        super(directoryName, fileName);
    }

    DirFile(DirFile directoryName, String fileName) {
        super(directoryName, fileName);
    }

    public StorageFile getParentDir() {
        String parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return new DirFile(parent);
    }

    static StorageFile getTempDir() throws IOException {
        File temp = File.createTempFile("derby", "tmp");
        DirFile parent = new DirFile(temp.getParent());
        temp.delete();
        return parent;
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this);
    }

    public OutputStream getOutputStream(boolean append) throws FileNotFoundException {
        return new FileOutputStream(this.getPath(), append);
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this);
    }

    public synchronized int getExclusiveFileLock() {
        if (this.exists()) {
            this.delete();
        }
        try {
            RandomAccessFile lockFileOpen = new RandomAccessFile(this, "rw");
            lockFileOpen.getFD().sync();
            lockFileOpen.close();
        }
        catch (IOException ioe) {
            SanityManager.THROWASSERT("Unable to create Exclusive Lock File " + this.getPath(), ioe);
        }
        return 0;
    }

    public synchronized void releaseExclusiveFileLock() {
        if (this.exists()) {
            this.delete();
        }
    }

    public StorageRandomAccessFile getRandomAccessFile(String mode) throws FileNotFoundException {
        if ("rws".equals(mode) || "rwd".equals(mode)) {
            mode = "rw";
        }
        return new DirRandomAccessFile(this, mode);
    }

    public boolean renameTo(StorageFile newName) {
        return super.renameTo((File)((Object)newName));
    }

    public boolean deleteAll() {
        if (!this.exists()) {
            return false;
        }
        if (this.isDirectory()) {
            String[] childList = super.list();
            String parentName = this.getPath();
            for (int i = 0; i < childList.length; ++i) {
                DirFile child;
                if (childList[i].equals(".") || childList[i].equals("..") || (child = new DirFile(parentName, childList[i])).deleteAll()) continue;
                return false;
            }
        }
        return this.delete();
    }

    public URL getURL() throws MalformedURLException {
        return this.toURL();
    }
}

