/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.jdbc.ConnectionChild;
import org.apache.derby.impl.jdbc.EmbedConnection;

final class EmbedSavepoint30
extends ConnectionChild
implements Savepoint {
    private final String savepointName;
    private final int savepointID;

    EmbedSavepoint30(EmbedConnection conn, String name) throws StandardException {
        super(conn);
        if (name == null) {
            this.savepointName = "i." + conn.getLanguageConnection().getUniqueSavepointName();
            this.savepointID = conn.getLanguageConnection().getUniqueSavepointID();
        } else {
            this.savepointName = "e." + name;
            this.savepointID = -1;
        }
        conn.getLanguageConnection().languageSetSavePoint(this.savepointName, this);
    }

    public int getSavepointId() throws SQLException {
        if (this.savepointID == -1) {
            throw this.newSQLException("XJ013.S");
        }
        return this.savepointID;
    }

    public String getSavepointName() throws SQLException {
        if (this.savepointID != -1) {
            throw this.newSQLException("XJ014.S");
        }
        return this.savepointName.substring(2);
    }

    String getInternalName() {
        return this.savepointName;
    }

    boolean sameConnection(EmbedConnection con) {
        return this.getEmbedConnection().getLanguageConnection() == con.getLanguageConnection();
    }
}

