/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.services.bytecode.Type;

class d_BCValidate {
    private static final String[] csPackages = new String[]{"java", "org.apache.derby.exe.", "org.apache.derby.iapi.", "org.apache.derby.jdbc.", "org.apache.derby.iapi.", "org.apache.derby.impl.", "org.apache.derby.authentication.", "org.apache.derby.catalog.", "org.apache.derby.iapi.db.", "org.apache.derby.iapi.types.", "org.apache.derby.iapi.types.", "org.apache.derby.catalog.types."};
    private static final Class[] NO_PARAMS = new Class[0];
    private static Hashtable primitives = new Hashtable();

    d_BCValidate() {
    }

    static void checkMethod(short opcode, Type dt, String methodName, String[] debugParameterTypes, Type rt) {
        String reason = null;
        try {
            String actualReturnType;
            int p;
            String declaringClass = dt.javaName();
            if (declaringClass.startsWith("org.apache.derby.exe.")) {
                return;
            }
            for (p = 0; p < csPackages.length && !declaringClass.startsWith(csPackages[p]); ++p) {
            }
            if (p == csPackages.length) {
                return;
            }
            Class[] params = NO_PARAMS;
            Class declaring = d_BCValidate.loadClass(declaringClass);
            if (debugParameterTypes != null) {
                params = new Class[debugParameterTypes.length];
                for (int i = 0; i < debugParameterTypes.length; ++i) {
                    params[i] = d_BCValidate.loadClass(debugParameterTypes[i]);
                }
            }
            ClassLoader declareLoader = declaring.getClassLoader();
            ClassLoader myLoader = d_BCValidate.class.getClassLoader();
            boolean sameClassLoader = false;
            if (declareLoader == myLoader) {
                sameClassLoader = true;
            } else if (declareLoader != null) {
                sameClassLoader = declareLoader.equals(myLoader);
            }
            if (methodName.equals("<init>")) {
                Constructor c;
                if (sameClassLoader) {
                    c = declaring.getDeclaredConstructor(params);
                } else {
                    c = declaring.getConstructor(params);
                    if (!c.getDeclaringClass().equals(declaring)) {
                        reason = "constructor " + c.toString() + " declared on " + c.getDeclaringClass() + " expected " + declaring;
                    }
                }
                actualReturnType = "void";
            } else {
                Method m;
                if (sameClassLoader) {
                    m = declaring.getDeclaredMethod(methodName, params);
                } else {
                    m = declaring.getMethod(methodName, params);
                    if (!m.getDeclaringClass().equals(declaring)) {
                        reason = "method " + m.toString() + " declared on " + m.getDeclaringClass() + " expected " + declaring;
                    }
                }
                actualReturnType = m.getReturnType().getName();
            }
            if (reason == null) {
                Class requestedReturnType = d_BCValidate.loadClass(rt.javaName());
                if (actualReturnType.equals(requestedReturnType.getName())) {
                    if (opcode != 185) {
                        return;
                    }
                    if (declaring.isInterface()) {
                        return;
                    }
                    reason = "declaring class is not an interface";
                } else {
                    reason = "return type is " + actualReturnType;
                }
            }
        }
        catch (Exception e) {
            reason = e.toString();
            e.printStackTrace(System.out);
        }
        String sig = dt.javaName() + " >> " + rt.javaName() + " " + methodName + "(";
        if (debugParameterTypes != null) {
            for (int i = 0; i < debugParameterTypes.length; ++i) {
                if (i != 0) {
                    sig = sig + ", ";
                }
                sig = sig + debugParameterTypes[i];
            }
        }
        sig = sig + ")";
        String msg = "Invalid method " + sig + " because " + reason;
        System.out.println(msg);
        SanityManager.THROWASSERT(msg);
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        Class c = (Class)primitives.get(name);
        if (c != null) {
            return c;
        }
        if (name.endsWith("[]")) {
            Class baseClass = d_BCValidate.loadClass(name.substring(0, name.length() - 2));
            return Array.newInstance(baseClass, 0).getClass();
        }
        return Class.forName(name);
    }

    static {
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("void", Void.TYPE);
    }
}

