/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.RoutinePermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TablePermsDescriptor;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;

class PermissionsCacheable
implements Cacheable {
    protected final DataDictionaryImpl dd;
    private PermissionsDescriptor permissions;

    PermissionsCacheable(DataDictionaryImpl dd) {
        this.dd = dd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cacheable setIdentity(Object key) throws StandardException {
        block13: {
            if (key instanceof TablePermsDescriptor) {
                TablePermsDescriptor tablePermsKey = (TablePermsDescriptor)key;
                this.permissions = this.dd.getUncachedTablePermsDescriptor(tablePermsKey);
                if (this.permissions == null) {
                    TableDescriptor td = this.dd.getTableDescriptor(tablePermsKey.getTableUUID());
                    SchemaDescriptor sd = td.getSchemaDescriptor();
                    this.permissions = sd.isSystemSchema() ? new TablePermsDescriptor(this.dd, tablePermsKey.getGrantee(), null, tablePermsKey.getTableUUID(), "Y", "N", "N", "N", "N", "N") : (tablePermsKey.getGrantee().equals(sd.getAuthorizationId()) ? new TablePermsDescriptor(this.dd, tablePermsKey.getGrantee(), "_SYSTEM", tablePermsKey.getTableUUID(), "Y", "Y", "Y", "Y", "Y", "Y") : new TablePermsDescriptor(this.dd, tablePermsKey.getGrantee(), null, tablePermsKey.getTableUUID(), "N", "N", "N", "N", "N", "N"));
                }
            } else if (key instanceof ColPermsDescriptor) {
                ColPermsDescriptor colPermsKey = (ColPermsDescriptor)key;
                this.permissions = this.dd.getUncachedColPermsDescriptor(colPermsKey);
                if (this.permissions == null) {
                    this.permissions = new ColPermsDescriptor(this.dd, colPermsKey.getGrantee(), null, colPermsKey.getTableUUID(), colPermsKey.getType(), null);
                }
            } else {
                if (!(key instanceof RoutinePermsDescriptor)) {
                    SanityManager.NOTREACHED();
                    return null;
                }
                RoutinePermsDescriptor routinePermsKey = (RoutinePermsDescriptor)key;
                this.permissions = this.dd.getUncachedRoutinePermsDescriptor(routinePermsKey);
                if (this.permissions == null) {
                    try {
                        AliasDescriptor ad = this.dd.getAliasDescriptor(routinePermsKey.getRoutineUUID());
                        SchemaDescriptor sd = this.dd.getSchemaDescriptor(ad.getSchemaUUID(), ConnectionUtil.getCurrentLCC().getTransactionExecute());
                        if (sd.isSystemSchema() && !sd.isSchemaWithGrantableRoutines()) {
                            this.permissions = new RoutinePermsDescriptor(this.dd, routinePermsKey.getGrantee(), null, routinePermsKey.getRoutineUUID(), true);
                            break block13;
                        }
                        if (routinePermsKey.getGrantee().equals(sd.getAuthorizationId())) {
                            this.permissions = new RoutinePermsDescriptor(this.dd, routinePermsKey.getGrantee(), "_SYSTEM", routinePermsKey.getRoutineUUID(), true);
                        }
                    }
                    catch (SQLException sqle) {
                        throw StandardException.plainWrapException(sqle);
                    }
                }
            }
        }
        if (this.permissions != null) {
            return this;
        }
        return null;
    }

    public Cacheable createIdentity(Object key, Object createParameter) throws StandardException {
        SanityManager.ASSERT(key instanceof TablePermsDescriptor || key instanceof ColPermsDescriptor || key instanceof RoutinePermsDescriptor, "Invalid class, " + key.getClass().getName() + ", passed as key to PermissionsCacheable.createIdentity");
        if (key == null) {
            return null;
        }
        this.permissions = (PermissionsDescriptor)((PermissionsDescriptor)key).clone();
        return this;
    }

    public void clearIdentity() {
        this.permissions = null;
    }

    public Object getIdentity() {
        return this.permissions;
    }

    public boolean isDirty() {
        return false;
    }

    public void clean(boolean forRemove) throws StandardException {
    }
}

