/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class BinaryArithmeticOperatorNode
extends BinaryOperatorNode {
    public void init(Object leftOperand, Object rightOperand) {
        super.init(leftOperand, rightOperand, "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.NumberDataValue");
    }

    public void setNodeType(int nodeType) {
        String operator = null;
        String methodName = null;
        switch (nodeType) {
            case 40: {
                operator = "/";
                methodName = "divide";
                break;
            }
            case 46: {
                operator = "-";
                methodName = "minus";
                break;
            }
            case 48: {
                operator = "+";
                methodName = "plus";
                break;
            }
            case 49: {
                operator = "*";
                methodName = "times";
                break;
            }
            case 194: {
                operator = "mod";
                methodName = "mod";
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected nodeType = " + nodeType);
            }
        }
        this.setOperator(operator);
        this.setMethodName(methodName);
        super.setNodeType(nodeType);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregateVector);
        TypeId leftType = this.leftOperand.getTypeId();
        TypeId rightType = this.rightOperand.getTypeId();
        DataTypeDescriptor leftDTS = this.leftOperand.getTypeServices();
        DataTypeDescriptor rightDTS = this.rightOperand.getTypeServices();
        if (leftType.isStringTypeId() && rightType.isNumericTypeId()) {
            boolean nullableResult = leftDTS.isNullable() || rightDTS.isNullable();
            int precision = rightDTS.getPrecision();
            int scale = rightDTS.getScale();
            int maxWidth = rightDTS.getMaximumWidth();
            if (rightType.isDecimalTypeId()) {
                int charMaxWidth = leftDTS.getMaximumWidth();
                scale += charMaxWidth;
                maxWidth = (precision += 2 * charMaxWidth) + 3;
            }
            this.leftOperand = (ValueNode)this.getNodeFactory().getNode(60, this.leftOperand, new DataTypeDescriptor(rightType, precision, scale, nullableResult, maxWidth), this.getContextManager());
            ((CastNode)this.leftOperand).bindCastNodeOnly();
        } else if (rightType.isStringTypeId() && leftType.isNumericTypeId()) {
            boolean nullableResult = leftDTS.isNullable() || rightDTS.isNullable();
            int precision = leftDTS.getPrecision();
            int scale = leftDTS.getScale();
            int maxWidth = leftDTS.getMaximumWidth();
            if (leftType.isDecimalTypeId()) {
                int charMaxWidth = rightDTS.getMaximumWidth();
                scale += charMaxWidth;
                maxWidth = (precision += 2 * charMaxWidth) + 3;
            }
            this.rightOperand = (ValueNode)this.getNodeFactory().getNode(60, this.rightOperand, new DataTypeDescriptor(leftType, precision, scale, nullableResult, maxWidth), this.getContextManager());
            ((CastNode)this.rightOperand).bindCastNodeOnly();
        }
        this.setType(this.leftOperand.getTypeCompiler().resolveArithmeticOperation(this.leftOperand.getTypeServices(), this.rightOperand.getTypeServices(), this.operator));
        return this;
    }
}

