/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.CursorActivation;
import org.apache.derby.iapi.sql.execute.ExecCursorTableReference;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.TableName;

public final class CurrentOfNode
extends FromTable {
    private String cursorName;
    private ExecPreparedStatement preStmt;
    private TableName exposedTableName;
    private TableName baseTableName;
    private CostEstimate singleScanCostEstimate;

    public void init(Object correlationName, Object cursor, Object tableProperties) {
        super.init(correlationName, tableProperties);
        this.cursorName = (String)cursor;
    }

    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        if (this.singleScanCostEstimate == null) {
            this.singleScanCostEstimate = optimizer.newCostEstimate();
        }
        this.singleScanCostEstimate.setCost(0.0, 1.0, 1.0);
        this.getBestAccessPath().setCostEstimate(this.singleScanCostEstimate);
        this.getBestSortAvoidancePath().setCostEstimate(this.singleScanCostEstimate);
        return this.singleScanCostEstimate;
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        this.preStmt = this.getCursorStatement();
        if (this.preStmt == null) {
            throw StandardException.newException("42X30", this.cursorName);
        }
        this.preStmt.rePrepare(this.getLanguageConnectionContext());
        if (this.preStmt.getUpdateMode() != 2) {
            String printableString = this.cursorName == null ? "" : this.cursorName;
            throw StandardException.newException("42X23", printableString);
        }
        ExecCursorTableReference refTab = this.preStmt.getTargetTable();
        String schemaName = refTab.getSchemaName();
        this.exposedTableName = this.makeTableName(null, refTab.getExposedName());
        this.baseTableName = this.makeTableName(schemaName, refTab.getBaseName());
        SchemaDescriptor tableSchema = null;
        tableSchema = this.getSchemaDescriptor(refTab.getSchemaName());
        if (tableSchema == null) {
            throw StandardException.newException("42Y07", refTab.getSchemaName());
        }
        TableDescriptor td = this.getTableDescriptor(refTab.getBaseName(), tableSchema);
        if (td == null) {
            throw StandardException.newException("42X05", refTab.getBaseName());
        }
        this.resultColumns = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor colDesc = cdl.elementAt(index);
            BaseColumnNode bcn = (BaseColumnNode)this.getNodeFactory().getNode(94, colDesc.getColumnName(), this.exposedTableName, colDesc.getType(), this.getContextManager());
            ResultColumn rc = (ResultColumn)this.getNodeFactory().getNode(80, colDesc, bcn, this.getContextManager());
            this.resultColumns.addResultColumn(rc);
        }
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    public void bindExpressions(FromList fromListParam) {
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        ResultColumn resultColumn = null;
        TableName columnsTableName = columnReference.getTableNameNode();
        if (columnsTableName != null && columnsTableName.getSchemaName() == null && this.correlationName == null) {
            columnsTableName.bind(this.getDataDictionary());
        }
        SanityManager.ASSERT(this.preStmt != null, "must have prepared statement");
        SanityManager.ASSERT(this.baseTableName != null, "no name on target table");
        if (this.baseTableName != null && this.baseTableName.getSchemaName() == null && this.correlationName == null) {
            this.baseTableName.bind(this.getDataDictionary());
        }
        if (columnsTableName == null || columnsTableName.getFullTableName().equals(this.baseTableName.getFullTableName()) || this.correlationName != null && this.correlationName.equals(columnsTableName.getTableName())) {
            boolean notfound = false;
            resultColumn = this.resultColumns.getResultColumn(columnReference.getColumnName());
            if (resultColumn != null) {
                columnReference.setTableNumber(this.tableNumber);
                notfound = resultColumn.updatableByCursor() && !this.foundString(this.preStmt.getUpdateColumns(), columnReference.getColumnName());
            } else {
                notfound = true;
            }
            if (notfound) {
                String printableString = this.cursorName == null ? "" : this.cursorName;
                throw StandardException.newException("42X31", (Object)columnReference.getColumnName(), (Object)printableString);
            }
        }
        return resultColumn;
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.referencedTableMap = new JBitSet(numTables);
        return this;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double outerRows) throws StandardException {
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this, this.getContextManager()), predicateList, dataDictionary, null);
        this.bestCostEstimate = optimizer.newCostEstimate();
        this.bestCostEstimate.setCost(0.0, outerRows, outerRows);
        return this;
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(!this.statementResultSet, "CurrentOfNode not expected to be statement node");
        this.assignResultSetNumber();
        mb.pushThis();
        acb.pushGetResultSetFactoryExpression(mb);
        mb.push(this.cursorName);
        acb.pushThisAsActivation(mb);
        mb.push(this.resultSetNumber);
        mb.callMethod((short)185, null, "getCurrentOfResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 3);
        mb.cast("org.apache.derby.iapi.sql.execute.CursorResultSet");
        mb.putField(null, acb.getRowLocationScanResultSetName(), "org.apache.derby.iapi.sql.execute.CursorResultSet");
        mb.cast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        MethodBuilder rmb = acb.startResetMethod();
        rmb.pushThis();
        rmb.push(this.cursorName);
        rmb.push(this.preStmt.getObjectName());
        rmb.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "checkPositionedStatement", "void", 2);
        rmb.methodReturn();
        rmb.complete();
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "cursor: ");
    }

    public String toString() {
        return "preparedStatement: " + (this.preStmt == null ? "no prepared statement yet\n" : this.preStmt.toString() + "\n") + this.cursorName + "\n" + super.toString();
    }

    public String getExposedName() {
        return this.exposedTableName.getFullTableName();
    }

    public TableName getExposedTableName() {
        return this.exposedTableName;
    }

    public TableName getBaseCursorTargetTableName() {
        return this.baseTableName;
    }

    public String getCursorName() {
        return this.cursorName;
    }

    ExecPreparedStatement getCursorStatement() {
        CursorActivation activation = this.getLanguageConnectionContext().lookupCursorActivation(this.cursorName);
        if (activation == null) {
            return null;
        }
        return activation.getPreparedStatement();
    }

    public int updateTargetLockMode() {
        return 6;
    }
}

