/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class DB2LengthOperatorNode
extends UnaryOperatorNode {
    public void init(Object operand) {
        super.init(operand, "length", "getDB2Length");
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregateVector);
        TypeId operandType = this.operand.getTypeId();
        if (operandType.isXMLTypeId()) {
            throw StandardException.newException("42X25", (Object)this.getOperatorString(), (Object)operandType.getSQLTypeName());
        }
        this.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(4), this.operand.getTypeServices().isNullable()));
        return this;
    }

    public String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.ConcatableDataValue";
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.operand == null) {
            return;
        }
        int constantLength = this.getConstantLength();
        String resultTypeName = this.getTypeCompiler().interfaceName();
        mb.pushThis();
        this.operand.generateExpression(acb, mb);
        mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        mb.push(constantLength);
        LocalField field = acb.newFieldDeclaration(2, resultTypeName);
        mb.getField(field);
        mb.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", this.methodName, resultTypeName, 3);
        mb.putField(field);
    }

    private int getConstantLength() throws StandardException {
        DataTypeDescriptor typeDescriptor = this.operand.getTypeServices();
        switch (typeDescriptor.getJDBCTypeId()) {
            case -5: {
                return 8;
            }
            case -7: 
            case 16: {
                return 1;
            }
            case -2: 
            case 1: {
                return typeDescriptor.getMaximumWidth();
            }
            case 91: {
                return 4;
            }
            case 2: 
            case 3: {
                return typeDescriptor.getPrecision() / 2 + 1;
            }
            case 8: {
                return 8;
            }
            case 4: 
            case 6: 
            case 7: {
                return 4;
            }
            case 5: {
                return 2;
            }
            case 92: {
                return 3;
            }
            case 93: {
                return 10;
            }
            case -6: {
                return 1;
            }
            case -4: 
            case -3: 
            case -1: 
            case 12: 
            case 2004: {
                return this.getConstantNodeLength();
            }
        }
        return -1;
    }

    private int getConstantNodeLength() throws StandardException {
        if (this.operand instanceof ConstantNode) {
            return ((ConstantNode)this.operand).getValue().getLength();
        }
        return -1;
    }
}

