/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.compile.BaseJoinStrategy;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;

public class NestedLoopJoinStrategy
extends BaseJoinStrategy {
    public boolean feasible(Optimizable innerTable, OptimizablePredicateList predList, Optimizer optimizer) throws StandardException {
        if (innerTable.isMaterializable()) {
            return true;
        }
        return innerTable.supportsMultipleInstantiations();
    }

    public boolean multiplyBaseCostByOuterRows() {
        return true;
    }

    public OptimizablePredicateList getBasePredicates(OptimizablePredicateList predList, OptimizablePredicateList basePredicates, Optimizable innerTable) throws StandardException {
        SanityManager.ASSERT(basePredicates == null || basePredicates.size() == 0, "The base predicate list should be empty.");
        if (predList != null) {
            predList.transferAllPredicates(basePredicates);
            basePredicates.classify(innerTable, innerTable.getCurrentAccessPath().getConglomerateDescriptor());
        }
        return basePredicates;
    }

    public double nonBasePredicateSelectivity(Optimizable innerTable, OptimizablePredicateList predList) {
        return 1.0;
    }

    public void putBasePredicates(OptimizablePredicateList predList, OptimizablePredicateList basePredicates) throws StandardException {
        for (int i = basePredicates.size() - 1; i >= 0; --i) {
            OptimizablePredicate pred = basePredicates.getOptPredicate(i);
            predList.addOptPredicate(pred);
            basePredicates.removeOptPredicate(i);
        }
    }

    public void estimateCost(Optimizable innerTable, OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, CostEstimate costEstimate) {
        costEstimate.multiply(outerCost.rowCount(), costEstimate);
        optimizer.trace(23, innerTable.getTableNumber(), 0, outerCost.rowCount(), costEstimate);
    }

    public int maxCapacity(int userSpecifiedCapacity, int maxMemoryPerTable, double perRowUsage) {
        return Integer.MAX_VALUE;
    }

    public String getName() {
        return "NESTEDLOOP";
    }

    public int scanCostType() {
        return 2;
    }

    public String resultSetMethodName(boolean bulkFetch, boolean multiprobe) {
        if (bulkFetch) {
            return "getBulkTableScanResultSet";
        }
        if (multiprobe) {
            return "getMultiProbeTableScanResultSet";
        }
        return "getTableScanResultSet";
    }

    public String joinResultSetMethodName() {
        return "getNestedLoopJoinResultSet";
    }

    public String halfOuterJoinResultSetMethodName() {
        return "getNestedLoopLeftOuterJoinResultSet";
    }

    public int getScanArgs(TransactionController tc, MethodBuilder mb, Optimizable innerTable, OptimizablePredicateList storeRestrictionList, OptimizablePredicateList nonStoreRestrictionList, ExpressionClassBuilderInterface acbi, int bulkFetch, MethodBuilder resultRowAllocator, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int maxMemoryPerTable, boolean genInListVals) throws StandardException {
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        if (nonStoreRestrictionList.size() != 0) {
            SanityManager.THROWASSERT("nonStoreRestrictionList should be empty for nested loop join strategy, but it contains " + nonStoreRestrictionList.size() + " elements");
        }
        int numArgs = genInListVals ? 26 : (bulkFetch > 1 ? 25 : 24);
        this.fillInScanArgs1(tc, mb, innerTable, storeRestrictionList, acb, resultRowAllocator);
        if (genInListVals) {
            ((PredicateList)storeRestrictionList).generateInListValues(acb, mb);
        }
        if (!genInListVals) {
            Predicate pred = null;
            for (int i = storeRestrictionList.size() - 1; i >= 0; --i) {
                pred = (Predicate)storeRestrictionList.getOptPredicate(i);
                if (!pred.isInListProbePredicate()) continue;
                SanityManager.THROWASSERT("Found IN-list probing predicate (" + pred.binaryRelOpColRefsToString() + ") when no such predicates were expected.");
            }
        }
        this.fillInScanArgs2(mb, innerTable, bulkFetch, colRefItem, indexColItem, lockMode, tableLocked, isolationLevel);
        return numArgs;
    }

    public void divideUpPredicateLists(Optimizable innerTable, OptimizablePredicateList originalRestrictionList, OptimizablePredicateList storeRestrictionList, OptimizablePredicateList nonStoreRestrictionList, OptimizablePredicateList requalificationRestrictionList, DataDictionary dd) throws StandardException {
        originalRestrictionList.setPredicatesAndProperties(storeRestrictionList);
    }

    public boolean doesMaterialization() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    protected boolean validForOutermostTable() {
        return true;
    }
}

