/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ResultColumnList;

public class ReplaceAggregatesWithCRVisitor
implements Visitor {
    private ResultColumnList rcl;
    private Class skipOverClass;
    private int tableNumber;

    public ReplaceAggregatesWithCRVisitor(ResultColumnList rcl, int tableNumber) {
        this(rcl, tableNumber, null);
    }

    public ReplaceAggregatesWithCRVisitor(ResultColumnList rcl, int tableNumber, Class skipOverClass) {
        this.rcl = rcl;
        this.tableNumber = tableNumber;
        this.skipOverClass = skipOverClass;
    }

    public ReplaceAggregatesWithCRVisitor(ResultColumnList rcl, Class nodeToSkip) {
        this.rcl = rcl;
        this.skipOverClass = nodeToSkip;
    }

    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof AggregateNode) {
            node = ((AggregateNode)node).replaceAggregatesWithColumnReferences(this.rcl, this.tableNumber);
        }
        return node;
    }

    public boolean skipChildren(Visitable node) {
        return this.skipOverClass == null ? false : this.skipOverClass.isInstance(node);
    }

    public boolean stopTraversal() {
        return false;
    }
}

