/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasVariantValueNodeVisitor;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;

public class RowResultSetNode
extends FromTable {
    SubqueryList subquerys;
    Vector aggregateVector;
    OrderByList orderByList;

    public void init(Object valuesClause, Object tableProperties) {
        super.init(null, tableProperties);
        this.resultColumns = (ResultColumnList)valuesClause;
        if (this.resultColumns != null) {
            this.resultColumns.markInitialSize();
        }
    }

    public String toString() {
        return "orderByList: " + (this.orderByList != null ? this.orderByList.toString() : "null") + "\n" + super.toString();
    }

    public String statementToString() {
        return "VALUES";
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.subquerys != null) {
            this.printLabel(depth, "subquerys: ");
            this.subquerys.treePrint(depth + 1);
        }
    }

    public CostEstimate estimateCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizer optimizer, RowOrdering rowOrdering) throws StandardException {
        if (this.costEstimate == null) {
            this.costEstimate = optimizer.newCostEstimate();
        }
        this.costEstimate.setCost(0.0, 1.0, 1.0);
        rowOrdering.optimizableAlwaysOrdered(this);
        return this.costEstimate;
    }

    public ResultSetNode bindNonVTITables(DataDictionary dataDictionary, FromList fromListParam) throws StandardException {
        if (this.tableNumber == -1) {
            this.tableNumber = this.getCompilerContext().getNextTableNumber();
        }
        return this;
    }

    public void bindExpressions(FromList fromListParam) throws StandardException {
        this.subquerys = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        this.aggregateVector = new Vector();
        this.resultColumns.checkForInvalidDefaults();
        int nestingLevel = fromListParam.size() == 0 ? 0 : ((FromTable)fromListParam.elementAt(0)).getLevel() + 1;
        this.setLevel(nestingLevel);
        fromListParam.insertElementAt(this, 0);
        this.resultColumns.bindExpressions(fromListParam, this.subquerys, this.aggregateVector);
        fromListParam.removeElementAt(0);
        if (this.aggregateVector.size() > 0) {
            throw StandardException.newException("42903");
        }
    }

    public void bindExpressionsWithTables(FromList fromListParam) throws StandardException {
    }

    public void bindTargetExpressions(FromList fromListParam) throws StandardException {
        this.bindExpressions(fromListParam);
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        if (bindingRCL == null) {
            bindingRCL = this.resultColumns;
        }
        this.resultColumns.bindUntypedNullsToResultColumns(bindingRCL);
    }

    public ResultColumn getMatchingColumn(ColumnReference columnReference) throws StandardException {
        return null;
    }

    public String getExposedName() throws StandardException {
        return null;
    }

    public void verifySelectStarSubquery(FromList outerFromList, int subqueryType) throws StandardException {
    }

    void pushOrderByList(OrderByList orderByList) {
        this.orderByList = orderByList;
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        if (this.subquerys.size() > 0) {
            this.subquerys.preprocess(numTables, (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager()), (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager()));
        }
        this.referencedTableMap = new JBitSet(numTables);
        this.referencedTableMap.set(this.tableNumber);
        return this;
    }

    public ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this.genProjectRestrict(numTables);
    }

    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        ResultColumnList prRCList = this.resultColumns;
        this.resultColumns = this.resultColumns.copyListAndObjects();
        prRCList.genVirtualColumnNodes(this, this.resultColumns);
        PredicateList predList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        predList.addPredicate(predicate);
        return (ResultSetNode)this.getNodeFactory().getNode(151, this, prRCList, null, predList, null, null, this.tableProperties, this.getContextManager());
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        if (this.subquerys != null && this.subquerys.size() > 0) {
            return false;
        }
        if (this.aggregateVector != null && this.aggregateVector.size() > 0) {
            return false;
        }
        if (!this.resultColumns.isCloneable()) {
            return false;
        }
        boolean nonRowResultSetFound = false;
        int flSize = fromList.size();
        for (int index = 0; index < flSize; ++index) {
            FromTable ft = (FromTable)fromList.elementAt(index);
            if (ft instanceof FromSubquery) {
                ResultSetNode subq = ((FromSubquery)ft).getSubquery();
                if (subq instanceof RowResultSetNode) continue;
                nonRowResultSetFound = true;
                break;
            }
            nonRowResultSetFound = true;
            break;
        }
        return nonRowResultSetFound;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicateList, double outerRows) throws StandardException {
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), predicateList, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(0.0, outerRows, outerRows);
        this.subquerys.optimize(dataDictionary, outerRows);
        return this;
    }

    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        return (Optimizable)((Object)this.modifyAccessPaths());
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode treeTop = this;
        this.subquerys.modifyAccessPaths();
        if (this.orderByList != null) {
            treeTop = (ResultSetNode)this.getNodeFactory().getNode(140, treeTop, this.orderByList, this.tableProperties, this.getContextManager());
        }
        return treeTop;
    }

    boolean returnsAtMostOneRow() {
        return true;
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.resultColumns != null, "Tree structure bad");
        this.costEstimate = this.getFinalCostEstimate();
        boolean canCache = this.canWeCacheResults();
        this.assignResultSetNumber();
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        this.resultColumns.generate(acb, mb);
        mb.push(canCache);
        mb.push(this.resultSetNumber);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getRowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    void replaceDefaults(TableDescriptor ttd, ResultColumnList tcl) throws StandardException {
        this.resultColumns.replaceDefaults(ttd, tcl);
    }

    void optimizeSubqueries(DataDictionary dd, double rowCount) throws StandardException {
        this.subquerys.optimize(dd, rowCount);
    }

    void adjustForSortElimination() {
    }

    private boolean canWeCacheResults() throws StandardException {
        HasVariantValueNodeVisitor visitor = new HasVariantValueNodeVisitor(2, true);
        super.accept(visitor);
        boolean canCache = !visitor.hasVariant();
        return canCache;
    }
}

