/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class VirtualColumnNode
extends ValueNode {
    private ResultSetNode sourceResultSet;
    private ResultColumn sourceColumn;
    int columnId;
    private boolean correlated = false;

    public void init(Object sourceResultSet, Object sourceColumn, Object columnId) throws StandardException {
        ResultColumn source = (ResultColumn)sourceColumn;
        this.sourceResultSet = (ResultSetNode)sourceResultSet;
        this.sourceColumn = source;
        this.columnId = (Integer)columnId;
        this.setType(source.getTypeServices());
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        this.printLabel(depth, "sourceColumn: ");
        this.sourceColumn.treePrint(depth + 1);
    }

    public ResultSetNode getSourceResultSet() {
        return this.sourceResultSet;
    }

    public ResultColumn getSourceColumn() {
        return this.sourceColumn;
    }

    public String getTableName() {
        return this.sourceColumn.getTableName();
    }

    public String getSchemaName() throws StandardException {
        return this.sourceColumn.getSchemaName();
    }

    public boolean updatableByCursor() {
        return this.sourceColumn.updatableByCursor();
    }

    public ResultColumn getSourceResultColumn() {
        return this.sourceColumn;
    }

    void setCorrelated() {
        this.correlated = true;
    }

    boolean getCorrelated() {
        return this.correlated;
    }

    public boolean isCloneable() {
        return true;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int sourceResultSetNumber = this.sourceColumn.getResultSetNumber();
        if (this.sourceColumn.isRedundant()) {
            this.sourceColumn.getExpression().generateExpression(acb, mb);
            return;
        }
        SanityManager.ASSERT(sourceResultSetNumber >= 0, "sourceResultSetNumber expected to be >= 0 for virtual column " + this.sourceColumn.getName());
        acb.pushColumnReference(mb, sourceResultSetNumber, this.sourceColumn.getVirtualColumnId());
        mb.cast(this.sourceColumn.getTypeCompiler().interfaceName());
    }

    protected int getOrderableVariantType() throws StandardException {
        return this.sourceColumn.getOrderableVariantType();
    }

    public DataTypeDescriptor getTypeServices() {
        return this.sourceColumn.getTypeServices();
    }

    public void setType(DataTypeDescriptor dtd) throws StandardException {
        this.sourceColumn.setType(dtd);
    }

    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            VirtualColumnNode other = (VirtualColumnNode)o;
            return this.sourceColumn.isEquivalent(other.sourceColumn);
        }
        return false;
    }
}

