/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.GenericAggregator;

public class AggregateSortObserver
extends BasicSortObserver {
    protected GenericAggregator[] aggsToProcess;
    protected GenericAggregator[] aggsToInitialize;
    private int firstAggregatorColumn;

    public AggregateSortObserver(boolean doClone, GenericAggregator[] aggsToProcess, GenericAggregator[] aggsToInitialize, ExecRow execRow) {
        super(doClone, false, execRow, true);
        this.aggsToProcess = aggsToProcess;
        this.aggsToInitialize = aggsToInitialize;
        SanityManager.ASSERT(aggsToInitialize != null, "aggsToInitialize argument to AggregateSortObserver is null");
        SanityManager.ASSERT(aggsToProcess != null, "aggsToProcess argument to AggregateSortObserver is null");
        if (aggsToInitialize.length > 0) {
            this.firstAggregatorColumn = aggsToInitialize[0].aggregatorColumnId;
        }
    }

    public DataValueDescriptor[] insertNonDuplicateKey(DataValueDescriptor[] insertRow) throws StandardException {
        Object[] returnRow = super.insertNonDuplicateKey(insertRow);
        if (this.aggsToInitialize.length > 0 && returnRow[this.firstAggregatorColumn].isNull()) {
            for (int i = 0; i < this.aggsToInitialize.length; ++i) {
                GenericAggregator aggregator = this.aggsToInitialize[i];
                UserDataValue wrapper = (UserDataValue)returnRow[aggregator.aggregatorColumnId];
                if (!wrapper.isNull()) {
                    SanityManager.THROWASSERT("during aggregate initialization, all wrappers expected to be empty; however, the wrapper for the following aggregate was not empty:" + aggregator + ".  The value stored is " + wrapper.getObject());
                }
                wrapper.setValue(aggregator.getAggregatorInstance());
                aggregator.accumulate(returnRow, returnRow);
            }
        }
        return returnRow;
    }

    public DataValueDescriptor[] insertDuplicateKey(DataValueDescriptor[] insertRow, DataValueDescriptor[] existingRow) throws StandardException {
        if (this.aggsToProcess.length == 0) {
            return null;
        }
        for (int i = 0; i < this.aggsToProcess.length; ++i) {
            GenericAggregator aggregator = this.aggsToProcess[i];
            if (insertRow[aggregator.getColumnId()].isNull()) {
                aggregator.accumulate(insertRow, existingRow);
                continue;
            }
            aggregator.merge(insertRow, existingRow);
        }
        return null;
    }
}

