/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.RoleClosureIterator;
import org.apache.derby.iapi.sql.dictionary.RoleGrantDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class RevokeRoleConstantAction
extends DDLConstantAction {
    private List roleNames;
    private List grantees;
    private final boolean withAdminOption = false;

    public RevokeRoleConstantAction(List roleNames, List grantees) {
        this.roleNames = roleNames;
        this.grantees = grantees;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        String grantor = lcc.getAuthorizationId();
        dd.startWriting(lcc);
        Iterator rIter = this.roleNames.iterator();
        while (rIter.hasNext()) {
            String role = (String)rIter.next();
            if (role.equals("PUBLIC")) {
                throw StandardException.newException("4251B");
            }
            Iterator gIter = this.grantees.iterator();
            while (gIter.hasNext()) {
                String grantee = (String)gIter.next();
                RoleGrantDescriptor rdDef = dd.getRoleDefinitionDescriptor(role);
                if (rdDef == null) {
                    throw StandardException.newException("0P000", role);
                }
                if (!grantor.equals(lcc.getDataDictionary().getAuthorizationDatabaseOwner())) {
                    throw StandardException.newException("4251A", "REVOKE role");
                }
                SanityManager.ASSERT(rdDef.getGrantee().equals(grantor), "expected database owner in role grant descriptor");
                SanityManager.ASSERT(rdDef.isWithAdminOption(), "expected role definition to have ADMIN OPTION");
                RoleGrantDescriptor rd = dd.getRoleGrantDescriptor(role, grantee, grantor);
                if (rd != null) {
                    // empty if block
                }
                if (rd != null) {
                    String r;
                    RoleClosureIterator rci = dd.createRoleClosureIterator(activation.getTransactionController(), role, false);
                    while ((r = rci.next()) != null) {
                        rdDef = dd.getRoleDefinitionDescriptor(r);
                        dd.getDependencyManager().invalidateFor(rdDef, 47, lcc);
                    }
                    rd.drop(lcc);
                    continue;
                }
                activation.addWarning(StandardException.newWarning("01007", role, grantee));
            }
        }
    }

    public String toString() {
        StringBuffer sb1 = new StringBuffer();
        Iterator it = this.roleNames.iterator();
        while (it.hasNext()) {
            if (sb1.length() > 0) {
                sb1.append(", ");
            }
            sb1.append(it.next().toString());
        }
        StringBuffer sb2 = new StringBuffer();
        Iterator it2 = this.grantees.iterator();
        while (it2.hasNext()) {
            if (sb2.length() > 0) {
                sb2.append(", ");
            }
            sb2.append(it2.next().toString());
        }
        return "REVOKE " + sb1.toString() + " FROM: " + sb2.toString() + "\n";
    }
}

