/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherFactoryBuilder;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.monitor.PersistentService;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.DatabaseInstant;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.ScanHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionFactory;
import org.apache.derby.iapi.store.replication.master.MasterFactory;
import org.apache.derby.iapi.store.replication.slave.SlaveFactory;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.services.monitor.UpdateServiceProperties;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.WritableStorageFactory;

public final class RawStore
implements RawStoreFactory,
ModuleControl,
ModuleSupportable,
PrivilegedExceptionAction {
    private static final String BACKUP_HISTORY = "BACKUP.HISTORY";
    protected TransactionFactory xactFactory;
    protected DataFactory dataFactory;
    protected LogFactory logFactory;
    private SlaveFactory slaveFactory;
    private StorageFactory storageFactory;
    private SecureRandom random;
    private boolean databaseEncrypted;
    private boolean encryptDatabase;
    private CipherProvider encryptionEngine;
    private CipherProvider decryptionEngine;
    private CipherProvider newEncryptionEngine;
    private CipherProvider newDecryptionEngine;
    private CipherFactory currentCipherFactory;
    private CipherFactory newCipherFactory = null;
    private int counter_encrypt;
    private int counter_decrypt;
    private int encryptionBlockSize = 8;
    String dataDirectory;
    protected DaemonService rawStoreDaemon;
    private int actionCode;
    private static final int FILE_WRITER_ACTION = 1;
    private StorageFile actionStorageFile;
    private StorageFile actionToStorageFile;
    private boolean actionAppend;
    private static final int REGULAR_FILE_EXISTS_ACTION = 2;
    private File actionRegularFile;
    private static final int STORAGE_FILE_EXISTS_ACTION = 3;
    private static final int REGULAR_FILE_DELETE_ACTION = 4;
    private static final int REGULAR_FILE_MKDIRS_ACTION = 5;
    private static final int REGULAR_FILE_IS_DIRECTORY_ACTION = 6;
    private static final int REGULAR_FILE_REMOVE_DIRECTORY_ACTION = 7;
    private static final int REGULAR_FILE_RENAME_TO_ACTION = 8;
    private File actionRegularFile2;
    private static final int COPY_STORAGE_DIRECTORY_TO_REGULAR_ACTION = 9;
    private byte[] actionBuffer;
    private String[] actionFilter;
    private boolean actionCopySubDirs;
    private static final int COPY_REGULAR_DIRECTORY_TO_STORAGE_ACTION = 10;
    private static final int COPY_REGULAR_FILE_TO_STORAGE_ACTION = 11;
    private static final int REGULAR_FILE_LIST_DIRECTORY_ACTION = 12;
    private static final int STORAGE_FILE_LIST_DIRECTORY_ACTION = 13;
    private static final int COPY_STORAGE_FILE_TO_REGULAR_ACTION = 14;
    private static final int REGULAR_FILE_GET_CANONICALPATH_ACTION = 15;
    private static final int STORAGE_FILE_GET_CANONICALPATH_ACTION = 16;
    private static final int COPY_STORAGE_FILE_TO_STORAGE_ACTION = 17;
    private static final int STORAGE_FILE_DELETE_ACTION = 18;
    public static final String TEST_REENCRYPT_CRASH_BEFORE_COMMT = "TEST_REENCRYPT_CRASH_BEFORE_COMMT";
    public static final String TEST_REENCRYPT_CRASH_AFTER_COMMT = "TEST_REENCRYPT_CRASH_AFTER_COMMT";
    public static final String TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY = "TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY";
    public static final String TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT = "TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT";
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE = "TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE";
    public static final String TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY = "TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY";
    public static final String TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP = "TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP";

    public boolean canSupport(Properties startParams) {
        return true;
    }

    public void boot(boolean create, Properties properties) throws StandardException {
        String logDevice;
        boolean inReplicationSlaveMode = false;
        String slave = properties.getProperty("replication.slave.mode");
        if (slave != null && slave.equals("slavemode")) {
            inReplicationSlaveMode = true;
        }
        this.dataDirectory = properties.getProperty("derby.__rt.serviceDirectory");
        DaemonFactory daemonFactory = (DaemonFactory)Monitor.startSystemModule("org.apache.derby.iapi.services.daemon.DaemonFactory");
        this.rawStoreDaemon = daemonFactory.createNewDaemon("rawStoreDaemon");
        this.xactFactory = (TransactionFactory)Monitor.bootServiceModule(create, this, this.getTransactionFactoryModule(), properties);
        this.dataFactory = (DataFactory)Monitor.bootServiceModule(create, this, this.getDataFactoryModule(), properties);
        this.storageFactory = this.dataFactory.getStorageFactory();
        String restoreFromBackup = null;
        if (properties != null) {
            restoreFromBackup = properties.getProperty("createFrom");
            if (restoreFromBackup == null) {
                restoreFromBackup = properties.getProperty("restoreFrom");
            }
            if (restoreFromBackup == null) {
                restoreFromBackup = properties.getProperty("rollForwardRecoveryFrom");
            }
        }
        if (create) {
            this.setupEncryptionEngines(create, properties);
        }
        this.dataFactory.setRawStoreFactory(this, create, properties);
        this.xactFactory.setRawStoreFactory(this);
        if (properties instanceof UpdateServiceProperties && this.storageFactory instanceof WritableStorageFactory) {
            ((UpdateServiceProperties)properties).setStorageFactory((WritableStorageFactory)this.storageFactory);
        }
        this.logFactory = (LogFactory)Monitor.findServiceModule(this, this.getLogFactoryModule());
        if (restoreFromBackup != null) {
            this.restoreRemainingFromBackup(restoreFromBackup);
        }
        if ((logDevice = properties.getProperty("logDevice")) != null) {
            if (!(this.isReadOnly() || !create && logDevice.equals(this.logFactory.getCanonicalLogPath()) && restoreFromBackup == null)) {
                properties.put("logDevice", this.logFactory.getCanonicalLogPath());
                properties.put("derby.storage.logDeviceWhenBackedUp", this.logFactory.getCanonicalLogPath());
            }
        } else if (restoreFromBackup != null && this.logFactory.getCanonicalLogPath() != null) {
            properties.put("logDevice", this.logFactory.getCanonicalLogPath());
        } else {
            properties.remove("derby.storage.logDeviceWhenBackedUp");
        }
        if (restoreFromBackup != null) {
            ((UpdateServiceProperties)properties).saveServiceProperties();
        }
        if (!create) {
            if (properties.getProperty("derby.storage.databaseEncryptionStatus") != null) {
                this.handleIncompleteDatabaseEncryption(properties);
            }
            this.setupEncryptionEngines(create, properties);
        }
        if (this.databaseEncrypted) {
            this.logFactory.setDatabaseEncrypted(false);
            this.dataFactory.setDatabaseEncrypted();
        }
        this.logFactory.setRawStoreFactory(this);
        if (inReplicationSlaveMode) {
            this.slaveFactory = (SlaveFactory)Monitor.bootServiceModule(create, this, this.getSlaveFactoryModule(), properties);
            this.slaveFactory.startSlave(this, this.logFactory);
        }
        this.logFactory.recover(this.dataFactory, this.xactFactory);
        if (this.encryptDatabase) {
            this.configureDatabaseForEncryption(properties, this.newCipherFactory);
        }
    }

    public void stop() {
        if (this.databaseEncrypted) {
            SanityManager.DEBUG_PRINT("encryption statistics", "Encryption called " + this.counter_encrypt + " times, " + "decryption called " + this.counter_decrypt + " times");
        }
        if (this.rawStoreDaemon != null) {
            this.rawStoreDaemon.stop();
        }
        if (this.logFactory == null) {
            return;
        }
        try {
            if (this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, false) && this.dataFactory != null) {
                this.dataFactory.removeStubsOK();
            }
        }
        catch (StandardException se) {
            this.markCorrupt(se);
        }
    }

    public boolean isReadOnly() {
        return this.dataFactory.isReadOnly();
    }

    public LockFactory getLockFactory() {
        return this.xactFactory.getLockFactory();
    }

    public TransactionFactory getXactFactory() {
        return this.xactFactory;
    }

    public Object getXAResourceManager() throws StandardException {
        return this.xactFactory.getXAResourceManager();
    }

    public Transaction startGlobalTransaction(ContextManager contextMgr, int format_id, byte[] global_id, byte[] branch_id) throws StandardException {
        return this.xactFactory.startGlobalTransaction(this, contextMgr, format_id, global_id, branch_id);
    }

    public Transaction startTransaction(ContextManager contextMgr, String transName) throws StandardException {
        return this.xactFactory.startTransaction(this, contextMgr, transName);
    }

    public Transaction startNestedReadOnlyUserTransaction(CompatibilitySpace compatibilitySpace, ContextManager contextMgr, String transName) throws StandardException {
        return this.xactFactory.startNestedReadOnlyUserTransaction(this, compatibilitySpace, contextMgr, transName);
    }

    public Transaction startNestedUpdateUserTransaction(ContextManager contextMgr, String transName) throws StandardException {
        return this.xactFactory.startNestedUpdateUserTransaction(this, contextMgr, transName);
    }

    public Transaction findUserTransaction(ContextManager contextMgr, String transName) throws StandardException {
        return this.xactFactory.findUserTransaction(this, contextMgr, transName);
    }

    public Transaction startInternalTransaction(ContextManager contextMgr) throws StandardException {
        return this.xactFactory.startInternalTransaction(this, contextMgr);
    }

    public void checkpoint() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, false);
    }

    public void startReplicationMaster(String dbmaster, String host, int port, String replicationMode) throws StandardException {
        if (this.isReadOnly()) {
            throw StandardException.newException("XRE00");
        }
        RawTransaction t = this.xactFactory.findUserTransaction(this, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
        if (t.isBlockingBackup()) {
            throw StandardException.newException("XRE23");
        }
        Properties replicationProps = new Properties();
        replicationProps.setProperty("derby.__rt.replication.master.mode", replicationMode);
        MasterFactory masterFactory = (MasterFactory)Monitor.bootServiceModule(true, this, this.getMasterFactoryModule(), replicationProps);
        masterFactory.startMaster(this, this.dataFactory, this.logFactory, host, port, dbmaster);
    }

    public void stopReplicationMaster() throws StandardException {
        MasterFactory masterFactory = null;
        if (this.isReadOnly()) {
            throw StandardException.newException("XRE00");
        }
        try {
            masterFactory = (MasterFactory)Monitor.findServiceModule(this, this.getMasterFactoryModule());
        }
        catch (StandardException se) {
            throw StandardException.newException("XRE07");
        }
        masterFactory.stopMaster();
    }

    public void failover(String dbname) throws StandardException {
        MasterFactory masterFactory = null;
        if (this.isReadOnly()) {
            throw StandardException.newException("XRE00");
        }
        try {
            masterFactory = (MasterFactory)Monitor.findServiceModule(this, this.getMasterFactoryModule());
        }
        catch (StandardException se) {
            throw StandardException.newException("XRE07");
        }
        masterFactory.startFailover();
    }

    public void freeze() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.dataFactory.freezePersistentStore();
        this.logFactory.freezePersistentStore();
    }

    public void unfreeze() throws StandardException {
        this.logFactory.unfreezePersistentStore();
        this.dataFactory.unfreezePersistentStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(String backupDir, boolean wait) throws StandardException {
        if (backupDir == null || backupDir.equals("")) {
            throw StandardException.newException("XSRS6.S", (Object)null);
        }
        String backupDirURL = null;
        try {
            URL url = new URL(backupDir);
            backupDirURL = url.getFile();
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (backupDirURL != null) {
            backupDir = backupDirURL;
        }
        RawTransaction t = this.xactFactory.findUserTransaction(this, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
        try {
            if (t.isBlockingBackup()) {
                throw StandardException.newException("XSRSB.S");
            }
            if (!this.xactFactory.blockBackupBlockingOperations(wait)) {
                throw StandardException.newException("XSRSA.S");
            }
            this.backup(t, new File(backupDir));
        }
        finally {
            this.xactFactory.unblockBackupBlockingOperations();
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void backup(Transaction t, File backupDir) throws StandardException {
        File backupVerifyKeyFile;
        if (!this.privExists(backupDir)) {
            if (!this.privMkdirs(backupDir)) {
                throw StandardException.newException("XSRS6.S", backupDir);
            }
        } else {
            if (!this.privIsDirectory(backupDir)) {
                throw StandardException.newException("XSRS1.S", backupDir);
            }
            if (this.privExists(new File(backupDir, "service.properties"))) {
                throw StandardException.newException("XSRSC.S", backupDir);
            }
        }
        boolean error = true;
        boolean renamed = false;
        boolean renameFailed = false;
        File oldbackup = null;
        File backupcopy = null;
        OutputStreamWriter historyFile = null;
        StorageFile dbHistoryFile = null;
        File backupHistoryFile = null;
        LogInstant backupInstant = this.logFactory.getFirstUnflushedInstant();
        StorageFile dbase = this.storageFactory.newStorageFile(null);
        String canonicalDbName = this.storageFactory.getCanonicalName();
        int lastSep = canonicalDbName.lastIndexOf(this.storageFactory.getSeparator());
        String dbname = canonicalDbName.substring(lastSep + 1);
        historyFile = this.privFileWriter(this.storageFactory.newStorageFile(BACKUP_HISTORY), true);
        backupcopy = new File(backupDir, dbname);
        this.logHistory(historyFile, MessageService.getTextMessage("D004", canonicalDbName, this.getFilePath(backupcopy)));
        if (this.privExists(backupcopy)) {
            oldbackup = new File(backupDir, dbname + ".OLD");
            if (this.privExists(oldbackup)) {
                if (this.privIsDirectory(oldbackup)) {
                    this.privRemoveDirectory(oldbackup);
                } else {
                    this.privDelete(oldbackup);
                }
            }
            if (!this.privRenameTo(backupcopy, oldbackup)) {
                renameFailed = true;
                throw StandardException.newException("XSRS4.S", (Object)backupcopy, (Object)oldbackup);
            }
            this.logHistory(historyFile, MessageService.getTextMessage("D005", this.getFilePath(backupcopy), this.getFilePath(oldbackup)));
            renamed = true;
        }
        if (!this.privMkdirs(backupcopy)) {
            throw StandardException.newException("XSRS6.S", backupcopy);
        }
        dbHistoryFile = this.storageFactory.newStorageFile(BACKUP_HISTORY);
        if (!this.privCopyFile(dbHistoryFile, backupHistoryFile = new File(backupcopy, BACKUP_HISTORY))) {
            throw StandardException.newException("XSRS5.S", (Object)dbHistoryFile, (Object)backupHistoryFile);
        }
        StorageFile jarDir = this.storageFactory.newStorageFile("jar");
        if (this.privExists(jarDir)) {
            String[] jarSchemaList = this.privList(jarDir);
            File backupJarDir = new File(backupcopy, "jar");
            if (!this.privMkdirs(backupJarDir)) {
                throw StandardException.newException("XSRS6.S", backupJarDir);
            }
            for (int i = 0; i < jarSchemaList.length; ++i) {
                File backupJarSchemaDir;
                StorageFile jarSchemaDir = this.storageFactory.newStorageFile(jarDir, jarSchemaList[i]);
                if (this.privCopyDirectory(jarSchemaDir, backupJarSchemaDir = new File(backupJarDir, jarSchemaList[i]), null, null, false)) continue;
                throw StandardException.newException("XSRS5.S", (Object)jarSchemaDir, (Object)backupJarSchemaDir);
            }
        }
        StorageFile logdir = this.logFactory.getLogDirectory();
        try {
            String name = Monitor.getMonitor().getServiceName(this);
            PersistentService ps = Monitor.getMonitor().getServiceType(this);
            String fullName = ps.getCanonicalServiceName(name);
            Properties prop = ps.getServiceProperties(fullName, null);
            StorageFile defaultLogDir = this.storageFactory.newStorageFile("log");
            if (!logdir.equals(defaultLogDir)) {
                prop.remove("logDevice");
                SanityManager.ASSERT(prop.getProperty("logDevice") == null, "cannot get rid of logDevice property");
                this.logHistory(historyFile, MessageService.getTextMessage("D007"));
            }
            ps.saveServiceProperties(backupcopy.getPath(), prop, false);
        }
        catch (StandardException se) {
            this.logHistory(historyFile, MessageService.getTextMessage("D008") + se);
            Object var24_26 = null;
            try {
                if (error) {
                    this.logFactory.abortLogBackup();
                    if (!renameFailed) {
                        this.privRemoveDirectory(backupcopy);
                    }
                    if (renamed) {
                        this.privRenameTo(oldbackup, backupcopy);
                    }
                    this.logHistory(historyFile, MessageService.getTextMessage("D010"));
                } else {
                    if (renamed && this.privExists(oldbackup)) {
                        this.privRemoveDirectory(oldbackup);
                        this.logHistory(historyFile, MessageService.getTextMessage("D011", this.getFilePath(oldbackup)));
                    }
                    this.logHistory(historyFile, MessageService.getTextMessage("D012", backupInstant));
                    if (!this.privCopyFile(dbHistoryFile, backupHistoryFile)) {
                        throw StandardException.newException("XSRS5.S", (Object)dbHistoryFile, (Object)backupHistoryFile);
                    }
                }
                historyFile.close();
            }
            catch (IOException ioe) {
                try {
                    historyFile.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                throw StandardException.newException("XSRS7.S", ioe);
            }
            return;
        }
        StorageFile verifyKeyFile = this.storageFactory.newStorageFile("verifyKey.dat");
        if (this.privExists(verifyKeyFile) && !this.privCopyFile(verifyKeyFile, backupVerifyKeyFile = new File(backupcopy, "verifyKey.dat"))) {
            throw StandardException.newException("XSRS5.S", (Object)verifyKeyFile, (Object)backupVerifyKeyFile);
        }
        File logBackup = new File(backupcopy, "log");
        if (this.privExists(logBackup)) {
            this.privRemoveDirectory(logBackup);
        }
        if (!this.privMkdirs(logBackup)) {
            throw StandardException.newException("XSRS6.S", logBackup);
        }
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.logFactory.startLogBackup(logBackup);
        File segBackup = new File(backupcopy, "seg0");
        if (!this.privMkdirs(segBackup)) {
            throw StandardException.newException("XSRS6.S", segBackup);
        }
        this.dataFactory.backupDataFiles(t, segBackup);
        this.logHistory(historyFile, MessageService.getTextMessage("D006", this.getFilePath(segBackup)));
        this.logFactory.endLogBackup(logBackup);
        this.logHistory(historyFile, MessageService.getTextMessage("D009", this.getFilePath(logdir), this.getFilePath(logBackup)));
        error = false;
        Object var24_27 = null;
        try {
            if (error) {
                this.logFactory.abortLogBackup();
                if (!renameFailed) {
                    this.privRemoveDirectory(backupcopy);
                }
                if (renamed) {
                    this.privRenameTo(oldbackup, backupcopy);
                }
                this.logHistory(historyFile, MessageService.getTextMessage("D010"));
            } else {
                if (renamed && this.privExists(oldbackup)) {
                    this.privRemoveDirectory(oldbackup);
                    this.logHistory(historyFile, MessageService.getTextMessage("D011", this.getFilePath(oldbackup)));
                }
                this.logHistory(historyFile, MessageService.getTextMessage("D012", backupInstant));
                if (!this.privCopyFile(dbHistoryFile, backupHistoryFile)) {
                    throw StandardException.newException("XSRS5.S", (Object)dbHistoryFile, (Object)backupHistoryFile);
                }
            }
            historyFile.close();
        }
        catch (IOException ioe) {
            try {
                historyFile.close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw StandardException.newException("XSRS7.S", ioe);
        }
        {
            catch (IOException ioe) {
                throw StandardException.newException("XSRS7.S", ioe);
            }
        }
        catch (Throwable throwable) {
            Object var24_28 = null;
            try {
                if (error) {
                    this.logFactory.abortLogBackup();
                    if (!renameFailed) {
                        this.privRemoveDirectory(backupcopy);
                    }
                    if (renamed) {
                        this.privRenameTo(oldbackup, backupcopy);
                    }
                    this.logHistory(historyFile, MessageService.getTextMessage("D010"));
                } else {
                    if (renamed && this.privExists(oldbackup)) {
                        this.privRemoveDirectory(oldbackup);
                        this.logHistory(historyFile, MessageService.getTextMessage("D011", this.getFilePath(oldbackup)));
                    }
                    this.logHistory(historyFile, MessageService.getTextMessage("D012", backupInstant));
                    if (!this.privCopyFile(dbHistoryFile, backupHistoryFile)) {
                        throw StandardException.newException("XSRS5.S", dbHistoryFile, backupHistoryFile);
                    }
                }
                historyFile.close();
            }
            catch (IOException ioe) {
                try {
                    historyFile.close();
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                throw StandardException.newException("XSRS7.S", ioe);
            }
            throw throwable;
        }
    }

    public void backupAndEnableLogArchiveMode(String backupDir, boolean deleteOnlineArchivedLogFiles, boolean wait) throws StandardException {
        boolean enabledLogArchive = false;
        try {
            if (!this.logFactory.logArchived()) {
                this.logFactory.enableLogArchiveMode();
                enabledLogArchive = true;
            }
            this.backup(backupDir, wait);
            if (deleteOnlineArchivedLogFiles) {
                this.logFactory.deleteOnlineArchivedLogFiles();
            }
        }
        catch (Throwable error) {
            if (enabledLogArchive) {
                this.logFactory.disableLogArchiveMode();
            }
            throw StandardException.plainWrapException(error);
        }
    }

    public void disableLogArchiveMode(boolean deleteOnlineArchivedLogFiles) throws StandardException {
        this.logFactory.disableLogArchiveMode();
        if (deleteOnlineArchivedLogFiles) {
            this.logFactory.deleteOnlineArchivedLogFiles();
        }
    }

    private void restoreRemainingFromBackup(String backupPath) throws StandardException {
        File backupJarDir = new File(backupPath, "jar");
        StorageFile dbJarDir = this.storageFactory.newStorageFile("jar");
        if (!this.privExists(dbJarDir) && this.privExists(backupJarDir) && !this.privCopyDirectory(backupJarDir, dbJarDir)) {
            throw StandardException.newException("XBM0Z.D", (Object)backupJarDir, (Object)dbJarDir);
        }
        StorageFile dbHistoryFile = this.storageFactory.newStorageFile(BACKUP_HISTORY);
        File backupHistoryFile = new File(backupPath, BACKUP_HISTORY);
        if (this.privExists(backupHistoryFile) && !this.privExists(dbHistoryFile) && !this.privCopyFile(backupHistoryFile, dbHistoryFile)) {
            throw StandardException.newException("XSRS5.S", (Object)backupHistoryFile, (Object)dbHistoryFile);
        }
    }

    public void idle() throws StandardException {
        this.dataFactory.idle();
    }

    public TransactionInfo[] getTransactionInfo() {
        return this.xactFactory.getTransactionInfo();
    }

    public ScanHandle openFlushedScan(DatabaseInstant start, int groupsIWant) throws StandardException {
        return this.logFactory.openFlushedScan(start, groupsIWant);
    }

    public DaemonService getDaemon() {
        return this.rawStoreDaemon;
    }

    public void createFinished() throws StandardException {
        this.xactFactory.createFinished();
        this.dataFactory.createFinished();
    }

    public void getRawStoreProperties(PersistentSet set) throws StandardException {
        this.logFactory.getLogFactoryProperties(set);
    }

    public void freezePersistentStore() throws StandardException {
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        this.logFactory.freezePersistentStore();
    }

    public void unfreezePersistentStore() throws StandardException {
        this.logFactory.unfreezePersistentStore();
    }

    private void setupEncryptionEngines(boolean create, Properties properties) throws StandardException {
        String dataEncryption = properties.getProperty("dataEncryption");
        this.databaseEncrypted = Boolean.valueOf(dataEncryption);
        boolean reEncrypt = false;
        if (!create) {
            String canonicalName;
            String name = Monitor.getMonitor().getServiceName(this);
            PersistentService ps = Monitor.getMonitor().getServiceType(this);
            Properties serviceprops = ps.getServiceProperties(canonicalName = ps.getCanonicalServiceName(name), null);
            dataEncryption = serviceprops.getProperty("dataEncryption");
            boolean encryptedDatabase = Boolean.valueOf(dataEncryption);
            if (!encryptedDatabase && this.databaseEncrypted) {
                this.encryptDatabase = true;
                this.databaseEncrypted = false;
            } else if (encryptedDatabase) {
                if (properties.getProperty("newBootPassword") != null) {
                    reEncrypt = true;
                } else if (properties.getProperty("newEncryptionKey") != null) {
                    reEncrypt = true;
                }
                this.encryptDatabase = reEncrypt;
            }
            if (this.encryptDatabase && this.isReadOnly()) {
                if (reEncrypt) {
                    throw StandardException.newException("XBCXR.S");
                }
                throw StandardException.newException("XBCXQ.S");
            }
        }
        if (this.databaseEncrypted || this.encryptDatabase) {
            boolean setupEncryption = create || this.encryptDatabase && !reEncrypt;
            CipherFactoryBuilder cb = (CipherFactoryBuilder)Monitor.startSystemModule("org.apache.derby.iapi.services.crypto.CipherFactoryBuilder");
            this.currentCipherFactory = cb.createCipherFactory(setupEncryption, properties, false);
            this.currentCipherFactory.verifyKey(setupEncryption, this.storageFactory, properties);
            this.encryptionEngine = this.currentCipherFactory.createNewCipher(1);
            if (setupEncryption) {
                this.encryptionBlockSize = this.encryptionEngine.getEncryptionBlockSize();
                if (create) {
                    properties.put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
                }
            } else {
                this.encryptionBlockSize = properties.getProperty("derby.encryptionBlockSize") != null ? Integer.parseInt(properties.getProperty("derby.encryptionBlockSize")) : this.encryptionEngine.getEncryptionBlockSize();
            }
            this.decryptionEngine = this.currentCipherFactory.createNewCipher(2);
            this.random = this.currentCipherFactory.getSecureRandom();
            if (this.encryptDatabase) {
                if (reEncrypt) {
                    this.newCipherFactory = cb.createCipherFactory(setupEncryption, properties, true);
                    this.newDecryptionEngine = this.newCipherFactory.createNewCipher(2);
                    this.newEncryptionEngine = this.newCipherFactory.createNewCipher(1);
                } else {
                    this.newDecryptionEngine = this.decryptionEngine;
                    this.newEncryptionEngine = this.encryptionEngine;
                }
            }
            if (create) {
                this.currentCipherFactory.saveProperties(properties);
            }
        }
    }

    public int encrypt(byte[] cleartext, int offset, int length, byte[] ciphertext, int outputOffset, boolean newEngine) throws StandardException {
        if (!this.databaseEncrypted && !this.encryptDatabase || this.encryptionEngine == null && this.newEncryptionEngine == null) {
            throw StandardException.newException("XSAI3.S");
        }
        ++this.counter_encrypt;
        if (newEngine) {
            return this.newEncryptionEngine.encrypt(cleartext, offset, length, ciphertext, outputOffset);
        }
        return this.encryptionEngine.encrypt(cleartext, offset, length, ciphertext, outputOffset);
    }

    public int decrypt(byte[] ciphertext, int offset, int length, byte[] cleartext, int outputOffset) throws StandardException {
        if (!this.databaseEncrypted || this.decryptionEngine == null) {
            throw StandardException.newException("XSAI3.S");
        }
        ++this.counter_decrypt;
        return this.decryptionEngine.decrypt(ciphertext, offset, length, cleartext, outputOffset);
    }

    public int getEncryptionBlockSize() {
        return this.encryptionBlockSize;
    }

    public int random() {
        return this.databaseEncrypted ? this.random.nextInt() : 0;
    }

    public Serializable changeBootPassword(Properties properties, Serializable changePassword) throws StandardException {
        if (this.isReadOnly()) {
            throw StandardException.newException("XBCX9.S");
        }
        if (!this.databaseEncrypted) {
            throw StandardException.newException("XBCX8.S");
        }
        if (changePassword == null) {
            throw StandardException.newException("XBCX5.S");
        }
        if (!(changePassword instanceof String)) {
            throw StandardException.newException("XBCX6.S");
        }
        String changeString = (String)((Object)changePassword);
        return this.currentCipherFactory.changeBootPassword((String)((Object)changePassword), properties, this.encryptionEngine);
    }

    private void crashOnDebugFlag(String debugFlag, boolean reEncrypt) throws StandardException {
        if (SanityManager.DEBUG_ON(debugFlag)) {
            StandardException se = StandardException.newException(reEncrypt ? "XBCXV.S" : "XBCXU.S", debugFlag);
            this.markCorrupt(se);
            throw se;
        }
    }

    public void configureDatabaseForEncryption(Properties properties, CipherFactory newCipherFactory) throws StandardException {
        boolean reEncrypt = this.databaseEncrypted && this.encryptDatabase;
        this.canEncryptDatabase(reEncrypt);
        boolean externalKeyEncryption = false;
        if (properties.getProperty("encryptionKey") != null) {
            externalKeyEncryption = true;
        }
        this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
        RawTransaction transaction = this.xactFactory.startTransaction(this, ContextService.getFactory().getCurrentContextManager(), "UserTransaction");
        try {
            try {
                this.dataFactory.encryptAllContainers(transaction);
                this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_BEFORE_COMMT, reEncrypt);
                if (!this.logFactory.isCheckpointInLastLogFile()) {
                    this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
                }
                this.encryptDatabase = false;
                this.logFactory.setDatabaseEncrypted(true);
                if (!reEncrypt) {
                    this.databaseEncrypted = true;
                    this.dataFactory.setDatabaseEncrypted();
                } else {
                    this.decryptionEngine = this.newDecryptionEngine;
                    this.encryptionEngine = this.newEncryptionEngine;
                    this.currentCipherFactory = newCipherFactory;
                }
                this.logFactory.startNewLogFile();
                properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(1));
                if (reEncrypt) {
                    if (externalKeyEncryption) {
                        StorageFile oldVerifyKeyFile;
                        StorageFile verifyKeyFile = this.storageFactory.newStorageFile("verifyKey.dat");
                        if (!this.privCopyFile(verifyKeyFile, oldVerifyKeyFile = this.storageFactory.newStorageFile("verifyOldKey.dat"))) {
                            throw StandardException.newException("XSRS5.S", (Object)verifyKeyFile, (Object)oldVerifyKeyFile);
                        }
                        this.currentCipherFactory.verifyKey(reEncrypt, this.storageFactory, properties);
                    } else {
                        String keyString = properties.getProperty("encryptedBootPassword");
                        if (keyString != null) {
                            properties.put("OldEncryptedBootPassword", keyString);
                        }
                    }
                } else {
                    properties.put("derby.encryptionBlockSize", String.valueOf(this.encryptionBlockSize));
                }
                this.currentCipherFactory.saveProperties(properties);
                this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_AFTER_SWITCH_TO_NEWKEY, reEncrypt);
                transaction.commit();
                this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_AFTER_COMMT, reEncrypt);
                this.logFactory.checkpoint(this, this.dataFactory, this.xactFactory, true);
                this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_AFTER_CHECKPOINT, reEncrypt);
                properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(3));
                this.dataFactory.removeOldVersionOfContainers(false);
                if (reEncrypt) {
                    if (externalKeyEncryption) {
                        StorageFile oldVerifyKeyFile = this.storageFactory.newStorageFile("verifyOldKey.dat");
                        if (!this.privDelete(oldVerifyKeyFile)) {
                            throw StandardException.newException("XBM0R.D", oldVerifyKeyFile);
                        }
                    } else {
                        properties.remove("OldEncryptedBootPassword");
                    }
                }
                properties.remove("derby.storage.databaseEncryptionStatus");
                transaction.close();
            }
            catch (StandardException se) {
                throw StandardException.newException(reEncrypt ? "XBCXV.S" : "XBCXU.S", se, (Object)se.getMessage());
            }
            Object var9_9 = null;
            this.newDecryptionEngine = null;
            this.newEncryptionEngine = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.newDecryptionEngine = null;
            this.newEncryptionEngine = null;
            throw throwable;
        }
    }

    public void handleIncompleteDatabaseEncryption(Properties properties) throws StandardException {
        int dbEncryptionStatus = 0;
        String dbEncryptionStatusStr = properties.getProperty("derby.storage.databaseEncryptionStatus");
        if (dbEncryptionStatusStr != null) {
            dbEncryptionStatus = Integer.parseInt(dbEncryptionStatusStr);
        }
        boolean reEncryption = false;
        if (dbEncryptionStatus == 1) {
            if (this.logFactory.isCheckpointInLastLogFile()) {
                dbEncryptionStatus = 3;
            } else {
                dbEncryptionStatus = 2;
                properties.put("derby.storage.databaseEncryptionStatus", String.valueOf(dbEncryptionStatus));
            }
        }
        if (dbEncryptionStatus == 2) {
            this.logFactory.deleteLogFileAfterCheckpointLogFile();
            this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_LOGFILE_DELETE, reEncryption);
            StorageFile verifyKeyFile = this.storageFactory.newStorageFile("verifyKey.dat");
            if (this.privExists(verifyKeyFile)) {
                StorageFile oldVerifyKeyFile = this.storageFactory.newStorageFile("verifyOldKey.dat");
                if (this.privExists(oldVerifyKeyFile)) {
                    if (!this.privCopyFile(oldVerifyKeyFile, verifyKeyFile)) {
                        throw StandardException.newException("XSRS5.S", (Object)oldVerifyKeyFile, (Object)verifyKeyFile);
                    }
                    reEncryption = true;
                } else if (!this.privDelete(verifyKeyFile)) {
                    throw StandardException.newException("XBM0R.D", verifyKeyFile);
                }
            } else {
                String OldKeyString = properties.getProperty("OldEncryptedBootPassword");
                if (OldKeyString != null) {
                    properties.put("encryptedBootPassword", OldKeyString);
                    reEncryption = true;
                }
            }
            if (!reEncryption) {
                properties.remove("dataEncryption");
                properties.remove("log_encrypt_algorithm_version");
                properties.remove("data_encrypt_algorithm_version");
                properties.remove("derby.encryptionBlockSize");
                properties.remove("encryptionKeyLength");
                properties.remove("encryptionProvider");
                properties.remove("encryptionAlgorithm");
                properties.remove("encryptedBootPassword");
            }
            this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_AFTER_RECOVERY_UNDO_REVERTING_KEY, reEncryption);
        }
        if (dbEncryptionStatus == 3) {
            this.dataFactory.removeOldVersionOfContainers(true);
        }
        this.crashOnDebugFlag(TEST_REENCRYPT_CRASH_BEFORE_RECOVERY_FINAL_CLEANUP, reEncryption);
        StorageFile oldVerifyKeyFile = this.storageFactory.newStorageFile("verifyOldKey.dat");
        if (this.privExists(oldVerifyKeyFile)) {
            if (!this.privDelete(oldVerifyKeyFile)) {
                throw StandardException.newException("XBM0R.D", oldVerifyKeyFile);
            }
        } else {
            properties.remove("OldEncryptedBootPassword");
        }
        properties.remove("derby.storage.databaseEncryptionStatus");
    }

    private void canEncryptDatabase(boolean reEncrypt) throws StandardException {
        String feature = reEncrypt ? "newBootPassword/newEncryptionKey attribute" : "dataEncryption attribute on an existing database";
        this.logFactory.checkVersion(10, 2, feature);
        if (this.xactFactory.hasPreparedXact()) {
            if (reEncrypt) {
                throw StandardException.newException("XBCXP.S");
            }
            throw StandardException.newException("XBCXO.S");
        }
        if (this.logFactory.logArchived()) {
            if (reEncrypt) {
                throw StandardException.newException("XBCXT.S");
            }
            throw StandardException.newException("XBCXS.S");
        }
    }

    public StandardException markCorrupt(StandardException originalError) {
        this.logFactory.markCorrupt(originalError);
        this.dataFactory.markCorrupt(originalError);
        this.xactFactory.markCorrupt(originalError);
        return originalError;
    }

    public String getTransactionFactoryModule() {
        return "org.apache.derby.iapi.store.raw.xact.TransactionFactory";
    }

    public String getSlaveFactoryModule() {
        return "org.apache.derby.iapi.store.replication.slave.SlaveFactory";
    }

    public String getMasterFactoryModule() {
        return "org.apache.derby.iapi.store.replication.master.MasterFactory";
    }

    public String getDataFactoryModule() {
        return "org.apache.derby.iapi.store.raw.data.DataFactory";
    }

    public String getLogFactoryModule() {
        return "org.apache.derby.iapi.store.raw.log.LogFactory";
    }

    private void logHistory(OutputStreamWriter historyFile, String msg) throws IOException {
        Date d = new Date();
        historyFile.write(d.toString() + ":" + msg + "\n");
        historyFile.flush();
    }

    private String getFilePath(StorageFile file) {
        String path = this.privGetCanonicalPath(file);
        if (path != null) {
            return path;
        }
        return file.getPath();
    }

    private String getFilePath(File file) {
        String path = this.privGetCanonicalPath(file);
        if (path != null) {
            return path;
        }
        return file.getPath();
    }

    protected boolean privCopyDirectory(StorageFile from, File to) {
        return this.privCopyDirectory(from, to, null, null, true);
    }

    protected boolean privCopyDirectory(File from, StorageFile to) {
        return this.privCopyDirectory(from, to, null, null);
    }

    public long getMaxContainerId() throws StandardException {
        return this.dataFactory.getMaxContainerId();
    }

    public boolean checkVersion(int requiredMajorVersion, int requiredMinorVersion, String feature) throws StandardException {
        return this.logFactory.checkVersion(requiredMajorVersion, requiredMinorVersion, feature);
    }

    private synchronized OutputStreamWriter privFileWriter(StorageFile fileName, boolean append) throws IOException {
        this.actionCode = 1;
        this.actionStorageFile = fileName;
        this.actionAppend = append;
        try {
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)AccessController.doPrivileged(this);
            Object var5_5 = null;
            this.actionStorageFile = null;
            return outputStreamWriter;
        }
        catch (PrivilegedActionException pae) {
            try {
                throw (IOException)pae.getException();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.actionStorageFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(File file) {
        this.actionCode = 2;
        this.actionRegularFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var5_6 = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privExists(StorageFile file) {
        this.actionCode = 3;
        this.actionStorageFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var5_6 = null;
            this.actionStorageFile = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionStorageFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionStorageFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(File file) {
        this.actionCode = 4;
        this.actionRegularFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var5_6 = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privDelete(StorageFile file) {
        this.actionCode = 18;
        this.actionStorageFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var5_6 = null;
            this.actionStorageFile = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionStorageFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionStorageFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privMkdirs(File file) {
        this.actionCode = 5;
        this.actionRegularFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var5_6 = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privIsDirectory(File file) {
        this.actionCode = 6;
        this.actionRegularFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var5_6 = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privRemoveDirectory(File file) {
        this.actionCode = 7;
        this.actionRegularFile = file;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var5_6 = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privRenameTo(File file1, File file2) {
        this.actionCode = 8;
        this.actionRegularFile = file1;
        this.actionRegularFile2 = file2;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var6_7 = null;
            this.actionRegularFile = null;
            this.actionRegularFile2 = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var6_8 = null;
                this.actionRegularFile = null;
                this.actionRegularFile2 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.actionRegularFile = null;
                this.actionRegularFile2 = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyDirectory(StorageFile from, File to, byte[] buffer, String[] filter, boolean copySubdirs) {
        this.actionCode = 9;
        this.actionStorageFile = from;
        this.actionRegularFile = to;
        this.actionBuffer = buffer;
        this.actionFilter = filter;
        this.actionCopySubDirs = copySubdirs;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var9_10 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var9_11 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyDirectory(File from, StorageFile to, byte[] buffer, String[] filter) {
        this.actionCode = 10;
        this.actionStorageFile = to;
        this.actionRegularFile = from;
        this.actionBuffer = buffer;
        this.actionFilter = filter;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var8_9 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            this.actionBuffer = null;
            this.actionFilter = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var8_10 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                this.actionBuffer = null;
                this.actionFilter = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(File from, StorageFile to) {
        this.actionCode = 11;
        this.actionStorageFile = to;
        this.actionRegularFile = from;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var6_7 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var6_8 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(StorageFile from, File to) {
        this.actionCode = 14;
        this.actionStorageFile = from;
        this.actionRegularFile = to;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var6_7 = null;
            this.actionStorageFile = null;
            this.actionRegularFile = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var6_8 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.actionStorageFile = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean privCopyFile(StorageFile from, StorageFile to) {
        this.actionCode = 17;
        this.actionStorageFile = from;
        this.actionToStorageFile = to;
        try {
            Object ret = AccessController.doPrivileged(this);
            boolean bl = (Boolean)ret;
            Object var6_7 = null;
            this.actionStorageFile = null;
            this.actionToStorageFile = null;
            return bl;
        }
        catch (PrivilegedActionException pae) {
            try {
                boolean bl = false;
                Object var6_8 = null;
                this.actionStorageFile = null;
                this.actionToStorageFile = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.actionStorageFile = null;
                this.actionToStorageFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] privList(File file) {
        this.actionCode = 12;
        this.actionRegularFile = file;
        try {
            String[] stringArray = (String[])AccessController.doPrivileged(this);
            Object var5_4 = null;
            this.actionRegularFile = null;
            return stringArray;
        }
        catch (PrivilegedActionException pae) {
            try {
                String[] stringArray = null;
                Object var5_5 = null;
                this.actionRegularFile = null;
                return stringArray;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.actionRegularFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String[] privList(StorageFile file) {
        this.actionCode = 13;
        this.actionStorageFile = file;
        try {
            String[] stringArray = (String[])AccessController.doPrivileged(this);
            Object var5_4 = null;
            this.actionStorageFile = null;
            return stringArray;
        }
        catch (PrivilegedActionException pae) {
            try {
                String[] stringArray = null;
                Object var5_5 = null;
                this.actionStorageFile = null;
                return stringArray;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.actionStorageFile = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String privGetCanonicalPath(StorageFile file) {
        this.actionCode = 16;
        this.actionStorageFile = file;
        try {
            try {
                String string = (String)AccessController.doPrivileged(this);
                Object var5_5 = null;
                this.actionStorageFile = null;
                return string;
            }
            catch (PrivilegedActionException pae) {
                String string = null;
                Object var5_6 = null;
                this.actionStorageFile = null;
                return string;
            }
            catch (SecurityException se) {
                String string = null;
                Object var5_7 = null;
                this.actionStorageFile = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.actionStorageFile = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized String privGetCanonicalPath(File file) {
        this.actionCode = 15;
        this.actionRegularFile = file;
        try {
            try {
                String string = (String)AccessController.doPrivileged(this);
                Object var5_5 = null;
                this.actionRegularFile = null;
                return string;
            }
            catch (PrivilegedActionException pae) {
                String string = null;
                Object var5_6 = null;
                this.actionRegularFile = null;
                return string;
            }
            catch (SecurityException se) {
                String string = null;
                Object var5_7 = null;
                this.actionRegularFile = null;
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.actionRegularFile = null;
            throw throwable;
        }
    }

    public final Object run() throws IOException {
        switch (this.actionCode) {
            case 1: {
                return new OutputStreamWriter(this.actionStorageFile.getOutputStream(this.actionAppend));
            }
            case 2: {
                return ReuseFactory.getBoolean(this.actionRegularFile.exists());
            }
            case 3: {
                return ReuseFactory.getBoolean(this.actionStorageFile.exists());
            }
            case 4: {
                return ReuseFactory.getBoolean(this.actionRegularFile.delete());
            }
            case 18: {
                return ReuseFactory.getBoolean(this.actionStorageFile.delete());
            }
            case 5: {
                return ReuseFactory.getBoolean(this.actionRegularFile.mkdirs());
            }
            case 6: {
                return ReuseFactory.getBoolean(this.actionRegularFile.isDirectory());
            }
            case 7: {
                return ReuseFactory.getBoolean(FileUtil.removeDirectory(this.actionRegularFile));
            }
            case 8: {
                return ReuseFactory.getBoolean(this.actionRegularFile.renameTo(this.actionRegularFile2));
            }
            case 9: {
                return ReuseFactory.getBoolean(FileUtil.copyDirectory(this.storageFactory, this.actionStorageFile, this.actionRegularFile, this.actionBuffer, this.actionFilter, this.actionCopySubDirs));
            }
            case 10: {
                return ReuseFactory.getBoolean(FileUtil.copyDirectory((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile, this.actionBuffer, this.actionFilter));
            }
            case 11: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionRegularFile, this.actionStorageFile));
            }
            case 12: {
                return this.actionRegularFile.list();
            }
            case 13: {
                return this.actionStorageFile.list();
            }
            case 14: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((StorageFactory)((WritableStorageFactory)this.storageFactory), this.actionStorageFile, this.actionRegularFile));
            }
            case 17: {
                return ReuseFactory.getBoolean(FileUtil.copyFile((WritableStorageFactory)this.storageFactory, this.actionStorageFile, this.actionToStorageFile));
            }
            case 15: {
                return this.actionRegularFile.getCanonicalPath();
            }
            case 16: {
                return this.actionStorageFile.getCanonicalPath();
            }
        }
        return null;
    }
}

