/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.impl.store.raw.data.ContainerBasicOperation;
import org.apache.derby.impl.store.raw.data.ContainerOperation;

public class ContainerUndoOperation
extends ContainerBasicOperation
implements Compensation {
    private transient ContainerOperation undoOp;

    public ContainerUndoOperation(RawContainerHandle hdl, ContainerOperation op) throws StandardException {
        super(hdl);
        this.undoOp = op;
    }

    public ContainerUndoOperation() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public int getTypeFormatId() {
        return 107;
    }

    public void setUndoOp(Undoable op) {
        SanityManager.ASSERT(op instanceof ContainerOperation);
        this.undoOp = (ContainerOperation)op;
    }

    public final void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        SanityManager.ASSERT(this.containerHdl != null, "clr has null containerHdl");
        this.undoOp.undoMe(xact, this.containerHdl, instant, in);
        this.releaseResource(xact);
    }

    public void releaseResource(Transaction xact) {
        if (this.undoOp != null) {
            this.undoOp.releaseResource(xact);
        }
        super.releaseResource(xact);
    }

    public int group() {
        return super.group() | 4 | 0x100;
    }
}

