/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.impl.store.raw.xact.XactId;

public class TransactionTable
implements Formatable {
    private Hashtable trans = new Hashtable(17);
    private TransactionId largestUpdateXactId;

    private TransactionTableEntry findTransactionEntry(TransactionId id) {
        SanityManager.ASSERT(id != null, "findTransacionEntry with null id");
        return (TransactionTableEntry)this.trans.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Xact xact, boolean exclude) {
        TransactionId id = xact.getId();
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry ent = this.findTransactionEntry(id);
            if (ent == null) {
                ent = new TransactionTableEntry(xact, id, 0, exclude ? 4 : 0);
                this.trans.put(id, ent);
                if (SanityManager.DEBUG_ON("TranTrace")) {
                    SanityManager.DEBUG("TranTrace", "adding transaction " + id);
                    SanityManager.showTrace(new Throwable("TranTrace"));
                }
            }
            if (exclude != ent.needExclusion()) {
                SanityManager.THROWASSERT("adding the same transaction with different exclusion: " + exclude + " " + ent.needExclusion());
            }
        }
        if (SanityManager.DEBUG_ON("memoryLeakTrace") && this.trans.size() > 50) {
            System.out.println("memoryLeakTrace:TransactionTable " + this.trans.size());
        }
    }

    boolean remove(TransactionId id) {
        TransactionTableEntry ent;
        SanityManager.ASSERT(id != null, "cannot remove transaction from table with null id");
        if (SanityManager.DEBUG_ON("TranTrace")) {
            SanityManager.DEBUG("TranTrace", "removing transaction " + id);
            SanityManager.showTrace(new Throwable("TranTrace"));
        }
        return (ent = (TransactionTableEntry)this.trans.remove(id)) == null || ent.needExclusion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateTransaction(TransactionId tid, RawTransaction tran, int transactionStatus) {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry ent = this.findTransactionEntry(tid);
            if (ent != null) {
                ent.updateTransactionStatus((Xact)tran, transactionStatus, 1);
            } else {
                ent = new TransactionTableEntry((Xact)tran, tid, transactionStatus, 7);
                this.trans.put(tid, ent);
            }
            if (XactId.compare(ent.getXid(), this.largestUpdateXactId) > 0L) {
                this.largestUpdateXactId = ent.getXid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUpdateTransaction(TransactionId id) {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry ent = this.findTransactionEntry(id);
            SanityManager.ASSERT(ent != null, "removing update transaction that is not there");
            ent.removeUpdateTransaction();
            if (ent.isRecovery()) {
                this.remove(id);
            }
        }
    }

    public Hashtable getTableForXA() {
        return this.trans;
    }

    void prepareTransaction(TransactionId id) {
        TransactionTableEntry ent = this.findTransactionEntry(id);
        SanityManager.ASSERT(ent != null, "preparing transaction that is not there");
        ent.prepareTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextManager findTransactionContextByGlobalId(GlobalXactId global_id) {
        ContextManager cm = null;
        Hashtable hashtable = this.trans;
        synchronized (hashtable) {
            Enumeration e = this.trans.elements();
            while (e.hasMoreElements()) {
                GlobalTransactionId entry_gid;
                TransactionTableEntry entry = (TransactionTableEntry)e.nextElement();
                if (entry == null || (entry_gid = entry.getGid()) == null || !entry_gid.equals(global_id)) continue;
                cm = entry.getXact().getContextManager();
                break;
            }
        }
        return cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasActiveUpdateTransaction() {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            Enumeration e = this.trans.elements();
            while (e.hasMoreElements()) {
                TransactionTableEntry ent = (TransactionTableEntry)e.nextElement();
                if (ent == null || !ent.isUpdate()) continue;
                return true;
            }
        }
        return false;
    }

    public int getTypeFormatId() {
        return 262;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(ObjectOutput out) throws IOException {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            Hashtable hashtable = this.trans;
            synchronized (hashtable) {
                TransactionTableEntry ent;
                int count = 0;
                int maxcount = this.trans.size();
                Enumeration e = this.trans.elements();
                while (e.hasMoreElements()) {
                    ent = (TransactionTableEntry)e.nextElement();
                    if (ent == null || !ent.isUpdate()) continue;
                    ++count;
                }
                CompressedNumber.writeInt(out, count);
                if (count > 0) {
                    e = this.trans.elements();
                    while (e.hasMoreElements()) {
                        ent = (TransactionTableEntry)e.nextElement();
                        if (ent == null || !ent.isUpdate()) continue;
                        out.writeObject(ent);
                    }
                }
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int count = CompressedNumber.readInt(in);
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            TransactionTableEntry ent = (TransactionTableEntry)in.readObject();
            SanityManager.ASSERT(ent.getXid() != null, "read in transaction table entry with null id");
            this.trans.put(ent.getXid(), ent);
            if (!ent.isUpdate() || XactId.compare(ent.getXid(), this.largestUpdateXactId) <= 0L) continue;
            this.largestUpdateXactId = ent.getXid();
        }
    }

    public TransactionId largestUpdateXactId() {
        return this.largestUpdateXactId;
    }

    public boolean hasRollbackFirstTransaction() {
        Enumeration e = this.trans.elements();
        while (e.hasMoreElements()) {
            TransactionTableEntry ent = (TransactionTableEntry)e.nextElement();
            if (ent == null || !ent.isRecovery() || (ent.getTransactionStatus() & 0x10) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasPreparedRecoveredXact() {
        return this.hasPreparedXact(true);
    }

    public boolean hasPreparedXact() {
        return this.hasPreparedXact(false);
    }

    private boolean hasPreparedXact(boolean recovered) {
        Enumeration e = this.trans.elements();
        while (e.hasMoreElements()) {
            TransactionTableEntry ent = (TransactionTableEntry)e.nextElement();
            if (ent == null || (ent.getTransactionStatus() & 2) == 0) continue;
            if (recovered) {
                if (!ent.isRecovery()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean getMostRecentRollbackFirstTransaction(RawTransaction tran) {
        if (this.trans.isEmpty()) {
            return this.findAndAssumeTransaction(null, tran);
        }
        TransactionId id = null;
        Enumeration e = this.trans.elements();
        while (e.hasMoreElements()) {
            TransactionTableEntry ent = (TransactionTableEntry)e.nextElement();
            if (ent == null || !ent.isUpdate() || !ent.isRecovery() || (ent.getTransactionStatus() & 0x10) == 0 || id != null && XactId.compare(id, ent.getXid()) >= 0L) continue;
            id = ent.getXid();
        }
        if (id == null) {
            return this.findAndAssumeTransaction(id, tran);
        }
        boolean found = this.findAndAssumeTransaction(id, tran);
        if (!found) {
            SanityManager.THROWASSERT("cannot find transaction " + id + " in table");
        }
        return true;
    }

    public boolean getMostRecentTransactionForRollback(RawTransaction tran) {
        TransactionId id = null;
        if (!this.trans.isEmpty()) {
            TransactionTableEntry ent;
            Enumeration e = this.trans.elements();
            while (e.hasMoreElements()) {
                ent = (TransactionTableEntry)e.nextElement();
                if (ent != null && ent.isUpdate() && ent.isRecovery() && !ent.isPrepared() && (id == null || XactId.compare(id, ent.getXid()) < 0L)) {
                    id = ent.getXid();
                }
                if (ent == null || !ent.isUpdate() || !ent.isRecovery() || (ent.getTransactionStatus() & 0x10) == 0) continue;
                SanityManager.THROWASSERT("still rollback first xacts in the tran table!");
            }
            if (id != null) {
                SanityManager.ASSERT(this.findTransactionEntry(id) != null);
            } else {
                e = this.trans.elements();
                while (e.hasMoreElements()) {
                    ent = (TransactionTableEntry)e.nextElement();
                    SanityManager.ASSERT(ent.isPrepared());
                }
            }
        }
        return this.findAndAssumeTransaction(id, tran);
    }

    public boolean getMostRecentPreparedRecoveredXact(RawTransaction tran) {
        TransactionTableEntry found_ent = null;
        if (!this.trans.isEmpty()) {
            TransactionTableEntry ent;
            TransactionId id = null;
            GlobalTransactionId gid = null;
            Enumeration e = this.trans.elements();
            while (e.hasMoreElements()) {
                ent = (TransactionTableEntry)e.nextElement();
                if (ent == null || !ent.isRecovery() || !ent.isPrepared() || id != null && XactId.compare(id, ent.getXid()) >= 0L) continue;
                found_ent = ent;
                id = ent.getXid();
                gid = ent.getGid();
            }
            if (found_ent == null) {
                e = this.trans.elements();
                while (e.hasMoreElements()) {
                    ent = (TransactionTableEntry)e.nextElement();
                    if (XactId.compare(ent.getXid(), tran.getId()) == 0L) continue;
                    SanityManager.ASSERT(!ent.isRecovery() && ent.isPrepared());
                    SanityManager.ASSERT(ent.getGid() != null);
                }
            }
            if (found_ent != null) {
                TransactionTableEntry new_ent = (TransactionTableEntry)this.trans.remove(tran.getId());
                SanityManager.ASSERT(this.findTransactionEntry(id) == found_ent);
                ((Xact)tran).assumeGlobalXactIdentity(found_ent);
                found_ent.unsetRecoveryStatus();
            }
        }
        return found_ent != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogInstant getFirstLogInstant() {
        if (this.trans.isEmpty()) {
            return null;
        }
        LogInstant logInstant = null;
        Hashtable hashtable = this.trans;
        synchronized (hashtable) {
            Enumeration e = this.trans.elements();
            while (e.hasMoreElements()) {
                TransactionTableEntry ent = (TransactionTableEntry)e.nextElement();
                if (ent == null || !ent.isUpdate() || logInstant != null && !ent.getFirstLog().lessThan(logInstant)) continue;
                logInstant = ent.getFirstLog();
            }
        }
        return logInstant;
    }

    boolean findAndAssumeTransaction(TransactionId id, RawTransaction tran) {
        TransactionTableEntry ent = null;
        if (id != null && !this.trans.isEmpty() && (ent = this.findTransactionEntry(id)) != null) {
            SanityManager.ASSERT(ent.isRecovery(), "assuming the id of a non-recovery transaction");
        }
        ((Xact)tran).assumeIdentity(ent);
        return ent != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionInfo[] getTransactionInfo() {
        TransactionInfo[] tinfo;
        if (this.trans.isEmpty()) {
            return null;
        }
        SanityManager.DEBUG("TranTrace", this.toString());
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            int ntran = this.trans.size();
            tinfo = new TransactionTableEntry[ntran];
            Object logInstant = null;
            int i = 0;
            Enumeration e = this.trans.elements();
            while (e.hasMoreElements()) {
                TransactionTableEntry ent = (TransactionTableEntry)e.nextElement();
                if (ent != null) {
                    tinfo[i++] = (TransactionTableEntry)ent.clone();
                }
                SanityManager.ASSERT(ent != null, "transaction table has null entry");
            }
        }
        return tinfo;
    }

    public String toString() {
        TransactionTableEntry ent;
        StringBuffer str = new StringBuffer(1000).append("\n**************************\n").append(super.toString()).append("\nTransaction Table: size = ").append(this.trans.size()).append(" largestUpdateXactId = ").append(this.largestUpdateXactId).append("\n");
        boolean hasReadOnlyTransaction = false;
        Enumeration e = this.trans.elements();
        while (e.hasMoreElements()) {
            ent = (TransactionTableEntry)e.nextElement();
            if (ent != null && ent.isUpdate()) {
                str.append(ent.toString());
            }
            if (ent == null || ent.isUpdate()) continue;
            hasReadOnlyTransaction = true;
        }
        if (hasReadOnlyTransaction) {
            str.append("\n READ ONLY TRANSACTIONS \n");
            e = this.trans.elements();
            while (e.hasMoreElements()) {
                ent = (TransactionTableEntry)e.nextElement();
                if (ent == null || ent.isUpdate()) continue;
                str.append(ent.toString());
            }
        }
        str.append("---------------------------");
        return str.toString();
    }
}

