/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.xa.Xid;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.TransactionTable;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.Xact;

public class XactXAResourceManager
implements XAResourceManager {
    private TransactionTable transaction_table;
    private RawStoreFactory rsf;

    public XactXAResourceManager(RawStoreFactory rsf, TransactionTable tt) {
        this.rsf = rsf;
        this.transaction_table = tt;
    }

    public void commit(ContextManager cm, Xid xid, boolean onePhase) throws StandardException {
        Transaction rawtran = this.rsf.findUserTransaction(cm, "UserTransaction");
        if (rawtran == null) {
            throw StandardException.newException("XSAX0.S");
        }
        SanityManager.ASSERT(rawtran != null);
        SanityManager.ASSERT(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()).equals(rawtran.getGlobalId()));
        rawtran.xa_commit(onePhase);
    }

    public ContextManager find(Xid xid) {
        return this.transaction_table.findTransactionContextByGlobalId(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()));
    }

    public void forget(ContextManager cm, Xid xid) throws StandardException {
        Transaction rawtran = this.rsf.findUserTransaction(cm, "UserTransaction");
        SanityManager.ASSERT(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()).equals(rawtran.getGlobalId()));
        throw StandardException.newException("XSAX0.S");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flags) throws StandardException {
        Xid[] ret_xid_list;
        if ((flags & 0x1000000) != 0) {
            int i;
            Hashtable trans_hashtable = this.transaction_table.getTableForXA();
            XAXactId[] xid_list = new XAXactId[trans_hashtable.size()];
            int num_prepared = 0;
            Hashtable hashtable = trans_hashtable;
            synchronized (hashtable) {
                i = 0;
                Enumeration e = trans_hashtable.elements();
                while (e.hasMoreElements()) {
                    Xact xact = ((TransactionTableEntry)e.nextElement()).getXact();
                    if (xact.isPrepared()) {
                        GlobalTransactionId xa_id = xact.getGlobalId();
                        xid_list[i] = new XAXactId(xa_id.getFormat_Id(), xa_id.getGlobalTransactionId(), xa_id.getBranchQualifier());
                        ++num_prepared;
                    }
                    ++i;
                }
            }
            ret_xid_list = new XAXactId[num_prepared];
            int ret_index = 0;
            i = xid_list.length;
            while (i-- > 0) {
                if (xid_list[i] == null) continue;
                ret_xid_list[ret_index++] = xid_list[i];
            }
            SanityManager.ASSERT(ret_index == num_prepared);
        } else {
            ret_xid_list = new XAXactId[]{};
        }
        return ret_xid_list;
    }

    public void rollback(ContextManager cm, Xid xid) throws StandardException {
        Transaction rawtran = this.rsf.findUserTransaction(cm, "UserTransaction");
        if (rawtran == null) {
            throw StandardException.newException("XSAX0.S");
        }
        SanityManager.ASSERT(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()).equals(rawtran.getGlobalId()));
        rawtran.xa_rollback();
    }
}

