/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.SupBookRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class EventWorkbookBuilder {
    public static HSSFWorkbook createStubHSSFWorkbook(Workbook workbook) {
        return new StubHSSFWorkbook(workbook);
    }

    public static Workbook createStubWorkbook(ExternSheetRecord[] externs, BoundSheetRecord[] bounds, SSTRecord sst) {
        int i;
        ArrayList<Record> wbRecords = new ArrayList<Record>();
        if (bounds != null) {
            i = 0;
            while (i < bounds.length) {
                wbRecords.add(bounds[i]);
                ++i;
            }
        }
        if (sst != null) {
            wbRecords.add(sst);
        }
        if (externs != null) {
            wbRecords.add(SupBookRecord.createInternalReferences((short)externs.length));
            i = 0;
            while (i < externs.length) {
                wbRecords.add(externs[i]);
                ++i;
            }
        }
        wbRecords.add(EOFRecord.instance);
        return Workbook.createWorkbook(wbRecords);
    }

    public static Workbook createStubWorkbook(ExternSheetRecord[] externs, BoundSheetRecord[] bounds) {
        return EventWorkbookBuilder.createStubWorkbook(externs, bounds, null);
    }

    public static class SheetRecordCollectingListener
    implements HSSFListener {
        private HSSFListener childListener;
        private List boundSheetRecords = new ArrayList();
        private List externSheetRecords = new ArrayList();
        private SSTRecord sstRecord = null;

        public SheetRecordCollectingListener(HSSFListener childListener) {
            this.childListener = childListener;
        }

        public BoundSheetRecord[] getBoundSheetRecords() {
            return this.boundSheetRecords.toArray(new BoundSheetRecord[this.boundSheetRecords.size()]);
        }

        public ExternSheetRecord[] getExternSheetRecords() {
            return this.externSheetRecords.toArray(new ExternSheetRecord[this.externSheetRecords.size()]);
        }

        public SSTRecord getSSTRecord() {
            return this.sstRecord;
        }

        public HSSFWorkbook getStubHSSFWorkbook() {
            return EventWorkbookBuilder.createStubHSSFWorkbook(this.getStubWorkbook());
        }

        public Workbook getStubWorkbook() {
            return EventWorkbookBuilder.createStubWorkbook(this.getExternSheetRecords(), this.getBoundSheetRecords(), this.getSSTRecord());
        }

        public void processRecord(Record record) {
            this.processRecordInternally(record);
            this.childListener.processRecord(record);
        }

        public void processRecordInternally(Record record) {
            if (record instanceof BoundSheetRecord) {
                this.boundSheetRecords.add(record);
            } else if (record instanceof ExternSheetRecord) {
                this.externSheetRecords.add(record);
            } else if (record instanceof SSTRecord) {
                this.sstRecord = (SSTRecord)record;
            }
        }
    }

    private static class StubHSSFWorkbook
    extends HSSFWorkbook {
        private StubHSSFWorkbook(Workbook wb) {
            super(wb);
        }
    }
}

