/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public abstract class PageBreakRecord
extends Record {
    private static final boolean IS_EMPTY_RECORD_WRITTEN = false;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private List _breaks;
    private Map _breakMap;

    protected PageBreakRecord() {
        this._breaks = new ArrayList();
        this._breakMap = new HashMap();
    }

    public PageBreakRecord(RecordInputStream in) {
        int nBreaks = in.readShort();
        this._breaks = new ArrayList(nBreaks + 2);
        this._breakMap = new HashMap();
        int k = 0;
        while (k < nBreaks) {
            Break br = new Break(in);
            this._breaks.add(br);
            this._breakMap.put(new Integer(br.main), br);
            ++k;
        }
    }

    private int getDataSize() {
        return 2 + this._breaks.size() * 6;
    }

    public int getRecordSize() {
        int nBreaks = this._breaks.size();
        if (nBreaks < 1) {
            return 0;
        }
        return 4 + this.getDataSize();
    }

    public final int serialize(int offset, byte[] data) {
        int nBreaks = this._breaks.size();
        if (nBreaks < 1) {
            return 0;
        }
        int dataSize = this.getDataSize();
        LittleEndian.putUShort(data, offset + 0, this.getSid());
        LittleEndian.putUShort(data, offset + 2, dataSize);
        LittleEndian.putUShort(data, offset + 4, nBreaks);
        int pos = 6;
        int i = 0;
        while (i < nBreaks) {
            Break br = (Break)this._breaks.get(i);
            pos += br.serialize(offset + pos, data);
            ++i;
        }
        return 4 + dataSize;
    }

    public int getNumBreaks() {
        return this._breaks.size();
    }

    public final Iterator getBreaksIterator() {
        return this._breaks.iterator();
    }

    public String toString() {
        String subLabel;
        String mainLabel;
        String label;
        StringBuffer retval = new StringBuffer();
        if (this.getSid() == 27) {
            label = "HORIZONTALPAGEBREAK";
            mainLabel = "row";
            subLabel = "col";
        } else {
            label = "VERTICALPAGEBREAK";
            mainLabel = "column";
            subLabel = "row";
        }
        retval.append("[" + label + "]").append("\n");
        retval.append("     .sid        =").append(this.getSid()).append("\n");
        retval.append("     .numbreaks =").append(this.getNumBreaks()).append("\n");
        Iterator iterator = this.getBreaksIterator();
        int k = 0;
        while (k < this.getNumBreaks()) {
            Break region = (Break)iterator.next();
            retval.append("     .").append(mainLabel).append(" (zero-based) =").append(region.main).append("\n");
            retval.append("     .").append(subLabel).append("From    =").append(region.subFrom).append("\n");
            retval.append("     .").append(subLabel).append("To      =").append(region.subTo).append("\n");
            ++k;
        }
        retval.append("[" + label + "]").append("\n");
        return retval.toString();
    }

    public void addBreak(int main, int subFrom, int subTo) {
        Integer key = new Integer(main);
        Break region = (Break)this._breakMap.get(key);
        if (region == null) {
            region = new Break(main, subFrom, subTo);
            this._breakMap.put(key, region);
            this._breaks.add(region);
        } else {
            region.main = main;
            region.subFrom = subFrom;
            region.subTo = subTo;
        }
    }

    public final void removeBreak(int main) {
        Integer rowKey = new Integer(main);
        Break region = (Break)this._breakMap.get(rowKey);
        this._breaks.remove(region);
        this._breakMap.remove(rowKey);
    }

    public final Break getBreak(int main) {
        Integer rowKey = new Integer(main);
        return (Break)this._breakMap.get(rowKey);
    }

    public final int[] getBreaks() {
        int count = this.getNumBreaks();
        if (count < 1) {
            return EMPTY_INT_ARRAY;
        }
        int[] result = new int[count];
        int i = 0;
        while (i < count) {
            Break breakItem = (Break)this._breaks.get(i);
            result[i] = breakItem.main;
            ++i;
        }
        return result;
    }

    public class Break {
        public static final int ENCODED_SIZE = 6;
        public int main;
        public int subFrom;
        public int subTo;

        public Break(int main, int subFrom, int subTo) {
            this.main = main;
            this.subFrom = subFrom;
            this.subTo = subTo;
        }

        public Break(RecordInputStream in) {
            this.main = in.readUShort() - 1;
            this.subFrom = in.readUShort();
            this.subTo = in.readUShort();
        }

        public int serialize(int offset, byte[] data) {
            LittleEndian.putUShort(data, offset + 0, this.main + 1);
            LittleEndian.putUShort(data, offset + 2, this.subFrom);
            LittleEndian.putUShort(data, offset + 4, this.subTo);
            return 6;
        }
    }
}

