/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public final class SeriesListRecord
extends Record {
    public static final short sid = 4118;
    private short[] field_1_seriesNumbers;

    public SeriesListRecord(short[] seriesNumbers) {
        this.field_1_seriesNumbers = seriesNumbers;
    }

    public SeriesListRecord(RecordInputStream in) {
        int nItems = in.readUShort();
        short[] ss = new short[nItems];
        int i = 0;
        while (i < nItems) {
            ss[i] = in.readShort();
            ++i;
        }
        this.field_1_seriesNumbers = ss;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[SERIESLIST]\n");
        buffer.append("    .seriesNumbers= ").append(" (").append(this.getSeriesNumbers()).append(" )");
        buffer.append("\n");
        buffer.append("[/SERIESLIST]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        int nItems = this.field_1_seriesNumbers.length;
        int dataSize = 2 + 2 * nItems;
        LittleEndian.putUShort(data, 0 + offset, 4118);
        LittleEndian.putUShort(data, 2 + offset, dataSize);
        LittleEndian.putUShort(data, 4 + offset, nItems);
        int pos = offset + 6;
        int i = 0;
        while (i < nItems) {
            LittleEndian.putUShort(data, pos, this.field_1_seriesNumbers[i]);
            pos += 2;
            ++i;
        }
        return 4 + dataSize;
    }

    public int getRecordSize() {
        return 4 + this.field_1_seriesNumbers.length * 2 + 2;
    }

    public short getSid() {
        return 4118;
    }

    public Object clone() {
        return new SeriesListRecord((short[])this.field_1_seriesNumbers.clone());
    }

    public short[] getSeriesNumbers() {
        return this.field_1_seriesNumbers;
    }

    public void setSeriesNumbers(short[] field_1_seriesNumbers) {
        this.field_1_seriesNumbers = field_1_seriesNumbers;
    }
}

